/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.admin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.integrations.AnvilManager;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.ui.claim.ClaimMainMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdminAllClaimMenu
extends BaseMenu {
    private static final int CLAIMS_PER_PAGE = 14;
    private static final int[] CLAIM_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final OfflinePlayer target;
    private final boolean sortByNewest;
    private final int page;
    private final List<Claim> selectedClaims;

    public AdminAllClaimMenu(Player player, OfflinePlayer target, boolean sortByNewest, int page, List<Claim> selectedClaims) {
        super("admin_menu.all_claims_menu");
        this.target = target;
        this.sortByNewest = sortByNewest;
        this.page = page;
        this.selectedClaims = new ArrayList<Claim>(selectedClaims);
        this.setupMenu();
        this.displayTo(player);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.addNavigationButton();
        this.addSortButton();
        this.addSearchButton();
        this.addResetButton();
        this.addDeleteButton();
        this.addClaimButtons();
        if (this.hasNextPage()) {
            this.addNextPageButton();
        }
    }

    private void addNavigationButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(AdminAllClaimMenu.this.page == 0 ? AdminAllClaimMenu.this.getMaterialFullPath("back") : AdminAllClaimMenu.this.getMaterialFullPath("previous_page")).name(NClaim.inst().getGuiLangManager().getString((AdminAllClaimMenu.this.page == 0 ? "back" : "previous_page") + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (AdminAllClaimMenu.this.page == 0) {
                    new ClaimMainMenu(player);
                } else {
                    new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page - 1, AdminAllClaimMenu.this.selectedClaims);
                }
            }
        });
    }

    private void addSortButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(AdminAllClaimMenu.this.getStringList("sort_by_date.lore"));
                lore.replaceAll(s -> s.replace("{newest_status}", AdminAllClaimMenu.this.sortByNewest ? "&eNewest First" : "&7Newest First").replace("{oldest_status}", !AdminAllClaimMenu.this.sortByNewest ? "&eOldest First" : "&7Oldest First"));
                return ItemCreator.of(AdminAllClaimMenu.this.getMaterial("sort_by_date")).name(AdminAllClaimMenu.this.getString("sort_by_date.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, !AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page, AdminAllClaimMenu.this.selectedClaims);
            }
        });
    }

    private void addSearchButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(AdminAllClaimMenu.this.getMaterial("search_player")).name(AdminAllClaimMenu.this.getString("search_player.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminAllClaimMenu.this.handleSearch(player);
            }
        });
    }

    private void addResetButton() {
        if (this.target != null || this.page > 0 || !this.selectedClaims.isEmpty()) {
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{14});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(AdminAllClaimMenu.this.getMaterial("reset_settings")).name(AdminAllClaimMenu.this.getString("reset_settings.display_name")).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    new AdminAllClaimMenu(player, null, true, 0, new ArrayList<Claim>());
                }
            });
        }
    }

    private void addDeleteButton() {
        if (!this.selectedClaims.isEmpty()) {
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{15});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(AdminAllClaimMenu.this.getMaterial("delete_selected")).name(AdminAllClaimMenu.this.getString("delete_selected.display_name")).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    Consumer<String> onFinish = result -> {
                        if ("confirmed".equals(result)) {
                            AdminAllClaimMenu.this.selectedClaims.forEach(claim -> claim.remove(RemoveCause.REMOVED_BY_ADMIN));
                            AdminAllClaimMenu.this.selectedClaims.clear();
                            new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page, new ArrayList<Claim>());
                            MessageType.CONFIRM.playSound(player);
                        } else if ("declined".equals(result)) {
                            new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page, AdminAllClaimMenu.this.selectedClaims);
                        }
                    };
                    new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.admin_delete_claim.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.admin_delete_claim.lore"), onFinish);
                }
            });
        }
    }

    private void addNextPageButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(AdminAllClaimMenu.this.getMaterialFullPath("next_page")).name(NClaim.inst().getGuiLangManager().getString("next_page.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page + 1, AdminAllClaimMenu.this.selectedClaims);
            }
        });
    }

    private void addClaimButtons() {
        List<Claim> filteredClaims = this.getFilteredClaims();
        int startIndex = this.page * 14;
        int endIndex = Math.min(startIndex + 14, filteredClaims.size());
        for (int i = startIndex; i < endIndex; ++i) {
            this.addClaimButton(filteredClaims.get(i), i - startIndex);
        }
    }

    private List<Claim> getFilteredClaims() {
        return Claim.getClaims().stream().filter(Objects::nonNull).collect(Collectors.toMap(Claim::getClaimId, claim -> claim, (existing, replacement) -> existing)).values().stream().filter(claim -> this.target == null || claim.getOwner().equals(this.target.getUniqueId())).sorted((c1, c2) -> this.sortByNewest ? Long.compare(c2.getCreatedAt().getTime(), c1.getCreatedAt().getTime()) : Long.compare(c1.getCreatedAt().getTime(), c2.getCreatedAt().getTime())).collect(Collectors.toList());
    }

    private void addClaimButton(final Claim claim, final int index) {
        final Chunk chunk = claim.getChunk();
        final OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)claim.getOwner());
        ClaimSetting settings = claim.getSettings();
        final int enabledSettings = (int)Arrays.stream(Setting.values()).filter(settings::isEnabled).count();
        final int disabledSettings = Setting.values().length - enabledSettings;
        this.addButton(new Button(this){
            final /* synthetic */ AdminAllClaimMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{CLAIM_SLOTS[index]});
            }

            @Override
            public ItemStack getItem() {
                String section = this.this$0.selectedClaims.contains(claim) ? "claim_items.selected" : "claim_items.unselected";
                ArrayList<String> lore = new ArrayList<String>(this.this$0.getStringList(section + ".lore"));
                lore.replaceAll(s -> s.replace("{created_at}", NClaim.serializeDate(claim.getCreatedAt())).replace("{world}", chunk.getWorld().getName()).replace("{coordinates}", NClaim.getCoordinates(chunk)).replace("{land_size}", String.valueOf(claim.getLands().size())).replace("{coop_count}", String.valueOf(claim.getCoopPlayers().size())).replace("{yes}", String.valueOf(enabledSettings)).replace("{no}", String.valueOf(disabledSettings)));
                String materialPath = "guis." + section + ".material";
                ItemStack baseItem = NClaim.inst().getGuiLangManager().getGuiConfig().contains(materialPath) ? NClaim.inst().getGuiLangManager().getMaterial(section) : NClaim.inst().getHeadManager().createHeadFromCache(owner.getUniqueId());
                return ItemCreator.of(baseItem).name(this.this$0.getString(section + ".display_name").replace("{owner}", owner.getName() != null ? owner.getName() : "Unknown")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                this.this$0.handleClaimClick(player, claim, clickType);
            }
        });
    }

    private void handleClaimClick(Player player, Claim claim, ClickType clickType) {
        if (clickType == ClickType.RIGHT) {
            if (this.selectedClaims.contains(claim)) {
                this.selectedClaims.remove(claim);
                MessageType.MENU_DESELECT.playSound(player);
            } else {
                this.selectedClaims.add(claim);
                MessageType.MENU_SELECT.playSound(player);
            }
            new AdminAllClaimMenu(player, this.target, this.sortByNewest, this.page, this.selectedClaims);
        } else if (clickType == ClickType.LEFT) {
            new ClaimManagementMenu(player, claim, true);
        } else if (clickType == ClickType.SHIFT_LEFT) {
            player.closeInventory();
            this.teleportToClaimSafely(player, claim);
        }
    }

    private void handleSearch(Player player) {
        MessageType.SEARCH_OPEN.playSound(player);
        new AnvilManager(player, "Enter a player name", text -> {
            if (text == null || text.isEmpty()) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.enter_a_player"));
                MessageType.FAIL.playSound(player);
                new AdminAllClaimMenu(player, null, this.sortByNewest, this.page, this.selectedClaims);
                return;
            }
            Set<String> matchedNames = AdminAllClaimMenu.getStrings(text);
            if (matchedNames.isEmpty()) {
                MessageType.FAIL.playSound(player);
                new AdminAllClaimMenu(player, this.target, this.sortByNewest, this.page, this.selectedClaims);
                return;
            }
            if (matchedNames.size() == 1) {
                String foundName = matchedNames.iterator().next();
                OfflinePlayer target = null;
                for (OfflinePlayer offline : Bukkit.getOfflinePlayers()) {
                    if (offline.getName() == null || !offline.getName().equals(foundName)) continue;
                    target = offline;
                    break;
                }
                new AdminAllClaimMenu(player, target, this.sortByNewest, 0, this.selectedClaims);
            } else {
                new AdminAllClaimMenu(player, null, this.sortByNewest, 0, this.selectedClaims);
            }
        });
    }

    @NotNull
    private static Set<String> getStrings(String text) {
        HashSet<String> matchedNames = new HashSet<String>();
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.getName().toLowerCase().startsWith(text.toLowerCase())) continue;
            matchedNames.add(online.getName());
        }
        for (OfflinePlayer offline : Bukkit.getOfflinePlayers()) {
            String name = offline.getName();
            if (name == null || !name.toLowerCase().startsWith(text.toLowerCase())) continue;
            matchedNames.add(name);
        }
        return matchedNames;
    }

    private void teleportToClaimSafely(Player player, Claim claim) {
        Location claimBlockLocation = claim.getClaimBlockLocation();
        World world = claimBlockLocation.getWorld();
        if (world == null) {
            return;
        }
        Location safeLoc = new Location(world, claimBlockLocation.getX() + 0.5, claimBlockLocation.getY() + 1.0, claimBlockLocation.getZ() + 0.5);
        while (safeLoc.getY() < (double)world.getMaxHeight() && !safeLoc.getBlock().getType().isSolid()) {
            safeLoc.setY(safeLoc.getY() + 1.0);
        }
        if (!safeLoc.getBlock().getType().isSolid()) {
            safeLoc.setY((double)(world.getHighestBlockYAt(safeLoc) + 1));
        }
        if (safeLoc.getY() < claimBlockLocation.getY()) {
            safeLoc.setY(claimBlockLocation.getY() + 1.0);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)NClaim.inst(), () -> {
            MessageType.TELEPORT.playSound(player);
            player.teleport(safeLoc);
        }, 1L);
    }

    private boolean hasNextPage() {
        return this.getFilteredClaims().size() > (this.page + 1) * 14;
    }
}

