/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminAllClaimMenu;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopListMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimSettingsMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.LandExpansionMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ManageClaimBlockMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.TimeManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimManagementMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    private final Player player;
    private final boolean admin;

    public ClaimManagementMenu(Player player, @NotNull Claim claim, boolean admin) {
        super("claim_management_menu");
        this.claim = claim;
        this.player = player;
        this.admin = admin;
        this.setupMenu();
        this.displayTo(player);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_3_ROWS, this.getString("title"));
        if (this.admin) {
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{10});
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(ClaimManagementMenu.this.getMaterialFullPath("back")).name(NClaim.inst().getGuiLangManager().getString("back.display_name")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    new AdminAllClaimMenu(p, null, true, 0, new ArrayList<Claim>());
                }
            });
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return ClaimManagementMenu.this.admin ? Sets.newHashSet((Object[])new Integer[]{12}) : Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimManagementMenu.this.getMaterial("expand")).name(ClaimManagementMenu.this.getString("expand.display_name")).lore(ClaimManagementMenu.this.getStringList("expand.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!(ClaimManagementMenu.this.claim.isOwner(player.getUniqueId()) || ClaimManagementMenu.this.admin || NClaim.inst().getClaimCoopManager().hasPermission(player, ClaimManagementMenu.this.claim, Permission.EXPAND_CLAIM))) {
                    ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                    return;
                }
                MessageType.MENU_FORWARD.playSound(player);
                new LandExpansionMenu(player, ClaimManagementMenu.this.claim, ClaimManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return ClaimManagementMenu.this.admin ? Sets.newHashSet((Object[])new Integer[]{13}) : Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimManagementMenu.this.getMaterial("time")).name(ClaimManagementMenu.this.getString("time.display_name")).lore(ClaimManagementMenu.this.getStringList("time.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!(ClaimManagementMenu.this.claim.isOwner(player.getUniqueId()) || ClaimManagementMenu.this.admin || NClaim.inst().getClaimCoopManager().hasPermission(player, ClaimManagementMenu.this.claim, Permission.EXTEND_EXPIRATION))) {
                    ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                    return;
                }
                MessageType.MENU_FORWARD.playSound(player);
                new TimeManagementMenu(player, 0, 0, 0, 0, ClaimManagementMenu.this.claim, ClaimManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return ClaimManagementMenu.this.admin ? Sets.newHashSet((Object[])new Integer[]{14}) : Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimManagementMenu.this.getMaterial("coop")).name(ClaimManagementMenu.this.getString("coop.display_name")).lore(ClaimManagementMenu.this.getStringList("coop.lore")).flags(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!(ClaimManagementMenu.this.claim.isOwner(player.getUniqueId()) || ClaimManagementMenu.this.admin || NClaim.inst().getClaimCoopManager().hasPermission(player, ClaimManagementMenu.this.claim, Permission.ADD_COOP))) {
                    ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                    return;
                }
                MessageType.MENU_FORWARD.playSound(player);
                new CoopListMenu(player, ClaimManagementMenu.this.claim, ClaimManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return ClaimManagementMenu.this.admin ? Sets.newHashSet((Object[])new Integer[]{15}) : Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimManagementMenu.this.getMaterial("setting")).name(ClaimManagementMenu.this.getString("setting.display_name")).lore(ClaimManagementMenu.this.getStringList("setting.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!(ClaimManagementMenu.this.claim.isOwner(player.getUniqueId()) || ClaimManagementMenu.this.admin || NClaim.inst().getClaimCoopManager().hasPermission(player, ClaimManagementMenu.this.claim, Permission.MANAGE_SETTINGS))) {
                    ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                    return;
                }
                MessageType.MENU_FORWARD.playSound(player);
                new ClaimSettingsMenu(player, ClaimManagementMenu.this.claim, 0, ClaimManagementMenu.this.admin);
            }
        });
        if (!this.admin) {
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{14});
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(ClaimManagementMenu.this.getMaterial("type")).name(ClaimManagementMenu.this.getString("type.display_name")).lore(ClaimManagementMenu.this.getStringList("type.lore")).flags(ItemFlag.values()).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    if (!ClaimManagementMenu.this.claim.isOwner(player.getUniqueId()) && !NClaim.inst().getClaimCoopManager().hasPermission(player, ClaimManagementMenu.this.claim, Permission.MANAGE_CLAIM_BLOCK_TYPES)) {
                        ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                        return;
                    }
                    MessageType.MENU_FORWARD.playSound(player);
                    new ManageClaimBlockMenu(ClaimManagementMenu.this.claim, player, 0);
                }
            });
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimManagementMenu.this.getMaterial("delete")).name(ClaimManagementMenu.this.getString("delete.display_name")).lore(ClaimManagementMenu.this.getStringList("delete.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!ClaimManagementMenu.this.claim.isOwner(player.getUniqueId()) && !ClaimManagementMenu.this.admin) {
                    ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                    return;
                }
                new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.delete_claim.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.delete_claim.lore"), result -> {
                    if ("confirmed".equals(result)) {
                        ClaimManagementMenu.this.claim.remove(RemoveCause.UNCLAIM);
                        player.closeInventory();
                    } else if ("declined".equals(result)) {
                        new ClaimManagementMenu(player, ClaimManagementMenu.this.claim, ClaimManagementMenu.this.admin);
                    }
                });
            }
        });
    }
}

