/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandExpansionMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    @NotNull
    private final Collection<Chunk> allClaimChunks;
    private final boolean admin;
    private final int baseSlot;

    private LandExpansionMenu(@NotNull Player player, @NotNull Claim claim, boolean admin, int baseSlot) {
        super("claim_expand_menu");
        this.claim = claim;
        this.allClaimChunks = claim.getAllChunks();
        this.admin = admin;
        this.baseSlot = baseSlot;
        this.setupMenu(player);
    }

    public LandExpansionMenu(@NotNull Player player, @NotNull Claim claim, boolean admin) {
        this(player, claim, admin, 22);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu(Player player) {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{LandExpansionMenu.this.baseSlot});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(LandExpansionMenu.this.claim.getClaimBlockType()).name(LandExpansionMenu.this.getString("center.display_name")).lore(LandExpansionMenu.this.getStringList("center.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                new ClaimManagementMenu(player, LandExpansionMenu.this.claim, LandExpansionMenu.this.admin);
            }
        });
        for (final Scroller scroller : Scroller.SCROLLERS) {
            this.addButton(new Button(this){
                final /* synthetic */ LandExpansionMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                @NotNull
                protected Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{scroller.getSlot()});
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    String directionKey = "scroll_button.directions." + scroller.getType().name();
                    String localizedDirection = NClaim.inst().getGuiLangManager().getString(directionKey);
                    return ItemCreator.of(Material.OAK_BUTTON).name(this.this$0.getString("scroll_button.display_name").replace("{direction}", localizedDirection)).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    if (!this.this$0.canScroll(scroller)) {
                        return;
                    }
                    new LandExpansionMenu(p, this.this$0.claim, this.this$0.admin, this.this$0.baseSlot + scroller.getSlotAddition());
                }
            });
        }
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slot = row * 9 + col;
                if (slot == this.baseSlot || slot % 9 == 0 || slot % 9 == 8) continue;
                this.addChunkButton(slot, player);
            }
        }
        this.displayTo(player);
    }

    private void addChunkButton(int slot, Player player) {
        ItemStack material;
        String configPath;
        Chunk thatChunk = this.findChunkFromSlot(slot, player);
        Claim thatClaim = Claim.getClaim(thatChunk);
        boolean clickable = false;
        if (this.admin) {
            if (thatClaim == null) {
                configPath = "expand";
                material = this.getMaterial("expand");
                clickable = true;
            } else {
                if (thatClaim.equals(this.claim)) {
                    configPath = "claimed";
                    material = this.getMaterial("claimed");
                } else {
                    configPath = "claimed_another_player";
                    material = this.getMaterial("claimed_another_player");
                }
                clickable = true;
            }
        } else if (!this.isAdjacentToClaim(thatChunk)) {
            configPath = "not_adjacent";
            material = this.getMaterial("not_adjacent");
        } else if (thatClaim == null) {
            configPath = "expand";
            material = this.getMaterial("expand");
            clickable = true;
        } else if (this.claim.getLands().contains(NClaim.serializeChunk(thatChunk))) {
            configPath = "claimed";
            material = this.getMaterial("claimed");
            clickable = true;
        } else {
            configPath = "claimed_another_player";
            material = this.getMaterial("claimed_another_player");
        }
        this.addButton(this.createButton(slot, configPath, material, thatChunk, clickable));
    }

    private Button createButton(final int slot, final String configPath, final ItemStack material, final Chunk thatChunk, final boolean clickable) {
        return new Button(this){
            final /* synthetic */ LandExpansionMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{slot});
            }

            @Override
            public ItemStack getItem() {
                double landPrice = this.this$0.calculateChunkPrice(thatChunk);
                String displayName = this.this$0.getString(configPath + ".display_name");
                ArrayList<String> lore = new ArrayList<String>(this.this$0.getStringList(configPath + ".lore"));
                if (configPath.equals("expand")) {
                    String priceStr = this.this$0.admin ? NClaim.inst().getGuiLangManager().getString("free") : (landPrice < 0.0 ? "N/A" : String.valueOf(landPrice));
                    lore.replaceAll(s -> s.replace("{price}", priceStr));
                }
                return ItemCreator.of(material).name(displayName).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!clickable) {
                    return;
                }
                if (clickType.isLeftClick() && this.this$0.getInvItem(slot).getType() == Material.BROWN_WOOL) {
                    Consumer<String> onFinish = result -> {
                        if ("confirmed".equals(result)) {
                            NClaim.inst().getClaimService().buyLand(this.this$0.claim, player, thatChunk, this.this$0.admin);
                            new LandExpansionMenu(player, this.this$0.claim, this.this$0.admin);
                        } else if ("declined".equals(result)) {
                            new LandExpansionMenu(player, this.this$0.claim, this.this$0.admin);
                        }
                    };
                    new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.claim_expand.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.claim_expand.lore").stream().map(s -> s.replace("{price}", String.valueOf(this.this$0.calculateChunkPrice(thatChunk)))).collect(Collectors.toList()), onFinish);
                } else if (clickType.isRightClick() && this.this$0.getInvItem(slot).getType() == Material.GREEN_WOOL || clickType.isRightClick() && this.this$0.getInvItem(slot).getType() == Material.BROWN_WOOL) {
                    player.closeInventory();
                    NClaim.inst().getClaimVisualizerService().showClaimBorders(player, thatChunk);
                }
            }
        };
    }

    private double calculateChunkPrice(Chunk targetChunk) {
        int currentChunkCount = 1 + this.claim.getLands().size();
        int nextChunkNumber = currentChunkCount + 1;
        return NClaim.inst().getNconfig().getTieredPrice(nextChunkNumber);
    }

    private boolean isAdjacentToClaim(@NotNull Chunk thatChunk) {
        return this.allClaimChunks.stream().anyMatch(c -> c != null && NClaim.isChunkAdjacent(c, thatChunk, 2));
    }

    private Chunk findChunkFromSlot(int slot, Player player) {
        int rotatedZ;
        int rotatedX;
        int chunkX = this.claim.getChunk().getX();
        int chunkZ = this.claim.getChunk().getZ();
        int centerRow = this.baseSlot / 9;
        int centerCol = this.baseSlot % 9;
        int row = slot / 9;
        int col = slot % 9;
        int deltaX = col - centerCol;
        int deltaZ = row - centerRow;
        float yaw = player.getLocation().getYaw();
        if ((yaw = (yaw % 360.0f + 360.0f) % 360.0f) >= 315.0f || yaw < 45.0f) {
            rotatedX = deltaX;
            rotatedZ = -deltaZ;
        } else if (yaw >= 45.0f && yaw < 135.0f) {
            rotatedX = -deltaZ;
            rotatedZ = -deltaX;
        } else if (yaw >= 135.0f && yaw < 225.0f) {
            rotatedX = -deltaX;
            rotatedZ = deltaZ;
        } else {
            rotatedX = deltaZ;
            rotatedZ = deltaX;
        }
        return this.claim.getChunk().getWorld().getChunkAt(chunkX += rotatedX, chunkZ += rotatedZ);
    }

    private boolean canScroll(Scroller scroller) {
        if (scroller == null) {
            return false;
        }
        switch (scroller.getType().ordinal()) {
            case 0: {
                return this.baseSlot % 9 < 7;
            }
            case 1: {
                return this.baseSlot % 9 > 1;
            }
            case 2: {
                return this.baseSlot / 9 < 4;
            }
            case 3: {
                return this.baseSlot / 9 > 0;
            }
        }
        return false;
    }

    private static class Scroller {
        public static final Scroller LEFT = new Scroller(Type.LEFT, 46, 1);
        public static final Scroller RIGHT = new Scroller(Type.RIGHT, 52, -1);
        public static final Scroller UP = new Scroller(Type.UP, 50, 9);
        public static final Scroller DOWN = new Scroller(Type.DOWN, 48, -9);
        public static final Scroller[] SCROLLERS = new Scroller[]{LEFT, RIGHT, UP, DOWN};
        private final Type type;
        private final int slot;
        private final int slotAddition;

        protected Scroller(Type type, int slot, int slotAddition) {
            this.type = type;
            this.slot = slot;
            this.slotAddition = slotAddition;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public int getSlot() {
            return this.slot;
        }

        @Generated
        public int getSlotAddition() {
            return this.slotAddition;
        }

        static enum Type {
            LEFT,
            RIGHT,
            UP,
            DOWN;

        }
    }
}

