/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.libs.nbtapi.NBT;
import nesoi.aysihuniks.libs.nbtapi.iface.ReadWriteNBT;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.HeadProvider;
import nesoi.aysihuniks.nclaim.model.User;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadManager {
    private final HeadProvider headProvider;
    private final int version = NClaim.inst().getWrapper().getVersion();
    private final SkinsRestorer skinsRestorer = this.getSkinsRestorerInstance();
    private final boolean skinRestorerHooked = this.skinsRestorer != null;
    private final Map<UUID, String> skinTextureCache;
    private final Map<UUID, ItemStack> headCache;
    private final Map<UUID, Long> textureFetchCooldown;
    private static final long COOLDOWN_MS = 3600000L;

    public HeadManager() {
        this.headProvider = this.skinRestorerHooked ? HeadProvider.SKINRESTORER : HeadProvider.NBTAPI;
        this.skinTextureCache = new HashMap<UUID, String>();
        this.headCache = new HashMap<UUID, ItemStack>();
        this.textureFetchCooldown = new HashMap<UUID, Long>();
        Util.log("&aHeadManager enabled successfully! Using " + this.headProvider.name() + " for heads.");
    }

    private SkinsRestorer getSkinsRestorerInstance() {
        try {
            return (SkinsRestorer)Bukkit.getPluginManager().getPlugin("SkinsRestorer");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getSkinTextureValue(@NotNull UUID uuid, boolean forceFetch) {
        Long lastFetched = this.textureFetchCooldown.get(uuid);
        if (!forceFetch && lastFetched != null && System.currentTimeMillis() - lastFetched < 3600000L) {
            User user = User.getUser(uuid);
            if (user != null && user.getSkinTexture() != null) {
                return user.getSkinTexture();
            }
            return this.skinTextureCache.get(uuid);
        }
        User user = User.getUser(uuid);
        if (user != null && user.getSkinTexture() != null) {
            return user.getSkinTexture();
        }
        String cachedTexture = this.skinTextureCache.get(uuid);
        if (cachedTexture != null || this.skinTextureCache.containsKey(uuid)) {
            return cachedTexture;
        }
        String texture = null;
        if (this.skinRestorerHooked) {
            OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            PlayerStorage storage = this.skinsRestorer.getPlayerStorage();
            try {
                Optional property = storage.getSkinForPlayer(uuid, offPlayer.getName());
                if (property.isPresent()) {
                    String textureURL = PropertyUtils.getSkinTextureUrl((SkinProperty)((SkinProperty)property.get()));
                    String json = "{\"textures\":{\"SKIN\":{\"url\":\"" + textureURL + "\"}}}";
                    texture = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception property) {}
        } else {
            try {
                URL url_0 = new URL("https://api.mojang.com/users/profiles/minecraft/" + Bukkit.getOfflinePlayer((UUID)uuid).getName());
                InputStreamReader reader_0 = new InputStreamReader(url_0.openStream());
                String id = JsonParser.parseReader((Reader)reader_0).getAsJsonObject().get("id").getAsString();
                URL url_1 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + id + "?unsigned=false");
                InputStreamReader reader_1 = new InputStreamReader(url_1.openStream());
                JsonObject textureProperty = JsonParser.parseReader((Reader)reader_1).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
                texture = textureProperty.get("value").getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.textureFetchCooldown.put(uuid, System.currentTimeMillis());
        this.skinTextureCache.put(uuid, texture);
        if (user != null && texture != null) {
            user.setSkinTexture(texture);
            User.saveUser(uuid);
        }
        return texture;
    }

    public ItemStack createHead(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        ItemStack cachedHead = this.headCache.get(uuid);
        if (cachedHead != null) {
            return cachedHead.clone();
        }
        ItemStack defaultHead = new ItemStack(Material.PLAYER_HEAD);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)NClaim.inst(), () -> {
            String texture = this.getSkinTextureValue(uuid, false);
            if (texture != null) {
                ItemStack head = this.createHeadWithTexture(texture);
                this.headCache.put(uuid, head);
            }
        });
        return defaultHead;
    }

    public ItemStack createHeadFromCache(UUID uuid) {
        ItemStack cachedHead = this.headCache.get(uuid);
        if (cachedHead != null) {
            return cachedHead.clone();
        }
        String texture = this.skinTextureCache.get(uuid);
        if (texture == null) {
            User user = User.getUser(uuid);
            if (user == null) {
                User.loadUser(uuid);
                user = User.getUser(uuid);
            }
            if (user != null && user.getSkinTexture() != null) {
                texture = user.getSkinTexture();
                this.skinTextureCache.put(uuid, texture);
            }
        }
        if (texture != null) {
            ItemStack head = this.createHeadWithTexture(texture);
            this.headCache.put(uuid, head);
            return head;
        }
        ItemStack defaultHead = new ItemStack(Material.PLAYER_HEAD);
        this.headCache.put(uuid, defaultHead);
        return defaultHead;
    }

    public ItemStack createHeadWithTexture(String texture) {
        try {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            if (this.version > 204) {
                NBT.modifyComponents(head, nbt -> {
                    ReadWriteNBT profileNbt = nbt.getOrCreateCompound("minecraft:profile");
                    profileNbt.setUUID("id", UUID.randomUUID());
                    ReadWriteNBT propertiesNbt = profileNbt.getCompoundList("properties").addCompound();
                    propertiesNbt.setString("name", "textures");
                    propertiesNbt.setString("value", texture);
                });
            } else {
                NBT.modify(head, nbt -> {
                    ReadWriteNBT skullOwnerCompound = nbt.getOrCreateCompound("SkullOwner");
                    skullOwnerCompound.setUUID("Id", UUID.randomUUID());
                    skullOwnerCompound.getOrCreateCompound("Properties").getCompoundList("textures").addCompound().setString("Value", texture);
                });
            }
            return head;
        }
        catch (Exception e) {
            Util.log("HeadManager error creating head with NBTAPI: " + e.getMessage());
            return new ItemStack(Material.PLAYER_HEAD);
        }
    }

    public void preloadTexturesAsync(Collection<UUID> uuids) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)NClaim.inst(), () -> {
            for (UUID uuid : uuids) {
                String texture = this.getSkinTextureValue(uuid, false);
                if (texture != null) {
                    ItemStack head = this.createHeadWithTexture(texture);
                    this.headCache.put(uuid, head);
                    continue;
                }
                ItemStack defaultHead = new ItemStack(Material.PLAYER_HEAD);
                this.headCache.put(uuid, defaultHead);
            }
        });
    }

    @Generated
    public HeadProvider getHeadProvider() {
        return this.headProvider;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public SkinsRestorer getSkinsRestorer() {
        return this.skinsRestorer;
    }

    @Generated
    public boolean isSkinRestorerHooked() {
        return this.skinRestorerHooked;
    }

    @Generated
    public Map<UUID, String> getSkinTextureCache() {
        return this.skinTextureCache;
    }

    @Generated
    public Map<UUID, ItemStack> getHeadCache() {
        return this.headCache;
    }

    @Generated
    public Map<UUID, Long> getTextureFetchCooldown() {
        return this.textureFetchCooldown;
    }
}

