/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuListener;
import nesoi.aysihuniks.libs.dapi.service.RelocateService;
import nesoi.aysihuniks.libs.dapi.shaded.bstats.bukkit.Metrics;
import nesoi.aysihuniks.libs.dapi.shaded.bstats.charts.SimplePie;
import nesoi.aysihuniks.libs.dapi.util.DAPIException;
import nesoi.aysihuniks.libs.dapi.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DAPI {
    public static final String VERSION = "1.4.2";
    public static final String GUI_METADATA_KEY = "DAPI_GUI_" + Util.generateRandomLowerCaseString(8);
    private static boolean init = false;
    private static Plugin plugin;
    private static boolean metricsRegistered;
    @ApiStatus.Obsolete(since="1.2.5")
    @NotNull
    public static String missingArgsMsg;

    private DAPI() {
    }

    private static void init() {
        if (init) {
            return;
        }
        init = true;
        if (!RelocateService.isDAPIRelocated()) {
            Util.logInternal("DAPI was not relocated. It is recommended to relocate it to avoid potential conflicts with other plugins that also include DAPI.");
        }
        if (RelocateService.isbStatsRelocated()) {
            DAPI.registerMetrics();
        }
    }

    public static void registerMenuListener() {
        Bukkit.getPluginManager().registerEvents((Listener)new MenuListener(), DAPI.getPlugin());
    }

    @NotNull
    public static Plugin getPlugin() {
        if (plugin != null) {
            return plugin;
        }
        String pluginName = DAPI.forcePluginName();
        Plugin foundPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (foundPlugin == null) {
            throw new DAPIException("Plugin not found with name '" + pluginName + "'!");
        }
        plugin = foundPlugin;
        DAPI.init();
        return plugin;
    }

    @NotNull
    private static String forcePluginName() {
        String pluginName = DAPI.findPluginName();
        if (pluginName != null) {
            return pluginName;
        }
        throw new DAPIException("Plugin name not found! To developer who uses DAPI, please check your plugin file (either 'plugin.yml' or 'paper-plugin.yml') and ensure it has 'name' key there.");
    }

    @Nullable
    private static String findPluginName() {
        ClassLoader loader = DAPI.class.getClassLoader();
        for (String pluginFile : List.of("plugin.yml", "paper-plugin.yml")) {
            try {
                InputStream stream = loader.getResourceAsStream(pluginFile);
                if (stream == null) continue;
                InputStreamReader reader = new InputStreamReader(stream);
                YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
                return config.getString("name");
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static void registerMetrics() {
        if (metricsRegistered) {
            return;
        }
        metricsRegistered = true;
        try {
            Metrics metrics = new Metrics(plugin, 24974);
            metrics.addCustomChart(new SimplePie("dapi_version", () -> VERSION));
            Util.logInternal("Registered bStats metrics for DAPI using plugin '" + plugin.getName() + "'.");
        }
        catch (Exception e) {
            Util.logInternal("Failed to register bStats metrics for DAPI using plugin '" + plugin.getName() + "'. " + String.valueOf(e));
        }
    }

    @NotNull
    @Generated
    public static String getMissingArgsMsg() {
        return missingArgsMsg;
    }

    @Generated
    public static void setMissingArgsMsg(@NotNull String missingArgsMsg) {
        if (missingArgsMsg == null) {
            throw new NullPointerException("missingArgsMsg is marked non-null but is null");
        }
        DAPI.missingArgsMsg = missingArgsMsg;
    }

    static {
        metricsRegistered = false;
        missingArgsMsg = "";
    }
}

