/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.color;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.color.DStyle;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.bukkit.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class DColor
implements DStyle {
    public static final String LEGACY_COLOR_CODES = "0123456789ABCDEF";
    public static final char LEGACY_HEX_CHAR = 'x';
    public static final char MINIMESSAGE_HEX_CHAR = '#';
    private static final Map<String, DColor> LEGACY_CODE_MAP = new HashMap<String, DColor>();
    private static final Map<String, DColor> MINIMESSAGE_FORMAT_MAP = new HashMap<String, DColor>();
    public static final DColor AQUA = new DColor(Color.fromRGB((int)0x55FFFF), "b", "<aqua>");
    public static final DColor BLACK = new DColor(Color.fromRGB((int)0), "0", "<black>");
    public static final DColor BLUE = new DColor(Color.fromRGB((int)0x5555FF), "9", "<blue>");
    public static final DColor DARK_AQUA = new DColor(Color.fromRGB((int)43690), "3", "<dark_aqua>");
    public static final DColor DARK_BLUE = new DColor(Color.fromRGB((int)170), "1", "<dark_blue>");
    public static final DColor DARK_GRAY = new DColor(Color.fromRGB((int)0x555555), "8", "<dark_gray>");
    public static final DColor DARK_GREEN = new DColor(Color.fromRGB((int)43520), "2", "<dark_green>");
    public static final DColor DARK_PURPLE = new DColor(Color.fromRGB((int)0xAA00AA), "5", "<dark_purple>");
    public static final DColor DARK_RED = new DColor(Color.fromRGB((int)0xAA0000), "4", "<dark_red>");
    public static final DColor GRAY = new DColor(Color.fromRGB((int)0xAAAAAA), "7", "<gray>");
    public static final DColor GOLD = new DColor(Color.fromRGB((int)0xFFAA00), "6", "<gold>");
    public static final DColor GREEN = new DColor(Color.fromRGB((int)0x55FF55), "a", "<green>");
    public static final DColor LIGHT_PURPLE = new DColor(Color.fromRGB((int)0xFF55FF), "d", "<light purple>");
    public static final DColor RED = new DColor(Color.fromRGB((int)0xFF5555), "c", "<red>");
    public static final DColor WHITE = new DColor(Color.fromRGB((int)0xFFFFFF), "f", "<white>");
    public static final DColor YELLOW = new DColor(Color.fromRGB((int)0xFFFF55), "e", "<yellow>");
    @NotNull
    private final Color color;
    @NotNull
    private final String legacyCode;
    @NotNull
    private final String miniMessageFormat;

    private DColor(Color color, String legacyCode, String miniMessageFormat) {
        Validate.notNull(color, "Color cannot be null.");
        Validate.notNull(legacyCode, "Legacy code cannot be null.");
        Validate.notNull(miniMessageFormat, "MiniMessage format cannot be null.");
        this.color = color;
        this.legacyCode = legacyCode;
        this.miniMessageFormat = miniMessageFormat;
        LEGACY_CODE_MAP.put(legacyCode, this);
        MINIMESSAGE_FORMAT_MAP.put(miniMessageFormat, this);
    }

    @Override
    @NotNull
    public String insertLegacyStyleChar() {
        return this.legacyCode.replaceAll(".", "\u00a7$0");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DColor dColor = (DColor)o;
        return Objects.equals(this.legacyCode, dColor.legacyCode) && Objects.equals(this.color, dColor.color) && Objects.equals(this.miniMessageFormat, dColor.miniMessageFormat);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.legacyCode, this.miniMessageFormat);
    }

    @NotNull
    private static DColor of(String hexString, Color color) {
        return new DColor(color, "x" + hexString, "<#" + hexString + ">");
    }

    @NotNull
    public static DColor of(Color color) {
        Validate.notNull(color, "Color cannot be null.");
        String hexString = Validate.validateReturn(() -> String.format("%06X", color.asRGB()), "Invalid hex color.");
        return DColor.of(hexString, color);
    }

    @NotNull
    public static DColor of(int rgb) {
        Color color = Validate.validateReturn(() -> Color.fromRGB((int)rgb), "Invalid rgb color.");
        return DColor.of(color);
    }

    @NotNull
    public static DColor of(String hexString) {
        Validate.notNull(hexString, "Hex string cannot be null.");
        Validate.validate(hexString.length() == 7 && hexString.charAt(0) == '#', "Invalid hex string.");
        int rgb = Validate.validateReturn(() -> Integer.parseInt(hexString.substring(1), 16), "Invalid hex format.");
        return DColor.of(rgb);
    }

    @NotNull
    public static DColor interpolate(DColor start, DColor end, float ratio) {
        return DColor.interpolate(start.getColor(), end.getColor(), ratio);
    }

    @NotNull
    public static DColor interpolate(Color start, Color end, float ratio) {
        Validate.notNull(start, "Start color cannot be null.");
        Validate.notNull(end, "End color cannot be null.");
        Validate.validate(ratio >= 0.0f && ratio <= 1.0f, "Ratio must be between 0 and 1.");
        int red = (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()));
        int green = (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()));
        int blue = (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()));
        return DColor.of(Color.fromRGB((int)red, (int)green, (int)blue));
    }

    @Nullable
    public static DColor getByLegacyCode(String legacyCode) {
        Validate.notNull(legacyCode, "Legacy code cannot be null.");
        if (LEGACY_CODE_MAP.containsKey(legacyCode)) {
            return LEGACY_CODE_MAP.get(legacyCode);
        }
        if (legacyCode.length() == 7 && legacyCode.charAt(0) == 'x') {
            return DColor.of("#" + legacyCode.substring(1));
        }
        return null;
    }

    @Nullable
    public static DColor getByMiniMessageFormat(String miniMessageFormat) {
        Validate.notNull(miniMessageFormat, "miniMessage format cannot be null.");
        return MINIMESSAGE_FORMAT_MAP.get(miniMessageFormat);
    }

    @NotNull
    @Generated
    public Color getColor() {
        return this.color;
    }

    @NotNull
    @Generated
    public String getLegacyCode() {
        return this.legacyCode;
    }

    @NotNull
    @Generated
    public String getMiniMessageFormat() {
        return this.miniMessageFormat;
    }
}

