/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.color;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.color.DStyle;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class DDecoration
implements DStyle {
    public static final String LEGACY_DECORATION_CODES = "KLMNOR";
    public static final String MINI_MESSAGE_CLEAR = "<!b><!i><!obf><!st><!u>";
    private static final Map<String, DDecoration> LEGACY_CODE_MAP = new HashMap<String, DDecoration>();
    private static final Map<String, DDecoration> MINIMESSAGE_FORMAT_MAP = new HashMap<String, DDecoration>();
    public static final DDecoration BOLD = new DDecoration("l", "<bold>");
    public static final DDecoration ITALIC = new DDecoration("o", "<italic>");
    public static final DDecoration OBFUSCATED = new DDecoration("k", "<obfuscated>");
    public static final DDecoration RESET = new DDecoration("r", "<reset>");
    public static final DDecoration STRIKETHROUGH = new DDecoration("m", "<strikethrough>");
    public static final DDecoration UNDERLINED = new DDecoration("n", "<underlined>");
    private final String legacyCode;
    private final String miniMessageFormat;

    private DDecoration(String legacyCode, String miniMessageFormat) {
        this.legacyCode = legacyCode;
        this.miniMessageFormat = miniMessageFormat;
        LEGACY_CODE_MAP.put(legacyCode, this);
        MINIMESSAGE_FORMAT_MAP.put(miniMessageFormat, this);
    }

    @Override
    @NotNull
    public String insertLegacyStyleChar() {
        return this.legacyCode.replaceAll(".", "\u00a7$0");
    }

    @Nullable
    public static DDecoration getByLegacyCode(String legacyCode) {
        Validate.notNull(legacyCode, "Legacy code cannot be null.");
        return LEGACY_CODE_MAP.get(legacyCode);
    }

    @Nullable
    public static DDecoration getByMiniMessageFormat(String miniMessageFormat) {
        Validate.notNull(miniMessageFormat, "miniMessage format cannot be null.");
        return MINIMESSAGE_FORMAT_MAP.get(miniMessageFormat);
    }

    @Generated
    public String getLegacyCode() {
        return this.legacyCode;
    }

    @Generated
    public String getMiniMessageFormat() {
        return this.miniMessageFormat;
    }
}

