/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.color;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nesoi.aysihuniks.libs.dapi.color.DColor;
import nesoi.aysihuniks.libs.dapi.color.DDecoration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class StyleTranslator {
    private static final Pattern CUSTOM_GRADIENT_PATTERN = Pattern.compile("<&(#[0-9A-Fa-f]{6})>(.*?)</&(#[0-9A-Fa-f]{6})>");
    @ApiStatus.Obsolete
    private static final Pattern CUSTOM_GRADIENT_PATTERN_2 = Pattern.compile("<(#[0-9A-Fa-f]{6})>(.*?)</(#[0-9A-Fa-f]{6})>");
    private static final Pattern CUSTOM_HEX_PATTERN = Pattern.compile("&(#[0-9A-Fa-f]{6})");
    @ApiStatus.Obsolete
    private static final Pattern CUSTOM_HEX_PATTERN_2 = Pattern.compile("<(#[0-9A-Fa-f]{6})>");
    private static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("\u00a7([0-9A-Fa-f])");
    private static final Pattern LEGACY_DECORATION_PATTERN = Pattern.compile("\u00a7([K-Ok-oRr])");
    private static final Pattern LEGACY_STYLE_PATTERN = Pattern.compile("\u00a7([0-9A-Fa-fK-Ok-oRr])");
    private static final Pattern LEGACY_HEX_COLOR_PATTERN = Pattern.compile("\u00a7x((\u00a7[0-9A-Fa-f]){6})");

    @NotNull
    public static String applyGradient(String input) {
        DColor color;
        float ratio;
        int i;
        StringBuilder builder;
        DColor endColor;
        DColor startColor2;
        String end;
        String content;
        String start;
        String original;
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        Matcher matcher = CUSTOM_GRADIENT_PATTERN.matcher(output);
        while (matcher.find()) {
            original = matcher.group();
            start = matcher.group(1);
            content = matcher.group(2);
            end = matcher.group(3);
            try {
                startColor2 = DColor.of(start);
                endColor = DColor.of(end);
                builder = new StringBuilder();
                for (i = 0; i < content.length(); ++i) {
                    ratio = (float)i / Math.max(1.0f, (float)(content.length() - 1));
                    color = DColor.interpolate(startColor2, endColor, ratio);
                    builder.append(color.insertLegacyStyleChar()).append(content.charAt(i));
                }
                output = output.replace(original, builder.toString());
            }
            catch (Exception startColor2) {}
        }
        matcher = CUSTOM_GRADIENT_PATTERN_2.matcher(output);
        while (matcher.find()) {
            original = matcher.group();
            start = matcher.group(1);
            content = matcher.group(2);
            end = matcher.group(3);
            try {
                startColor2 = DColor.of(start);
                endColor = DColor.of(end);
                builder = new StringBuilder();
                for (i = 0; i < content.length(); ++i) {
                    ratio = (float)i / Math.max(1.0f, (float)(content.length() - 1));
                    color = DColor.interpolate(startColor2, endColor, ratio);
                    builder.append(color.insertLegacyStyleChar()).append(content.charAt(i));
                }
                output = output.replace(original, builder.toString());
            }
            catch (Exception exception) {}
        }
        return output;
    }

    @NotNull
    public static String applyCustomHex(String input) {
        DColor color2;
        String hex;
        String original;
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        Matcher matcher = CUSTOM_HEX_PATTERN.matcher(output);
        while (matcher.find()) {
            original = matcher.group();
            hex = matcher.group(1);
            try {
                color2 = DColor.of(hex);
                output = output.replace(original, color2.insertLegacyStyleChar());
            }
            catch (Exception color2) {}
        }
        matcher = CUSTOM_HEX_PATTERN_2.matcher(output);
        while (matcher.find()) {
            original = matcher.group();
            hex = matcher.group(1);
            try {
                color2 = DColor.of(hex);
                output = output.replace(original, color2.insertLegacyStyleChar());
            }
            catch (Exception exception) {}
        }
        return output;
    }

    @NotNull
    public static String adaptColorLegacyToMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        Matcher matcher = LEGACY_COLOR_PATTERN.matcher(output);
        while (matcher.find()) {
            String original = matcher.group();
            String c = matcher.group(1);
            try {
                DColor color = DColor.getByLegacyCode(c);
                if (color == null) continue;
                output = output.replace(original, "<!b><!i><!obf><!st><!u>" + color.getMiniMessageFormat());
            }
            catch (Exception exception) {}
        }
        return output;
    }

    @NotNull
    public static String adaptHexLegacyToMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        Matcher matcher = LEGACY_HEX_COLOR_PATTERN.matcher(output);
        while (matcher.find()) {
            String original = matcher.group();
            String c = matcher.group(1);
            String hex = c.replace("\u00a7", "");
            try {
                DColor color = DColor.of("#" + hex);
                output = output.replace(original, "<!b><!i><!obf><!st><!u>" + color.getMiniMessageFormat());
            }
            catch (Exception exception) {}
        }
        return output;
    }

    @NotNull
    public static String adaptDecorationLegacyToMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        Matcher matcher = LEGACY_DECORATION_PATTERN.matcher(output);
        while (matcher.find()) {
            String original = matcher.group();
            String d = matcher.group(1);
            try {
                DDecoration decoration = DDecoration.getByLegacyCode(d);
                if (decoration == null) continue;
                output = output.replace(original, decoration.getMiniMessageFormat());
            }
            catch (Exception exception) {}
        }
        return output;
    }

    @NotNull
    public static String adaptStyleLegacyToMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        Matcher matcher = LEGACY_STYLE_PATTERN.matcher(output);
        while (matcher.find()) {
            String original = matcher.group();
            String style = matcher.group(1);
            try {
                DColor color = DColor.getByLegacyCode(style);
                if (color != null) {
                    output = output.replace(original, "<!b><!i><!obf><!st><!u>" + color.getMiniMessageFormat());
                    continue;
                }
                DDecoration decoration = DDecoration.getByLegacyCode(style);
                if (decoration == null) continue;
                output = output.replace(original, decoration.getMiniMessageFormat());
            }
            catch (Exception exception) {}
        }
        return output;
    }

    @NotNull
    public static String adaptLegacyToMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String output = input;
        output = StyleTranslator.adaptHexLegacyToMiniMessage(output);
        output = StyleTranslator.adaptStyleLegacyToMiniMessage(output);
        return output;
    }
}

