/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.formula.Conditional;
import nesoi.aysihuniks.libs.dapi.formula.ExpressionModifier;
import nesoi.aysihuniks.libs.dapi.formula.ValueFormula;
import nesoi.aysihuniks.libs.dapi.formula.ValueFormulaImpl;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.jetbrains.annotations.NotNull;

class ConditionalValueFormulaImpl
extends ValueFormulaImpl {
    @NotNull
    private final ValueFormula.Type type = ValueFormula.Type.CONDITIONAL;
    @NotNull
    private final List<Conditional> conditionals;
    @NotNull
    private final Set<String> variables;

    private ConditionalValueFormulaImpl(List<Conditional> conditionals, Set<String> variables) {
        Validate.notNull(conditionals, "Conditionals cannot be null.");
        Validate.notNull(variables, "Variables cannot be null.");
        this.conditionals = new ArrayList<Conditional>(conditionals);
        this.variables = new HashSet<String>(variables);
    }

    @Override
    @NotNull
    public ExpressionModifier setVariable(String variable, double value) {
        return new ConditionalExpressionModifierImpl(this.conditionals).setVariable(variable, value);
    }

    @Override
    public double evaluate() {
        return new ConditionalExpressionModifierImpl(this.conditionals).evaluate();
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)this.type);
        map.put("conditions", this.conditionals.stream().map(Conditional::serialize).collect(Collectors.toList()));
        map.put("variables", this.variables);
        return map;
    }

    public static ConditionalValueFormulaImpl deserialize(Map<String, Object> map) {
        Validate.notNull(map, "Map cannot be null.");
        HashSet<String> variables = new HashSet<String>((Collection)map.get("variables"));
        List conditions = (List)map.get("conditions");
        ArrayList<Conditional> conditionals = new ArrayList<Conditional>();
        for (Map cMap : conditions) {
            conditionals.add(Conditional.deserialize(cMap, variables));
        }
        return ConditionalValueFormulaImpl.of(conditionals, variables);
    }

    @NotNull
    public static ConditionalValueFormulaImpl of(List<Conditional> conditionals, Set<String> variables) {
        return new ConditionalValueFormulaImpl(conditionals, variables);
    }

    private static class ConditionalExpressionModifierImpl
    extends ValueFormulaImpl.ExpressionModifierImpl {
        @NotNull
        private final List<Conditional> conditionals;

        private ConditionalExpressionModifierImpl(List<Conditional> conditionals) {
            Validate.notNull(conditionals, "Conditionals cannot be null.");
            this.conditionals = new ArrayList<Conditional>(conditionals);
        }

        @Override
        @NotNull
        public ExpressionModifier setVariable(String variable, double value) {
            this.conditionals.forEach(expr -> {
                expr.condition().setVariable(variable, value);
                expr.formula().setVariable(variable, value);
            });
            return this;
        }

        @Override
        public double evaluate() {
            for (Conditional conditional : this.conditionals) {
                boolean conditionResult = conditional.condition().evaluate() != 0.0;
                if (!conditionResult) continue;
                return conditional.formula().evaluate();
            }
            return Double.MAX_VALUE;
        }
    }
}

