/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.formula;

import java.util.HashMap;
import java.util.Map;
import nesoi.aysihuniks.libs.dapi.formula.ExpressionModifier;
import nesoi.aysihuniks.libs.dapi.formula.ValueFormula;
import nesoi.aysihuniks.libs.dapi.formula.ValueFormulaImpl;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.jetbrains.annotations.NotNull;

class TableValueFormulaImpl
extends ValueFormulaImpl {
    @NotNull
    private final ValueFormula.Type type = ValueFormula.Type.TABLE;
    @NotNull
    private final Map<Integer, Double> table;

    protected TableValueFormulaImpl(Map<Integer, Double> table) {
        Validate.notNull(table, "Table cannot be null.");
        this.table = new HashMap<Integer, Double>(table);
    }

    @Override
    @NotNull
    public ExpressionModifier setVariable(String variable, double value) {
        return new TableExpressionModifierImpl(this.table).setVariable(variable, value);
    }

    @Override
    public double evaluate() {
        return new TableExpressionModifierImpl(this.table).evaluate();
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)this.type);
        HashMap<String, Double> tableMap = new HashMap<String, Double>();
        for (Map.Entry<Integer, Double> entry : this.table.entrySet()) {
            tableMap.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        map.put("values", tableMap);
        return map;
    }

    public static TableValueFormulaImpl deserialize(Map<String, Object> map) {
        Validate.notNull(map, "Map cannot be null.");
        Map tableMap = (Map)map.get("values");
        HashMap<Integer, Double> table = new HashMap<Integer, Double>();
        for (Map.Entry entry : tableMap.entrySet()) {
            try {
                table.put(Integer.parseInt((String)entry.getKey()), Double.parseDouble(entry.getValue().toString()));
            }
            catch (NullPointerException | NumberFormatException runtimeException) {}
        }
        return TableValueFormulaImpl.of(table);
    }

    @NotNull
    public static TableValueFormulaImpl of(Map<Integer, Double> table) {
        return new TableValueFormulaImpl(table);
    }

    private static class TableExpressionModifierImpl
    extends ValueFormulaImpl.ExpressionModifierImpl {
        @NotNull
        private final Map<Integer, Double> table;
        private Double value = null;

        public TableExpressionModifierImpl(Map<Integer, Double> table) {
            this.table = table;
        }

        @Override
        @NotNull
        public ExpressionModifier setVariable(String variable, double value) {
            this.value = value;
            return this;
        }

        @Override
        public double evaluate() {
            if (this.value == null) {
                return Double.MAX_VALUE;
            }
            for (Map.Entry<Integer, Double> entry : this.table.entrySet()) {
                if (entry.getKey() != (int)this.value.doubleValue()) continue;
                return entry.getValue();
            }
            return Double.MAX_VALUE;
        }
    }
}

