/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.formula;

import java.util.Locale;
import java.util.Map;
import nesoi.aysihuniks.libs.dapi.formula.ConditionalValueFormulaImpl;
import nesoi.aysihuniks.libs.dapi.formula.ExpressionModifier;
import nesoi.aysihuniks.libs.dapi.formula.Factory;
import nesoi.aysihuniks.libs.dapi.formula.FactoryImpl;
import nesoi.aysihuniks.libs.dapi.formula.SimpleValueFormulaImpl;
import nesoi.aysihuniks.libs.dapi.formula.TableValueFormulaImpl;
import nesoi.aysihuniks.libs.dapi.formula.ValueFormula;
import nesoi.aysihuniks.libs.dapi.util.DAPIException;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.jetbrains.annotations.NotNull;

abstract class ValueFormulaImpl
implements ValueFormula {
    public static final Factory FACTORY = FactoryImpl.createFactory();

    ValueFormulaImpl() {
    }

    @NotNull
    public static ValueFormula create(Map<String, Object> map) {
        Validate.notNull(map, "Map cannot be null.");
        ValueFormula.Type type = ValueFormulaImpl.getType((String)map.get("type"));
        switch (type) {
            case SIMPLE: {
                return SimpleValueFormulaImpl.deserialize(map);
            }
            case CONDITIONAL: {
                return ConditionalValueFormulaImpl.deserialize(map);
            }
            case TABLE: {
                return TableValueFormulaImpl.deserialize(map);
            }
        }
        throw new DAPIException("Invalid formula type.");
    }

    @NotNull
    public static ValueFormula.Type getType(String type) {
        try {
            return ValueFormula.Type.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return ValueFormula.Type.SIMPLE;
        }
    }

    static abstract class ExpressionModifierImpl
    implements ExpressionModifier {
        ExpressionModifierImpl() {
        }
    }
}

