/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.message;

import nesoi.aysihuniks.libs.dapi.message.IChannelMessage;
import nesoi.aysihuniks.libs.dapi.model.MiniString;
import nesoi.aysihuniks.libs.dapi.util.ColorizeType;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.jetbrains.annotations.NotNull;

public class ChannelMessage
implements IChannelMessage {
    @NotNull
    protected final MiniString message;

    protected ChannelMessage(MiniString message) {
        Validate.validate(message != null, "MiniString cannot be null!");
        this.message = message.copy();
    }

    public ChannelMessage(String message) {
        Validate.validate(message != null, "Message cannot be null!");
        this.message = new MiniString(message);
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public ChannelMessage(Object message) {
        Validate.validate(message != null, "Message cannot be null!");
        this.message = new MiniString("");
    }

    @Override
    public ChannelMessage copy() {
        return new ChannelMessage(this.message);
    }

    @Override
    public String getRawMessage() {
        return this.message.getRawText();
    }

    @Override
    @Deprecated(since="1.4.0", forRemoval=true)
    public Object getMessage() {
        return null;
    }

    @Override
    public ChannelMessage insertPrefix() {
        return new ChannelMessage(Util.PREFIX + this.message.getRawText());
    }

    @Override
    public ChannelMessage colorize(ColorizeType colorizeType) {
        return new ChannelMessage(this.message.colorize(colorizeType));
    }

    @Override
    public ChannelMessage replace(String key, String value) {
        return new ChannelMessage(this.message.replace(key, value));
    }
}

