/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.model.MiniString;
import nesoi.aysihuniks.libs.dapi.util.ColorizeType;
import nesoi.aysihuniks.libs.dapi.util.HexUtil;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import nesoi.aysihuniks.libs.dapi.util.Wrapper;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCreator {
    @NotNull
    private final ItemStack itemStack;
    @Nullable
    private final ItemMeta meta;

    public ItemCreator(ItemStack itemStack) {
        Validate.validate(itemStack != null, "ItemStack cannot be null!");
        this.itemStack = itemStack.clone();
        this.meta = this.itemStack.getItemMeta();
    }

    public static ItemCreator of(ItemStack itemStack) {
        return new ItemCreator(itemStack);
    }

    public static ItemCreator of(Material material) {
        Validate.validate(material != null, "Material cannot be null!");
        return new ItemCreator(new ItemStack(material));
    }

    private boolean hasMeta() {
        return this.meta != null;
    }

    public ItemStack get() {
        if (this.hasMeta()) {
            this.itemStack.setItemMeta(this.meta);
        }
        return this.itemStack;
    }

    public ItemCreator amount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemCreator name(@Nullable String name) {
        if (this.hasMeta()) {
            this.meta.setDisplayName(name == null ? null : HexUtil.parse(name));
        }
        return this;
    }

    public ItemCreator name(Supplier<@Nullable String> nameSupplier) {
        Validate.validate(nameSupplier != null, "Name supplier cannot be null!");
        return this.name(nameSupplier.get());
    }

    @Deprecated(since="1.4.0")
    public ItemCreator namePaper(@Nullable Object name) {
        return this;
    }

    @Deprecated(since="1.4.0")
    public ItemCreator namePaper(Supplier<@Nullable Object> nameSupplier) {
        Validate.validate(nameSupplier != null, "Name supplier cannot be null!");
        return this.namePaper(nameSupplier.get());
    }

    public ItemCreator nameMini(@Nullable MiniString name) {
        return this.name(name == null ? null : name.colorize(ColorizeType.LEGACY).getRawText());
    }

    public ItemCreator nameMini(Supplier<@Nullable MiniString> name) {
        Validate.validate(name != null, "Name supplier cannot be null!");
        return this.nameMini(name.get());
    }

    public ItemCreator lore(@Nullable List<String> lore) {
        if (this.hasMeta()) {
            if (lore == null) {
                this.meta.setLore(null);
            } else {
                ArrayList<String> newLore = new ArrayList<String>(lore);
                newLore.replaceAll(HexUtil::parse);
                this.meta.setLore(newLore);
            }
        }
        return this;
    }

    public ItemCreator lore(String ... lore) {
        return this.lore(lore == null ? null : List.of(lore));
    }

    public ItemCreator lore(Supplier<@Nullable List<String>> loreSupplier) {
        return this.lore(loreSupplier == null ? null : loreSupplier.get());
    }

    @Deprecated(since="1.4.0")
    public ItemCreator lorePaper(@Nullable List<Object> lore) {
        return this;
    }

    @Deprecated(since="1.4.0")
    public ItemCreator lorePaper(Object ... lore) {
        return this.lorePaper(lore == null ? null : List.of(lore));
    }

    @Deprecated(since="1.4.0")
    public ItemCreator lorePaper(Supplier<@Nullable List<Object>> loreSupplier) {
        return this.lorePaper(loreSupplier == null ? null : loreSupplier.get());
    }

    public ItemCreator loreMini(@Nullable List<MiniString> lore) {
        return this.lore(lore == null ? null : lore.stream().map(ms -> ms == null ? null : ms.colorize(ColorizeType.LEGACY).getRawText()).collect(Collectors.toList()));
    }

    public ItemCreator loreMini(MiniString ... lore) {
        return this.loreMini(lore == null ? null : List.of(lore));
    }

    public ItemCreator loreMini(Supplier<@Nullable List<MiniString>> loreSupplier) {
        return this.loreMini(loreSupplier == null ? null : loreSupplier.get());
    }

    public ItemCreator addLore(List<String> lore) {
        Validate.validate(lore != null, "Lore to be added cannot be null!");
        if (this.hasMeta()) {
            ArrayList<String> existingLore = this.meta.getLore() != null ? new ArrayList<String>(this.meta.getLore()) : new ArrayList();
            ArrayList<String> newLore = new ArrayList<String>(lore);
            newLore.replaceAll(HexUtil::parse);
            existingLore.addAll(newLore);
            this.meta.setLore(existingLore);
        }
        return this;
    }

    public ItemCreator addLore(String ... lore) {
        return this.addLore(List.of(lore));
    }

    public ItemCreator addLore(Supplier<List<String>> loreSupplier) {
        return this.addLore(loreSupplier == null ? null : loreSupplier.get().toArray(new String[0]));
    }

    @Deprecated(since="1.4.0")
    public ItemCreator addLorePaper(List<Object> lore) {
        Validate.validate(lore != null, "Lore to be added cannot be null!");
        return this;
    }

    @Deprecated(since="1.4.0")
    public ItemCreator addLorePaper(Object ... lore) {
        return this.addLorePaper(List.of(lore));
    }

    @Deprecated(since="1.4.0")
    public ItemCreator addLorePaper(Supplier<List<Object>> loreSupplier) {
        return this.addLorePaper(loreSupplier == null ? null : loreSupplier.get());
    }

    public ItemCreator addLoreMini(List<MiniString> lore) {
        return this.addLore(lore.stream().map(ms -> ms == null ? null : ms.colorize(ColorizeType.LEGACY).getRawText()).collect(Collectors.toList()));
    }

    public ItemCreator addLoreMini(MiniString ... lore) {
        return this.addLoreMini(List.of(lore));
    }

    public ItemCreator addLoreMini(Supplier<List<MiniString>> loreSupplier) {
        return this.addLoreMini(loreSupplier == null ? new ArrayList() : loreSupplier.get());
    }

    public ItemCreator enchant(Enchantment enchantment, int level) {
        Validate.validate(enchantment != null, "Enchantment cannot be null!");
        if (this.hasMeta()) {
            this.meta.addEnchant(enchantment, level, true);
        }
        return this;
    }

    public ItemCreator flags(ItemFlag ... flags) {
        Validate.validate(flags != null, "Flags cannot be null!");
        if (this.hasMeta()) {
            if (List.of(flags).contains(ItemFlag.HIDE_ATTRIBUTES)) {
                Attribute armorAttribute = Wrapper.getArmorAttribute();
                AttributeModifier attributeModifier = Wrapper.getArmorAttributeModifier();
                if (armorAttribute != null && attributeModifier != null) {
                    this.meta.addAttributeModifier(armorAttribute, attributeModifier);
                }
            }
            this.meta.addItemFlags(flags);
        }
        return this;
    }

    public ItemCreator unbreakable(boolean unbreakable) {
        if (this.hasMeta()) {
            this.meta.setUnbreakable(unbreakable);
        }
        return this;
    }

    public ItemCreator potion(@Nullable PotionType potionType, @Nullable Color color) {
        if (this.hasMeta() && this.meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)this.meta;
            Wrapper.editPotionMeta(potionMeta, potionType, color);
        }
        return this;
    }

    public ItemCreator potion(@Nullable PotionType potionType) {
        if (this.hasMeta() && this.meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)this.meta;
            return this.potion(potionType, potionMeta.getColor());
        }
        return this;
    }
}

