/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.TimeLeftThreshold;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class Config {
    private final NClaim plugin;
    private static FileConfiguration config;
    private String defaultLanguage;
    private double claimBuyPrice;
    private double eachLandBuyPrice;
    private boolean enableTieredPricing;
    private int claimExpiryDays;
    private int maxCoopPlayers;
    private int maxClaimCount;
    private long lastClaimTime;
    private List<String> blacklistedWorlds;
    private List<String> blacklistedRegions;
    private int claimDistanceChunks;
    private boolean claimDistanceCoopBypass;
    private int autoSave;
    private boolean showHologramTitle;
    private boolean showHologramOwner;
    private boolean showHologramTimeLeft;
    private boolean showHologramCoopCount;
    private boolean showHologramTotalSize;
    private boolean showHologramEdit;
    private boolean databaseEnabled;
    private String databaseType;
    private String sqliteFile;
    private String mysqlHost;
    private int mysqlPort;
    private String mysqlDatabase;
    private String mysqlUser;
    private String mysqlPassword;
    private int maximumPoolSize;
    private int minimumIdle;
    private long idleTimeout;
    private long maxLifetime;
    private long connectionTimeout;
    private double timeExtensionPricePerMinute;
    private double timeExtensionPricePerHour;
    private double timeExtensionPricePerDay;
    private double timeExtensionTaxRate;
    private boolean webhookEnabled;
    private String webhookUrl;
    private boolean webhookUseEmbed;
    private String webhookContent;
    private String webhookEmbedTitle;
    private String webhookEmbedDescription;
    private String webhookEmbedColor;
    private String webhookEmbedFooter;
    private boolean webhookEmbedTimestamp;
    private String webhookEmbedImage;
    private String webhookEmbedThumbnail;
    private String webhookMention;
    private Material defaultClaimBlockType = Material.OBSIDIAN;
    private List<TimeLeftThreshold> timeLeftThresholds = new ArrayList<TimeLeftThreshold>();

    public Config(NClaim plugin) {
        this.plugin = plugin;
    }

    public FileConfiguration get() {
        return config;
    }

    public Config load() {
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        this.setDefaultLanguage(config.getString("lang_file", "en-US"));
        this.setBlacklistedWorlds(config.getStringList("blacklisted_worlds"));
        this.setBlacklistedRegions(config.getStringList("blacklisted_regions"));
        this.setClaimDistanceChunks(config.getInt("claim_distance.chunks", 1));
        this.setClaimDistanceCoopBypass(config.getBoolean("claim_distance.bypass_coop_players", true));
        this.setMaxClaimCount(config.getInt("claim_settings.max_count", 3));
        this.setClaimBuyPrice(config.getDouble("claim_settings.buy_price", 1500.0));
        this.setEachLandBuyPrice(config.getDouble("claim_settings.expand_price", 2000.0));
        this.setEnableTieredPricing(config.getBoolean("claim_settings.tiered_pricing.enable", false));
        this.setMaxCoopPlayers(config.getInt("claim_settings.max_coop.default", 3));
        this.setClaimExpiryDays(config.getInt("claim_settings.expiry_days", 7));
        this.setLastClaimTime(config.getLong("claim_settings.last_claim_time", 5L));
        this.setShowHologramTitle(config.getBoolean("hologram_settings.show_title", true));
        this.setShowHologramOwner(config.getBoolean("hologram_settings.show_owner", true));
        this.setShowHologramTimeLeft(config.getBoolean("hologram_settings.show_time_left", true));
        this.setShowHologramCoopCount(config.getBoolean("hologram_settings.show_coop_count", true));
        this.setShowHologramTotalSize(config.getBoolean("hologram_settings.show_total_size", true));
        this.setShowHologramEdit(config.getBoolean("hologram_settings.show_edit", true));
        this.setTimeExtensionPricePerMinute(config.getDouble("time_extension.price_per_minute", 10.0));
        this.setTimeExtensionPricePerHour(config.getDouble("time_extension.price_per_hour", 500.0));
        this.setTimeExtensionPricePerDay(config.getDouble("time_extension.price_per_day", 10000.0));
        this.setTimeExtensionTaxRate(config.getDouble("time_extension.tax_rate", 0.1));
        this.setAutoSave(config.getInt("auto_save", 30));
        this.setDatabaseEnabled(config.getBoolean("database.enable", false));
        this.setDatabaseType(config.getString("database.type", "sqlite"));
        this.setSqliteFile(config.getString("database.sqlite.file", "database.db"));
        this.setMysqlHost(config.getString("database.mysql.host", "localhost"));
        this.setMysqlPort(config.getInt("database.mysql.port", 3306));
        this.setMysqlDatabase(config.getString("database.mysql.database", "nclaim"));
        this.setMysqlUser(config.getString("database.mysql.user", "root"));
        this.setMysqlPassword(config.getString("database.mysql.password", ""));
        this.setMaximumPoolSize(config.getInt("database.mysql.maximum_pool_size", 10));
        this.setMinimumIdle(config.getInt("database.mysql.minimum_idle", 5));
        this.setIdleTimeout(config.getLong("database.mysql.idle_timeout", 300000L));
        this.setMaxLifetime(config.getLong("database.mysql.max_lifetime", 1800000L));
        this.setConnectionTimeout(config.getLong("database.mysql.connection_timeout", 30000L));
        this.setWebhookEnabled(config.getBoolean("webhook_settings.enabled", false));
        this.setWebhookUrl(config.getString("webhook_settings.url", ""));
        this.setWebhookUseEmbed(config.getBoolean("webhook_settings.use_embed", false));
        this.setWebhookContent(config.getString("webhook_settings.content", ""));
        if (config.isConfigurationSection("webhook_settings.embed")) {
            ConfigurationSection embedSection = config.getConfigurationSection("webhook_settings.embed");
            this.setWebhookEmbedTitle(embedSection.getString("title", ""));
            this.setWebhookEmbedDescription(embedSection.getString("description", ""));
            this.setWebhookEmbedColor(embedSection.getString("color", "#FF0000"));
            this.setWebhookEmbedFooter(embedSection.getString("footer", ""));
            this.setWebhookEmbedTimestamp(embedSection.getBoolean("timestamp", true));
            this.setWebhookEmbedImage(embedSection.getString("image", ""));
            this.setWebhookEmbedThumbnail(embedSection.getString("thumbnail", ""));
        }
        this.setWebhookMention(config.getString("webhook_settings.mention", ""));
        String defClaimBlockStr = config.getString("claim_settings.default_claim_block_type", "OBSIDIAN");
        try {
            this.setDefaultClaimBlockType(Material.valueOf((String)defClaimBlockStr.toUpperCase()));
        }
        catch (Exception e) {
            this.setDefaultClaimBlockType(Material.OBSIDIAN);
            Util.log("&cThe default_claim_block_type in Config is invalid! It has been set to OBSIDIAN.");
        }
        this.validateTierConfiguration();
        this.loadTimeLeftThresholds();
        return this;
    }

    public synchronized void save() {
        try {
            config.set("lang_file", (Object)this.getDefaultLanguage());
            config.set("blacklisted_worlds", this.getBlacklistedWorlds());
            config.set("blacklisted_regions", this.getBlacklistedRegions());
            config.set("claim_settings.max_count", (Object)this.getMaxClaimCount());
            config.set("claim_settings.buy_price", (Object)this.getClaimBuyPrice());
            config.set("claim_settings.expand_price", (Object)this.getEachLandBuyPrice());
            config.set("claim_settings.max_coop.default", (Object)this.getMaxCoopPlayers());
            config.set("claim_settings.expiry_days", (Object)this.getClaimExpiryDays());
            config.set("claim_settings.last_claim_time", (Object)this.getLastClaimTime());
            config.set("hologram_settings.show_title", (Object)this.isShowHologramTitle());
            config.set("hologram_settings.show_owner", (Object)this.isShowHologramOwner());
            config.set("hologram_settings.show_time_left", (Object)this.isShowHologramTimeLeft());
            config.set("hologram_settings.show_coop_count", (Object)this.isShowHologramCoopCount());
            config.set("hologram_settings.show_total_size", (Object)this.isShowHologramTotalSize());
            config.set("hologram_settings.show_edit", (Object)this.isShowHologramEdit());
            config.set("claim_settings.tiered_pricing.enable", (Object)this.isEnableTieredPricing());
            config.set("time_extension.price_per_minute", (Object)this.getTimeExtensionPricePerMinute());
            config.set("time_extension.price_per_hour", (Object)this.getTimeExtensionPricePerHour());
            config.set("time_extension.price_per_day", (Object)this.getTimeExtensionPricePerDay());
            config.set("time_extension.tax_rate", (Object)this.getTimeExtensionTaxRate());
            config.set("auto_save", (Object)this.getAutoSave());
            config.set("database.enable", (Object)this.isDatabaseEnabled());
            config.set("database.type", (Object)this.getDatabaseType());
            config.set("database.sqlite.file", (Object)this.getSqliteFile());
            config.set("database.mysql.host", (Object)this.getMysqlHost());
            config.set("database.mysql.port", (Object)this.getMysqlPort());
            config.set("database.mysql.database", (Object)this.getMysqlDatabase());
            config.set("database.mysql.user", (Object)this.getMysqlUser());
            config.set("database.mysql.password", (Object)this.getMysqlPassword());
            config.set("database.mysql.maximum_pool_size", (Object)this.getMaximumPoolSize());
            config.set("database.mysql.minimum_idle", (Object)this.getMinimumIdle());
            config.set("database.mysql.idle_timeout", (Object)this.getIdleTimeout());
            config.set("database.mysql.max_lifetime", (Object)this.getMaxLifetime());
            config.set("database.mysql.connection_timeout", (Object)this.getConnectionTimeout());
            config.set("webhook_settings.enabled", (Object)this.isWebhookEnabled());
            config.set("webhook_settings.url", (Object)this.getWebhookUrl());
            config.set("webhook_settings.use_embed", (Object)this.isWebhookUseEmbed());
            config.set("webhook_settings.content", (Object)this.getWebhookContent());
            ConfigurationSection embedSection = config.createSection("webhook_settings.embed");
            embedSection.set("title", (Object)this.getWebhookEmbedTitle());
            embedSection.set("description", (Object)this.getWebhookEmbedDescription());
            embedSection.set("color", (Object)this.getWebhookEmbedColor());
            embedSection.set("footer", (Object)this.getWebhookEmbedFooter());
            embedSection.set("timestamp", (Object)this.isWebhookEmbedTimestamp());
            embedSection.set("image", (Object)this.getWebhookEmbedImage());
            embedSection.set("thumbnail", (Object)this.getWebhookEmbedThumbnail());
            config.set("webhook_settings.mention", (Object)this.getWebhookMention());
            config.set("claim_settings.default_claim_block_type", (Object)this.getDefaultClaimBlockType().name());
            config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (Exception e) {
            Util.log("&cFailed to save config.yml! " + e.getMessage());
        }
    }

    public void loadTimeLeftThresholds() {
        this.timeLeftThresholds.clear();
        if (config.isList("hologram_settings.time_left_thresholds")) {
            List rawList = config.getList("hologram_settings.time_left_thresholds", new ArrayList());
            for (Object obj : rawList) {
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                String thresholdStr = String.valueOf(map.get("threshold"));
                String color = String.valueOf(map.get("color"));
                String[] parts = thresholdStr.split(" ");
                if (parts.length != 3) continue;
                TimeLeftThreshold t = new TimeLeftThreshold();
                t.unit = parts[0].trim();
                t.operator = parts[1].trim();
                t.value = Integer.parseInt(parts[2].trim());
                t.color = color;
                this.timeLeftThresholds.add(t);
            }
        }
    }

    public static long getTimeUnitValue(long seconds, String unit) {
        switch (unit) {
            case "day": {
                return seconds / 86400L;
            }
            case "hour": {
                return seconds / 3600L;
            }
            case "minute": {
                return seconds / 60L;
            }
        }
        return seconds;
    }

    public double getTieredPrice(int chunkNumber) {
        if (chunkNumber > 117) {
            return -1.0;
        }
        if (!this.isEnableTieredPricing()) {
            return this.getEachLandBuyPrice();
        }
        ConfigurationSection tiersSection = config.getConfigurationSection("claim_settings.tiered_pricing.tiers");
        if (tiersSection != null) {
            for (String tierKey : tiersSection.getKeys(false)) {
                int minChunk = config.getInt("claim_settings.tiered_pricing.tiers." + tierKey + ".min", 1);
                int maxChunk = config.getInt("claim_settings.tiered_pricing.tiers." + tierKey + ".max", 1);
                double price = config.getDouble("claim_settings.tiered_pricing.tiers." + tierKey + ".price", 0.0);
                if (minChunk > 117 || maxChunk > 117) {
                    Util.log("&cWarning: Tier " + tierKey + " has chunk numbers above limit (117). Skipping...");
                    continue;
                }
                if (chunkNumber < minChunk || chunkNumber > maxChunk) continue;
                return price;
            }
        }
        return this.getEachLandBuyPrice();
    }

    public void validateTierConfiguration() {
        if (!this.isEnableTieredPricing()) {
            return;
        }
        boolean isValid = true;
        ConfigurationSection tiersSection = config.getConfigurationSection("claim_settings.tiered_pricing.tiers");
        if (tiersSection != null) {
            for (String tierKey : tiersSection.getKeys(false)) {
                int minChunk = config.getInt("claim_settings.tiered_pricing.tiers." + tierKey + ".min", 1);
                int maxChunk = config.getInt("claim_settings.tiered_pricing.tiers." + tierKey + ".max", 1);
                if (minChunk > 117 || maxChunk > 117) {
                    Util.log("&cError: Tier " + tierKey + " exceeds maximum chunk limit (117)!");
                    isValid = false;
                }
                if (minChunk > maxChunk) {
                    Util.log("&cError: Tier " + tierKey + " has min (" + minChunk + ") greater than max (" + maxChunk + ")!");
                    isValid = false;
                }
                if (minChunk >= 1) continue;
                Util.log("&cError: Tier " + tierKey + " has min chunk less than 1!");
                isValid = false;
            }
        }
        if (!isValid) {
            Util.log("&cTiered pricing system has configuration errors. Please fix your config.yml!");
        }
    }

    public int getMaxCoopPlayers(Player player) {
        if (player.isOp() || player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.max_coop_count")) {
            return Integer.MAX_VALUE;
        }
        int maxCoop = config.getInt("claim_settings.max_coop_count.default", 3);
        ConfigurationSection maxCoopSection = config.getConfigurationSection("claim_settings.max_coop_count");
        if (maxCoopSection != null) {
            for (String key : maxCoopSection.getKeys(false)) {
                int value;
                if (key.equals("default") || !player.hasPermission("nclaim.maxcoop." + key) || (value = config.getInt("claim_settings.max_coop_count." + key)) <= maxCoop) continue;
                maxCoop = value;
            }
        }
        return maxCoop;
    }

    public int getMaxClaimCount(Player player) {
        if (player.isOp() || player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.max_claim_count")) {
            return Integer.MAX_VALUE;
        }
        int maxClaims = config.getInt("max_claim_count", 3);
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String perm = permInfo.getPermission();
            if (!perm.startsWith("nclaim.maxclaim.")) continue;
            try {
                int value = Integer.parseInt(perm.substring("nclaim.maxclaim.".length()));
                if (value <= maxClaims) continue;
                maxClaims = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxClaims;
    }

    public boolean isValidLanguage(String lang) {
        return lang.equals("en-US") || lang.equals("tr-TR") || lang.equals("fr-FR");
    }

    public Config updateConfig() {
        String configVersion;
        String version = this.plugin.getDescription().getVersion();
        if (version.equals(configVersion = config.getString("config_version", "0"))) {
            return this;
        }
        InputStream defStream = this.plugin.getResource("config.yml");
        if (defStream == null) {
            Util.log("&cDefault config.yml not found in plugin resources.");
            return this;
        }
        this.saveBackupConfig();
        YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
        for (String key : defConfig.getKeys(true)) {
            if (defConfig.isConfigurationSection(key) || !config.contains(key)) continue;
            defConfig.set(key, config.get(key));
        }
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        try {
            defConfig.set("config_version", (Object)version);
            defConfig.save(file);
            config = defConfig;
            Util.log("&aUpdated config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated config file.");
            e.printStackTrace();
        }
        return this;
    }

    private void saveBackupConfig() {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss").format(new Date());
        File backupFile = new File(backupDir, "config_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save backup file.");
            e.printStackTrace();
        }
    }

    @Generated
    public NClaim getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Generated
    public double getClaimBuyPrice() {
        return this.claimBuyPrice;
    }

    @Generated
    public double getEachLandBuyPrice() {
        return this.eachLandBuyPrice;
    }

    @Generated
    public boolean isEnableTieredPricing() {
        return this.enableTieredPricing;
    }

    @Generated
    public int getClaimExpiryDays() {
        return this.claimExpiryDays;
    }

    @Generated
    public int getMaxCoopPlayers() {
        return this.maxCoopPlayers;
    }

    @Generated
    public int getMaxClaimCount() {
        return this.maxClaimCount;
    }

    @Generated
    public long getLastClaimTime() {
        return this.lastClaimTime;
    }

    @Generated
    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    @Generated
    public List<String> getBlacklistedRegions() {
        return this.blacklistedRegions;
    }

    @Generated
    public int getClaimDistanceChunks() {
        return this.claimDistanceChunks;
    }

    @Generated
    public boolean isClaimDistanceCoopBypass() {
        return this.claimDistanceCoopBypass;
    }

    @Generated
    public int getAutoSave() {
        return this.autoSave;
    }

    @Generated
    public boolean isShowHologramTitle() {
        return this.showHologramTitle;
    }

    @Generated
    public boolean isShowHologramOwner() {
        return this.showHologramOwner;
    }

    @Generated
    public boolean isShowHologramTimeLeft() {
        return this.showHologramTimeLeft;
    }

    @Generated
    public boolean isShowHologramCoopCount() {
        return this.showHologramCoopCount;
    }

    @Generated
    public boolean isShowHologramTotalSize() {
        return this.showHologramTotalSize;
    }

    @Generated
    public boolean isShowHologramEdit() {
        return this.showHologramEdit;
    }

    @Generated
    public boolean isDatabaseEnabled() {
        return this.databaseEnabled;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getSqliteFile() {
        return this.sqliteFile;
    }

    @Generated
    public String getMysqlHost() {
        return this.mysqlHost;
    }

    @Generated
    public int getMysqlPort() {
        return this.mysqlPort;
    }

    @Generated
    public String getMysqlDatabase() {
        return this.mysqlDatabase;
    }

    @Generated
    public String getMysqlUser() {
        return this.mysqlUser;
    }

    @Generated
    public String getMysqlPassword() {
        return this.mysqlPassword;
    }

    @Generated
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Generated
    public int getMinimumIdle() {
        return this.minimumIdle;
    }

    @Generated
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Generated
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Generated
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public double getTimeExtensionPricePerMinute() {
        return this.timeExtensionPricePerMinute;
    }

    @Generated
    public double getTimeExtensionPricePerHour() {
        return this.timeExtensionPricePerHour;
    }

    @Generated
    public double getTimeExtensionPricePerDay() {
        return this.timeExtensionPricePerDay;
    }

    @Generated
    public double getTimeExtensionTaxRate() {
        return this.timeExtensionTaxRate;
    }

    @Generated
    public boolean isWebhookEnabled() {
        return this.webhookEnabled;
    }

    @Generated
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    @Generated
    public boolean isWebhookUseEmbed() {
        return this.webhookUseEmbed;
    }

    @Generated
    public String getWebhookContent() {
        return this.webhookContent;
    }

    @Generated
    public String getWebhookEmbedTitle() {
        return this.webhookEmbedTitle;
    }

    @Generated
    public String getWebhookEmbedDescription() {
        return this.webhookEmbedDescription;
    }

    @Generated
    public String getWebhookEmbedColor() {
        return this.webhookEmbedColor;
    }

    @Generated
    public String getWebhookEmbedFooter() {
        return this.webhookEmbedFooter;
    }

    @Generated
    public boolean isWebhookEmbedTimestamp() {
        return this.webhookEmbedTimestamp;
    }

    @Generated
    public String getWebhookEmbedImage() {
        return this.webhookEmbedImage;
    }

    @Generated
    public String getWebhookEmbedThumbnail() {
        return this.webhookEmbedThumbnail;
    }

    @Generated
    public String getWebhookMention() {
        return this.webhookMention;
    }

    @Generated
    public Material getDefaultClaimBlockType() {
        return this.defaultClaimBlockType;
    }

    @Generated
    public List<TimeLeftThreshold> getTimeLeftThresholds() {
        return this.timeLeftThresholds;
    }

    @Generated
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Generated
    public void setClaimBuyPrice(double claimBuyPrice) {
        this.claimBuyPrice = claimBuyPrice;
    }

    @Generated
    public void setEachLandBuyPrice(double eachLandBuyPrice) {
        this.eachLandBuyPrice = eachLandBuyPrice;
    }

    @Generated
    public void setEnableTieredPricing(boolean enableTieredPricing) {
        this.enableTieredPricing = enableTieredPricing;
    }

    @Generated
    public void setClaimExpiryDays(int claimExpiryDays) {
        this.claimExpiryDays = claimExpiryDays;
    }

    @Generated
    public void setMaxCoopPlayers(int maxCoopPlayers) {
        this.maxCoopPlayers = maxCoopPlayers;
    }

    @Generated
    public void setMaxClaimCount(int maxClaimCount) {
        this.maxClaimCount = maxClaimCount;
    }

    @Generated
    public void setLastClaimTime(long lastClaimTime) {
        this.lastClaimTime = lastClaimTime;
    }

    @Generated
    public void setBlacklistedWorlds(List<String> blacklistedWorlds) {
        this.blacklistedWorlds = blacklistedWorlds;
    }

    @Generated
    public void setBlacklistedRegions(List<String> blacklistedRegions) {
        this.blacklistedRegions = blacklistedRegions;
    }

    @Generated
    public void setClaimDistanceChunks(int claimDistanceChunks) {
        this.claimDistanceChunks = claimDistanceChunks;
    }

    @Generated
    public void setClaimDistanceCoopBypass(boolean claimDistanceCoopBypass) {
        this.claimDistanceCoopBypass = claimDistanceCoopBypass;
    }

    @Generated
    public void setAutoSave(int autoSave) {
        this.autoSave = autoSave;
    }

    @Generated
    public void setShowHologramTitle(boolean showHologramTitle) {
        this.showHologramTitle = showHologramTitle;
    }

    @Generated
    public void setShowHologramOwner(boolean showHologramOwner) {
        this.showHologramOwner = showHologramOwner;
    }

    @Generated
    public void setShowHologramTimeLeft(boolean showHologramTimeLeft) {
        this.showHologramTimeLeft = showHologramTimeLeft;
    }

    @Generated
    public void setShowHologramCoopCount(boolean showHologramCoopCount) {
        this.showHologramCoopCount = showHologramCoopCount;
    }

    @Generated
    public void setShowHologramTotalSize(boolean showHologramTotalSize) {
        this.showHologramTotalSize = showHologramTotalSize;
    }

    @Generated
    public void setShowHologramEdit(boolean showHologramEdit) {
        this.showHologramEdit = showHologramEdit;
    }

    @Generated
    public void setDatabaseEnabled(boolean databaseEnabled) {
        this.databaseEnabled = databaseEnabled;
    }

    @Generated
    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    public void setSqliteFile(String sqliteFile) {
        this.sqliteFile = sqliteFile;
    }

    @Generated
    public void setMysqlHost(String mysqlHost) {
        this.mysqlHost = mysqlHost;
    }

    @Generated
    public void setMysqlPort(int mysqlPort) {
        this.mysqlPort = mysqlPort;
    }

    @Generated
    public void setMysqlDatabase(String mysqlDatabase) {
        this.mysqlDatabase = mysqlDatabase;
    }

    @Generated
    public void setMysqlUser(String mysqlUser) {
        this.mysqlUser = mysqlUser;
    }

    @Generated
    public void setMysqlPassword(String mysqlPassword) {
        this.mysqlPassword = mysqlPassword;
    }

    @Generated
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    @Generated
    public void setMinimumIdle(int minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    @Generated
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Generated
    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    @Generated
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setTimeExtensionPricePerMinute(double timeExtensionPricePerMinute) {
        this.timeExtensionPricePerMinute = timeExtensionPricePerMinute;
    }

    @Generated
    public void setTimeExtensionPricePerHour(double timeExtensionPricePerHour) {
        this.timeExtensionPricePerHour = timeExtensionPricePerHour;
    }

    @Generated
    public void setTimeExtensionPricePerDay(double timeExtensionPricePerDay) {
        this.timeExtensionPricePerDay = timeExtensionPricePerDay;
    }

    @Generated
    public void setTimeExtensionTaxRate(double timeExtensionTaxRate) {
        this.timeExtensionTaxRate = timeExtensionTaxRate;
    }

    @Generated
    public void setWebhookEnabled(boolean webhookEnabled) {
        this.webhookEnabled = webhookEnabled;
    }

    @Generated
    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    @Generated
    public void setWebhookUseEmbed(boolean webhookUseEmbed) {
        this.webhookUseEmbed = webhookUseEmbed;
    }

    @Generated
    public void setWebhookContent(String webhookContent) {
        this.webhookContent = webhookContent;
    }

    @Generated
    public void setWebhookEmbedTitle(String webhookEmbedTitle) {
        this.webhookEmbedTitle = webhookEmbedTitle;
    }

    @Generated
    public void setWebhookEmbedDescription(String webhookEmbedDescription) {
        this.webhookEmbedDescription = webhookEmbedDescription;
    }

    @Generated
    public void setWebhookEmbedColor(String webhookEmbedColor) {
        this.webhookEmbedColor = webhookEmbedColor;
    }

    @Generated
    public void setWebhookEmbedFooter(String webhookEmbedFooter) {
        this.webhookEmbedFooter = webhookEmbedFooter;
    }

    @Generated
    public void setWebhookEmbedTimestamp(boolean webhookEmbedTimestamp) {
        this.webhookEmbedTimestamp = webhookEmbedTimestamp;
    }

    @Generated
    public void setWebhookEmbedImage(String webhookEmbedImage) {
        this.webhookEmbedImage = webhookEmbedImage;
    }

    @Generated
    public void setWebhookEmbedThumbnail(String webhookEmbedThumbnail) {
        this.webhookEmbedThumbnail = webhookEmbedThumbnail;
    }

    @Generated
    public void setWebhookMention(String webhookMention) {
        this.webhookMention = webhookMention;
    }

    @Generated
    public void setDefaultClaimBlockType(Material defaultClaimBlockType) {
        this.defaultClaimBlockType = defaultClaimBlockType;
    }

    @Generated
    public void setTimeLeftThresholds(List<TimeLeftThreshold> timeLeftThresholds) {
        this.timeLeftThresholds = timeLeftThresholds;
    }
}

