/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.database;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.nclaim.Config;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.database.DatabaseManager;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.model.CoopData;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.model.User;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class MySQLManager
implements DatabaseManager {
    private final HikariDataSource dataSource;
    private final String database;
    private final Gson gson;
    private static final String CREATE_USERS_TABLE = "CREATE TABLE IF NOT EXISTS users (uuid VARCHAR(36) NOT NULL PRIMARY KEY, balance DOUBLE DEFAULT 0, skinTexture TEXT)";
    private static final String CREATE_CLAIMS_TABLE = "CREATE TABLE IF NOT EXISTS claims (claim_id VARCHAR(100) PRIMARY KEY, chunk_world VARCHAR(100), chunk_x INT, chunk_z INT, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, expired_at TIMESTAMP NULL, owner VARCHAR(36), claim_block_location TEXT, lands TEXT, claim_value BIGINT DEFAULT 0,claim_block_type VARCHAR(50),purchased_blocks TEXT)";
    private static final String CREATE_CLAIM_COOPS_TABLE = "CREATE TABLE IF NOT EXISTS claim_coops (claim_id VARCHAR(100), player_uuid VARCHAR(36), joined_at TIMESTAMP, permissions TEXT, PRIMARY KEY (claim_id, player_uuid))";
    private static final String CREATE_CLAIM_SETTINGS_TABLE = "CREATE TABLE IF NOT EXISTS claim_settings (claim_id VARCHAR(100) PRIMARY KEY, settings TEXT)";
    private static final String SAVE_USER = "INSERT INTO users (uuid, balance, skinTexture) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE balance = ?, skinTexture = ?";
    private static final String LOAD_USER = "SELECT balance, skinTexture FROM users WHERE uuid = ?";
    private static final String LOAD_ALL_USERS = "SELECT uuid, balance, skinTexture FROM users";
    private static final String SAVE_CLAIM = "INSERT INTO claims (claim_id, chunk_world, chunk_x, chunk_z, created_at, expired_at, owner, claim_block_location, lands, claim_value, claim_block_type, purchased_blocks) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE expired_at=?, owner=?, claim_block_location=?, lands=?, claim_value=?, claim_block_type=?, purchased_blocks=?";
    private static final String SAVE_CLAIM_COOP = "INSERT INTO claim_coops VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE joined_at=?, permissions=?";
    private static final String SAVE_CLAIM_SETTINGS = "INSERT INTO claim_settings VALUES (?, ?) ON DUPLICATE KEY UPDATE settings=?";
    private static final String LOAD_CLAIM = "SELECT * FROM claims WHERE claim_id = ?";
    private static final String LOAD_ALL_CLAIMS = "SELECT * FROM claims";
    private static final String LOAD_CLAIM_COOPS = "SELECT * FROM claim_coops WHERE claim_id = ?";
    private static final String LOAD_CLAIM_SETTINGS = "SELECT * FROM claim_settings WHERE claim_id = ?";
    private static final String DELETE_CLAIM = "DELETE FROM claims WHERE claim_id = ?";
    private static final String DELETE_CLAIM_COOPS = "DELETE FROM claim_coops WHERE claim_id = ?";
    private static final String DELETE_CLAIM_SETTINGS = "DELETE FROM claim_settings WHERE claim_id = ?";

    public MySQLManager(Config config) {
        this.database = config.getMysqlDatabase();
        this.gson = new Gson();
        this.createDatabaseIfNotExists(config);
        this.dataSource = this.setupDataSource(config);
        this.initializeDatabase();
    }

    private void createDatabaseIfNotExists(Config config) {
        String host = config.getMysqlHost();
        int port = config.getMysqlPort();
        String user = config.getMysqlUser();
        String password = config.getMysqlPassword();
        String dbName = config.getMysqlDatabase();
        String rootUrl = String.format("jdbc:mysql://%s:%d/?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC", host, port);
        try (Connection conn = DriverManager.getConnection(rootUrl, user, password);
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE DATABASE IF NOT EXISTS `" + dbName + "`");
            Util.log("&aDatabase '" + dbName + "' checked/created successfully.");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize database '" + dbName + "': " + e.getMessage(), e);
        }
    }

    private HikariDataSource setupDataSource(Config config) {
        String host = config.getMysqlHost();
        int port = config.getMysqlPort();
        String database = config.getMysqlDatabase();
        String user = config.getMysqlUser();
        String password = config.getMysqlPassword();
        String jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC", host, port, database);
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername(user);
        hikariConfig.setPassword(password);
        hikariConfig.setMaximumPoolSize(config.getMaximumPoolSize());
        hikariConfig.setMinimumIdle(config.getMinimumIdle());
        hikariConfig.setIdleTimeout(config.getIdleTimeout());
        hikariConfig.setMaxLifetime(config.getMaxLifetime());
        hikariConfig.setConnectionTimeout(config.getConnectionTimeout());
        return new HikariDataSource(hikariConfig);
    }

    private void initializeDatabase() {
        try (Connection conn = this.getConnection();){
            conn.prepareStatement(CREATE_USERS_TABLE).executeUpdate();
            conn.prepareStatement(CREATE_CLAIMS_TABLE).executeUpdate();
            conn.prepareStatement(CREATE_CLAIM_COOPS_TABLE).executeUpdate();
            conn.prepareStatement(CREATE_CLAIM_SETTINGS_TABLE).executeUpdate();
            Util.log("&aDatabase tables initialized successfully.");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize database tables", e);
        }
    }

    @Override
    public void saveUser(User user) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(SAVE_USER);){
            stmt.setString(1, user.getUuid().toString());
            stmt.setDouble(2, user.getBalance());
            stmt.setString(3, user.getSkinTexture());
            stmt.setDouble(4, user.getBalance());
            stmt.setString(5, user.getSkinTexture());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Util.log("&cFailed to save user data: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User loadUser(UUID uuid) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(LOAD_USER);){
            stmt.setString(1, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            User user = new User(uuid, rs.getDouble("balance"), null, new ArrayList<Claim>(), new ArrayList<Claim>());
            return user;
        }
        catch (SQLException e) {
            Util.log("&cFailed to load user data: " + e.getMessage());
        }
        return null;
    }

    @Override
    public List<User> loadAllUsers() {
        ArrayList<User> users = new ArrayList<User>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(LOAD_ALL_USERS);){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                users.add(new User(UUID.fromString(rs.getString("uuid")), rs.getDouble("balance"), rs.getString("skinTexture"), new ArrayList<Claim>(), new ArrayList<Claim>()));
            }
        }
        catch (SQLException e) {
            Util.log("&cFailed to load all users: " + e.getMessage());
        }
        return users;
    }

    @Override
    public void saveClaim(Claim claim) {
        try (Connection conn = this.getConnection();){
            try (PreparedStatement stmt = conn.prepareStatement(SAVE_CLAIM);){
                stmt.setString(1, claim.getClaimId());
                stmt.setString(2, claim.getChunk().getWorld().getName());
                stmt.setInt(3, claim.getChunk().getX());
                stmt.setInt(4, claim.getChunk().getZ());
                stmt.setTimestamp(5, new Timestamp(claim.getCreatedAt().getTime()));
                stmt.setTimestamp(6, claim.getExpiredAt() != null ? new Timestamp(claim.getExpiredAt().getTime()) : null);
                stmt.setString(7, claim.getOwner().toString());
                stmt.setString(8, NClaim.serializeLocation(claim.getClaimBlockLocation()));
                stmt.setString(9, this.gson.toJson(claim.getLands()));
                stmt.setLong(10, claim.getClaimValue());
                stmt.setString(11, claim.getClaimBlockType().name());
                List purchasedBlockNames = claim.getPurchasedBlockTypes().stream().map(Enum::name).collect(Collectors.toList());
                stmt.setString(12, this.gson.toJson(purchasedBlockNames));
                stmt.setTimestamp(13, claim.getExpiredAt() != null ? new Timestamp(claim.getExpiredAt().getTime()) : null);
                stmt.setString(14, claim.getOwner().toString());
                stmt.setString(15, NClaim.serializeLocation(claim.getClaimBlockLocation()));
                stmt.setString(16, this.gson.toJson(claim.getLands()));
                stmt.setLong(17, claim.getClaimValue());
                stmt.setString(18, claim.getClaimBlockType().name());
                stmt.setString(19, this.gson.toJson(purchasedBlockNames));
                stmt.executeUpdate();
            }
            this.saveClaimCoops(conn, claim);
            this.saveClaimSettings(conn, claim);
        }
        catch (SQLException e) {
            Util.log("&cFailed to save claim: " + e.getMessage());
        }
    }

    @Override
    public void saveClaimsBatch(List<Claim> claims) {
        try (Connection conn = this.getConnection();){
            conn.setAutoCommit(false);
            try {
                for (Claim claim : claims) {
                    try (PreparedStatement stmt = conn.prepareStatement(SAVE_CLAIM);){
                        stmt.setString(1, claim.getClaimId());
                        stmt.setString(2, claim.getChunk().getWorld().getName());
                        stmt.setInt(3, claim.getChunk().getX());
                        stmt.setInt(4, claim.getChunk().getZ());
                        stmt.setTimestamp(5, new Timestamp(claim.getCreatedAt().getTime()));
                        stmt.setTimestamp(6, new Timestamp(claim.getExpiredAt().getTime()));
                        stmt.setString(7, claim.getOwner().toString());
                        stmt.setString(8, NClaim.serializeLocation(claim.getClaimBlockLocation()));
                        stmt.setString(9, this.gson.toJson(claim.getLands()));
                        stmt.setLong(10, claim.getClaimValue());
                        stmt.setString(11, claim.getClaimBlockType().name());
                        List purchasedBlockNames = claim.getPurchasedBlockTypes().stream().map(Enum::name).collect(Collectors.toList());
                        stmt.setString(12, this.gson.toJson(purchasedBlockNames));
                        stmt.setTimestamp(13, new Timestamp(claim.getExpiredAt().getTime()));
                        stmt.setString(14, claim.getOwner().toString());
                        stmt.setString(15, NClaim.serializeLocation(claim.getClaimBlockLocation()));
                        stmt.setString(16, this.gson.toJson(claim.getLands()));
                        stmt.setLong(17, claim.getClaimValue());
                        stmt.setString(18, claim.getClaimBlockType().name());
                        stmt.setString(19, this.gson.toJson(purchasedBlockNames));
                        stmt.executeUpdate();
                    }
                    this.saveClaimCoops(conn, claim);
                    this.saveClaimSettings(conn, claim);
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            Util.log("&cFailed to save claims batch: " + e.getMessage());
        }
    }

    private void saveClaimCoops(Connection conn, Claim claim) throws SQLException {
        try (PreparedStatement deleteStmt = conn.prepareStatement(DELETE_CLAIM_COOPS);){
            deleteStmt.setString(1, claim.getClaimId());
            deleteStmt.executeUpdate();
        }
        try (PreparedStatement stmt = conn.prepareStatement(SAVE_CLAIM_COOP);){
            for (UUID coopPlayer : claim.getCoopPlayers()) {
                HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
                CoopPermission coopPerm = claim.getCoopPermissions().get(coopPlayer);
                for (Permission perm : Permission.values()) {
                    permissions.put(perm.name(), coopPerm.isEnabled(perm));
                }
                stmt.setString(1, claim.getClaimId());
                stmt.setString(2, coopPlayer.toString());
                stmt.setTimestamp(3, new Timestamp(claim.getCoopPlayerJoinDate().get(coopPlayer).getTime()));
                stmt.setString(4, this.gson.toJson(permissions));
                stmt.setTimestamp(5, new Timestamp(claim.getCoopPlayerJoinDate().get(coopPlayer).getTime()));
                stmt.setString(6, this.gson.toJson(permissions));
                stmt.executeUpdate();
            }
        }
    }

    private void saveClaimSettings(Connection conn, Claim claim) throws SQLException {
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        for (Setting setting : Setting.values()) {
            settings.put(setting.name(), claim.getSettings().isEnabled(setting));
        }
        try (PreparedStatement stmt = conn.prepareStatement(SAVE_CLAIM_SETTINGS);){
            stmt.setString(1, claim.getClaimId());
            stmt.setString(2, this.gson.toJson(settings));
            stmt.setString(3, this.gson.toJson(settings));
            stmt.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Claim loadClaim(String claimId) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(LOAD_CLAIM);){
            stmt.setString(1, claimId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Claim claim = this.createClaimFromResultSet(rs, conn);
            return claim;
        }
        catch (SQLException e) {
            Util.log("&cFailed to load claim: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getClaimCount() {
        String sql = "SELECT COUNT(*) FROM claims";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getUserCount() {
        String sql = "SELECT COUNT(*) FROM users";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public List<Claim> loadAllClaims() {
        ArrayList<Claim> claims = new ArrayList<Claim>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(LOAD_ALL_CLAIMS);){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                Claim claim = this.createClaimFromResultSet(rs, conn);
                if (claim == null) continue;
                claims.add(claim);
            }
        }
        catch (SQLException e) {
            Util.log("&cFailed to load claims: " + e.getMessage());
        }
        return claims;
    }

    private Claim createClaimFromResultSet(ResultSet rs, Connection conn) throws SQLException {
        World world = Bukkit.getWorld((String)rs.getString("chunk_world"));
        if (world == null) {
            return null;
        }
        Chunk chunk = world.getChunkAt(rs.getInt("chunk_x"), rs.getInt("chunk_z"));
        String claimId = rs.getString("claim_id");
        Date createdAt = new Date(rs.getTimestamp("created_at").getTime());
        Date expiredAt = new Date(rs.getTimestamp("expired_at").getTime());
        UUID owner = UUID.fromString(rs.getString("owner"));
        Location claimBlockLocation = NClaim.deserializeLocation(rs.getString("claim_block_location"));
        long claimValue = rs.getLong("claim_value");
        Material claimBlockType = Material.valueOf((String)rs.getString("claim_block_type"));
        HashSet<Material> purchasedBlocks = new HashSet<Material>();
        String purchasedBlocksJson = rs.getString("purchased_blocks");
        if (purchasedBlocksJson != null && !purchasedBlocksJson.isEmpty()) {
            Type blockListType = new TypeToken<List<String>>(){}.getType();
            List blockNames = (List)this.gson.fromJson(purchasedBlocksJson, blockListType);
            for (String blockName : blockNames) {
                try {
                    purchasedBlocks.add(Material.valueOf((String)blockName));
                }
                catch (IllegalArgumentException e) {
                    Util.log("&cInvalid material in purchased blocks for claim " + claimId + ": " + blockName);
                }
            }
        }
        Type landType = new TypeToken<Collection<String>>(){}.getType();
        Collection lands = (Collection)this.gson.fromJson(rs.getString("lands"), landType);
        CoopData coopData = this.loadClaimCoops(conn, claimId);
        ClaimSetting settings = this.loadClaimSettings(conn, claimId);
        return new Claim(claimId, chunk, createdAt, expiredAt, owner, claimBlockLocation, claimValue, claimBlockType, lands, coopData.getCoopPlayers(), coopData.getJoinDates(), coopData.getPermissions(), settings, purchasedBlocks);
    }

    private CoopData loadClaimCoops(Connection conn, String claimId) throws SQLException {
        CoopData coopData = new CoopData();
        try (PreparedStatement stmt = conn.prepareStatement(LOAD_CLAIM_COOPS);){
            stmt.setString(1, claimId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                UUID playerUuid = UUID.fromString(rs.getString("player_uuid"));
                coopData.getCoopPlayers().add(playerUuid);
                coopData.getJoinDates().put(playerUuid, new Date(rs.getTimestamp("joined_at").getTime()));
                Type permType = new TypeToken<Map<String, Boolean>>(){}.getType();
                Map permMap = (Map)this.gson.fromJson(rs.getString("permissions"), permType);
                CoopPermission coopPerm = new CoopPermission();
                for (Map.Entry entry : permMap.entrySet()) {
                    coopPerm.setEnabled(Permission.valueOf((String)entry.getKey()), (Boolean)entry.getValue());
                }
                coopData.getPermissions().put(playerUuid, coopPerm);
            }
        }
        return coopData;
    }

    private ClaimSetting loadClaimSettings(Connection conn, String claimId) throws SQLException {
        ClaimSetting settings = new ClaimSetting();
        try (PreparedStatement stmt = conn.prepareStatement(LOAD_CLAIM_SETTINGS);){
            stmt.setString(1, claimId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                Type settingsType = new TypeToken<Map<String, Boolean>>(){}.getType();
                Map settingsMap = (Map)this.gson.fromJson(rs.getString("settings"), settingsType);
                for (Map.Entry entry : settingsMap.entrySet()) {
                    settings.set(Setting.valueOf((String)entry.getKey()), (Boolean)entry.getValue());
                }
            }
        }
        return settings;
    }

    @Override
    public void deleteClaim(String claimId) {
        try (Connection conn = this.getConnection();){
            try (PreparedStatement coopsStmt = conn.prepareStatement(DELETE_CLAIM_COOPS);){
                coopsStmt.setString(1, claimId);
                coopsStmt.executeUpdate();
            }
            try (PreparedStatement settingsStmt = conn.prepareStatement(DELETE_CLAIM_SETTINGS);){
                settingsStmt.setString(1, claimId);
                settingsStmt.executeUpdate();
            }
            try (PreparedStatement claimStmt = conn.prepareStatement(DELETE_CLAIM);){
                claimStmt.setString(1, claimId);
                claimStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            Util.log("&cFailed to delete claim: " + e.getMessage());
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }
}

