/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.hologram;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.util.HexUtil;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.nclaim.Config;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.HoloEnum;
import nesoi.aysihuniks.nclaim.hologram.DecentHologramHandler;
import nesoi.aysihuniks.nclaim.hologram.FancyHologramHandler;
import nesoi.aysihuniks.nclaim.hologram.HologramHandler;
import nesoi.aysihuniks.nclaim.model.Claim;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HologramManager {
    private final NClaim plugin;
    private static final double DECENT_HOLO_OFFSET = NClaim.inst().getConfigManager().getDouble("decentY", 0.0);
    private static final double FANCY_HOLO_OFFSET = NClaim.inst().getConfigManager().getDouble("fancyY", 0.0);
    private HologramHandler hologramHandler;
    private final Set<String> pendingWorlds = new HashSet<String>();
    private boolean initialCleanupDone = false;
    private static final Pattern HOLOGRAM_ID_PATTERN = Pattern.compile("claim_(.+)_(-?\\d+)_(-?\\d+)");

    public HologramManager(NClaim plugin) {
        this.plugin = plugin;
        this.initializeHologramHandler();
        this.identifyPendingWorlds();
        this.scheduleInitialCleanup();
    }

    private void initializeHologramHandler() {
        if (HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM) {
            this.hologramHandler = new DecentHologramHandler();
        } else if (HoloEnum.getActiveHologram() == HoloEnum.FANCY_HOLOGRAM) {
            this.hologramHandler = new FancyHologramHandler();
        } else {
            throw new IllegalStateException("No supported hologram plugin found!");
        }
    }

    private void identifyPendingWorlds() {
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "claims.yml");
        if (!file.exists()) {
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            ConfigurationSection section = config.getConfigurationSection("chunks_claimed");
            if (section == null) {
                return;
            }
            for (String claimId : section.getKeys(false)) {
                String worldName;
                String[] parts = claimId.split("_");
                if (parts.length != 3 || Bukkit.getWorld((String)(worldName = parts[0])) != null) continue;
                this.pendingWorlds.add(worldName);
            }
            if (!this.pendingWorlds.isEmpty()) {
                Util.log("&eWaiting for " + this.pendingWorlds.size() + " worlds to load: " + this.pendingWorlds);
            }
        }
        catch (Exception e) {
            Util.log("&cError identifying pending worlds: " + e.getMessage());
        }
    }

    private void scheduleInitialCleanup() {
        new BukkitRunnable(){

            public void run() {
                HologramManager.this.smartCleanupOrphanedHolograms();
                HologramManager.this.initialCleanupDone = true;
                new BukkitRunnable(){

                    public void run() {
                        HologramManager.this.validateAndRecreateHolograms();
                    }
                }.runTaskLater((Plugin)HologramManager.this.plugin, 60L);
            }
        }.runTaskLater((Plugin)this.plugin, 160L);
    }

    public void smartCleanupOrphanedHolograms() {
        List<String> allHologramIds = this.hologramHandler.getHologramIds();
        int removedCount = 0;
        int protectedCount = 0;
        for (String hologramId : allHologramIds) {
            ChunkInfo chunkInfo;
            if (!hologramId.startsWith("claim_") || (chunkInfo = this.parseHologramId(hologramId)) == null) continue;
            if (this.pendingWorlds.contains(chunkInfo.worldName)) {
                ++protectedCount;
                continue;
            }
            World world = Bukkit.getWorld((String)chunkInfo.worldName);
            if (world == null) {
                this.hologramHandler.deleteHologram(hologramId);
                ++removedCount;
                continue;
            }
            Chunk chunk = world.getChunkAt(chunkInfo.x, chunkInfo.z);
            Claim claim = Claim.getClaim(chunk);
            if (claim != null) continue;
            this.hologramHandler.deleteHologram(hologramId);
            ++removedCount;
        }
        if (removedCount > 0 || protectedCount > 0) {
            Util.log("&aHologram cleanup completed. Removed: " + removedCount + " | Protected: " + protectedCount);
        }
    }

    public void onWorldLoaded(final String worldName) {
        if (!this.pendingWorlds.contains(worldName)) {
            return;
        }
        Util.log("&aPending world '" + worldName + "' loaded! Checking holograms...");
        this.pendingWorlds.remove(worldName);
        new BukkitRunnable(){

            public void run() {
                HologramManager.this.createHologramsForWorld(worldName);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
    }

    public void createHologramsForWorld(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return;
        }
        int created = 0;
        for (Claim claim : Claim.claims) {
            String hologramId;
            if (!claim.getChunk().getWorld().getName().equals(worldName) || !this.hologramExists(hologramId = this.getHologramId(claim.getChunk()))) continue;
            this.createHologramForClaim(claim);
            ++created;
        }
        if (created > 0) {
            Util.log("&aCreated " + created + " holograms for world '" + worldName + "'");
        }
    }

    public void validateAndRecreateHolograms() {
        if (!this.initialCleanupDone) {
            return;
        }
        int created = 0;
        for (Claim claim : Claim.claims) {
            String hologramId = this.getHologramId(claim.getChunk());
            if (!this.hologramExists(hologramId)) continue;
            this.createHologramForClaim(claim);
            ++created;
        }
        if (created > 0) {
            Util.log("&aRecreated " + created + " missing holograms.");
        }
    }

    public boolean hologramExists(String hologramId) {
        return !this.hologramHandler.getHologramIds().contains(hologramId);
    }

    public void createHologramForClaim(Claim claim) {
        if (claim == null) {
            return;
        }
        Location location = claim.getClaimBlockLocation();
        if (location.getWorld() == null) {
            return;
        }
        String hologramId = this.getHologramId(claim.getChunk());
        this.hologramHandler.deleteHologram(hologramId);
        List<String> lines = this.generateHologramLines(claim);
        Location adjustedLocation = this.getCenteredLocation(location.clone(), lines.size());
        this.hologramHandler.createHologram(hologramId, adjustedLocation, lines);
    }

    public void cleanupOrphanedHolograms() {
        this.smartCleanupOrphanedHolograms();
    }

    public void forceCleanup() {
        new BukkitRunnable(){

            public void run() {
                HologramManager.this.smartCleanupOrphanedHolograms();
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void createHologram(Location location) {
        Chunk chunk = location.getChunk();
        Claim claim = Claim.getClaim(chunk);
        if (claim == null) {
            return;
        }
        String hologramId = this.getHologramId(chunk);
        List<String> lines = this.generateHologramLines(claim);
        Location adjustedLocation = this.getCenteredLocation(location.clone(), lines.size());
        this.deleteHologram(chunk);
        this.hologramHandler.createHologram(hologramId, adjustedLocation, lines);
    }

    public void deleteHologram(Chunk chunk) {
        String hologramId = this.getHologramId(chunk);
        this.hologramHandler.deleteHologram(hologramId);
    }

    private Location getCenteredLocation(Location location, int lineCount) {
        double baseOffset = HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM ? DECENT_HOLO_OFFSET : FANCY_HOLO_OFFSET;
        double lineSpacing = this.getLineSpacing();
        double totalHeight = (double)(lineCount - 1) * lineSpacing;
        double centeredOffset = baseOffset + totalHeight / 2.0;
        return location.add(0.5, centeredOffset, 0.5);
    }

    private double getLineSpacing() {
        if (HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM) {
            return 0.3;
        }
        return 0.25;
    }

    private String getHologramId(Chunk chunk) {
        return "claim_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ();
    }

    private List<String> generateHologramLines(Claim claim) {
        long shownLineCount;
        ArrayList<String> lines = new ArrayList<String>();
        Chunk chunk = claim.getChunk();
        Config config = NClaim.inst().getNconfig();
        if (config.isShowHologramTitle()) {
            lines.add(this.plugin.getLangManager().getString("hologram.title"));
        }
        if (config.isShowHologramOwner()) {
            lines.add(this.plugin.getLangManager().getString("hologram.owner").replace("{owner}", "%nclaim_owner_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        }
        if (config.isShowHologramTimeLeft()) {
            lines.add(this.plugin.getLangManager().getString("hologram.time_left.text").replace("{time_left}", "%nclaim_expiration_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        }
        if (config.isShowHologramCoopCount()) {
            lines.add(this.plugin.getLangManager().getString("hologram.coop_count").replace("{coop_count}", "%nclaim_coop_count_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        }
        if (config.isShowHologramTotalSize()) {
            lines.add(this.plugin.getLangManager().getString("hologram.total_size").replace("{total_size}", "%nclaim_total_size_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        }
        if ((shownLineCount = lines.stream().filter(s -> !s.isEmpty()).count()) > 1L) {
            lines.add("");
        }
        if (config.isShowHologramEdit()) {
            lines.add(this.plugin.getLangManager().getString("hologram.edit"));
        }
        return lines.stream().map(HexUtil::parse).collect(Collectors.toList());
    }

    private ChunkInfo parseHologramId(String hologramId) {
        Matcher matcher = HOLOGRAM_ID_PATTERN.matcher(hologramId);
        if (!matcher.matches()) {
            return null;
        }
        try {
            String worldName = matcher.group(1);
            int x = Integer.parseInt(matcher.group(2));
            int z = Integer.parseInt(matcher.group(3));
            return new ChunkInfo(worldName, x, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Set<String> getPendingWorlds() {
        return new HashSet<String>(this.pendingWorlds);
    }

    private static class ChunkInfo {
        final String worldName;
        final int x;
        final int z;

        ChunkInfo(String worldName, int x, int z) {
            this.worldName = worldName;
            this.x = x;
            this.z = z;
        }
    }
}

