/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.model;

import java.util.EnumMap;
import java.util.Map;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.PermissionCategory;

public class CoopPermission {
    private final Map<Permission, Boolean> permissionStates = new EnumMap<Permission, Boolean>(Permission.class);

    public CoopPermission() {
        for (Permission permission : Permission.values()) {
            this.permissionStates.put(permission, false);
        }
    }

    public boolean isEnabled(Permission permission) {
        return this.permissionStates.getOrDefault((Object)permission, false);
    }

    public void setEnabled(Permission permission, boolean enabled) {
        this.permissionStates.put(permission, enabled);
    }

    public void toggle(Permission permission) {
        this.setEnabled(permission, !this.isEnabled(permission));
    }

    public boolean hasAllPermissionsInCategory(PermissionCategory category) {
        return category.getPermissions().stream().allMatch(this::isEnabled);
    }

    public void setAllPermissionsInCategory(PermissionCategory category, boolean state) {
        category.getPermissions().forEach(permission -> this.permissionStates.put((Permission)((Object)permission), state));
    }

    public Map<PermissionCategory, Permission[]> getPermissionsByCategory() {
        EnumMap<PermissionCategory, Permission[]> result = new EnumMap<PermissionCategory, Permission[]>(PermissionCategory.class);
        for (PermissionCategory category : PermissionCategory.values()) {
            result.put(category, category.getPermissions().toArray(new Permission[0]));
        }
        return result;
    }

    public Map<Permission, Boolean> getAllPermissions() {
        return new EnumMap<Permission, Boolean>(this.permissionStates);
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Permission, Boolean> entry : this.permissionStates.entrySet()) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(entry.getKey().name()).append(":").append(entry.getValue() != false ? "1" : "0");
        }
        return builder.toString();
    }

    public static CoopPermission deserialize(String data) {
        String[] pairs;
        CoopPermission permission = new CoopPermission();
        if (data == null || data.isEmpty()) {
            return permission;
        }
        for (String pair : pairs = data.split(",")) {
            String[] parts = pair.split(":");
            if (parts.length != 2) continue;
            try {
                Permission perm = Permission.valueOf(parts[0]);
                boolean value = "1".equals(parts[1]);
                permission.setEnabled(perm, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return permission;
    }

    public void reset() {
        for (Permission permission : Permission.values()) {
            this.permissionStates.put(permission, false);
        }
    }

    public void copyFrom(CoopPermission other) {
        this.permissionStates.clear();
        this.permissionStates.putAll(other.permissionStates);
    }
}

