/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.coop;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.PermissionCategory;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopListMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoopPermissionsMenu
extends BaseMenu {
    @Nullable
    private final OfflinePlayer coopPlayer;
    @NotNull
    private final Claim claim;
    private final boolean admin;
    @Nullable
    private final PermissionCategory currentCategory;
    private static final int[] CATEGORY_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final int[] PERMISSION_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final Map<PermissionCategory, ItemStack> CATEGORY_ICONS = new EnumMap<PermissionCategory, ItemStack>(PermissionCategory.class);

    public CoopPermissionsMenu(@NotNull Player player, @Nullable OfflinePlayer coopPlayer, @NotNull Claim claim, boolean admin, @Nullable PermissionCategory category) {
        super("manage_coop_player_permission_menu");
        this.coopPlayer = coopPlayer;
        this.claim = claim;
        this.admin = admin;
        this.currentCategory = category;
        this.setupMenu();
        this.displayTo(player);
    }

    private void loadCategoryIcons() {
        for (PermissionCategory category : PermissionCategory.values()) {
            this.CATEGORY_ICONS.put(category, this.getMaterial("categories." + category.name().toLowerCase()));
        }
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title").replace("{player}", this.coopPlayer != null && this.coopPlayer.getName() != null ? this.coopPlayer.getName() : "Unknown"));
        this.loadCategoryIcons();
        this.addBackButton();
        this.addPlayerInfoButton();
        this.addCategoryButtons();
        this.addPermissionButtons();
        this.addTransferButton();
        this.addKickButton();
    }

    private void addBackButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CoopPermissionsMenu.this.currentCategory == null ? CoopPermissionsMenu.this.getMaterialFullPath("back") : CoopPermissionsMenu.this.getMaterialFullPath("previous_page")).name(NClaim.inst().getGuiLangManager().getString((CoopPermissionsMenu.this.currentCategory == null ? "back" : "previous_page") + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (CoopPermissionsMenu.this.currentCategory == null) {
                    new CoopListMenu(player, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, 0);
                } else {
                    new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, null);
                }
            }
        });
    }

    private void addPlayerInfoButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                String name = CoopPermissionsMenu.this.coopPlayer != null && CoopPermissionsMenu.this.coopPlayer.getName() != null ? CoopPermissionsMenu.this.coopPlayer.getName() : "Unknown";
                String playerName = CoopPermissionsMenu.this.coopPlayer != null && CoopPermissionsMenu.this.coopPlayer.isOnline() ? "&a" + name : "&7" + name + " " + CoopPermissionsMenu.this.getString("offline");
                ArrayList<String> lore = new ArrayList<String>(CoopPermissionsMenu.this.getStringList("player_info.lore"));
                lore.replaceAll(s -> s.replace("{date}", NClaim.serializeDate(CoopPermissionsMenu.this.claim.getCoopPlayerJoinDate().get(CoopPermissionsMenu.this.coopPlayer.getUniqueId()))));
                return ItemCreator.of(NClaim.inst().getHeadManager().createHeadFromCache(CoopPermissionsMenu.this.coopPlayer.getUniqueId())).name(CoopPermissionsMenu.this.getString("player_info.display_name").replace("{player}", playerName)).lore(lore).get();
            }
        });
    }

    private void addCategoryButtons() {
        if (this.currentCategory != null) {
            return;
        }
        int slot = 0;
        for (final PermissionCategory category : PermissionCategory.values()) {
            if (slot >= CATEGORY_SLOTS.length) break;
            final int currentSlot = slot++;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{CATEGORY_SLOTS[currentSlot]});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of((ItemStack)CoopPermissionsMenu.this.CATEGORY_ICONS.get((Object)category)).name(CoopPermissionsMenu.this.getString("categories." + category.name().toLowerCase() + ".display_name")).lore(Arrays.asList("", CoopPermissionsMenu.this.getString("click_to_view"), "", CoopPermissionsMenu.this.getString("right_click_toggle"))).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    if (clickType == ClickType.RIGHT) {
                        MessageType.CONFIRM.playSound(player);
                        NClaim.inst().getClaimCoopManager().toggleCoopPermissionCategory(CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.coopPlayer.getUniqueId(), category);
                    }
                    MessageType.MENU_FORWARD.playSound(player);
                    new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, category);
                }
            });
        }
    }

    private void addPermissionButtons() {
        if (this.currentCategory == null) {
            return;
        }
        Permission[] permissions = this.claim.getCoopPermissions().get(this.coopPlayer.getUniqueId()).getPermissionsByCategory().get((Object)this.currentCategory);
        int slot = 0;
        for (final Permission permission : permissions) {
            if (slot >= PERMISSION_SLOTS.length) break;
            final int currentSlot = slot++;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{PERMISSION_SLOTS[currentSlot]});
                }

                @Override
                public ItemStack getItem() {
                    boolean isEnabled = CoopPermissionsMenu.this.claim.getCoopPermissions().get(CoopPermissionsMenu.this.coopPlayer.getUniqueId()).isEnabled(permission);
                    return ItemCreator.of(CoopPermissionsMenu.this.getPermissionIcon(permission)).name((isEnabled ? "&a" : "&c") + CoopPermissionsMenu.this.getString("permissions." + permission.name().toLowerCase() + ".display_name")).lore(Arrays.asList("", NClaim.inst().getGuiLangManager().getString(isEnabled ? "enabled.display_name" : "disabled.display_name"))).flags(ItemFlag.values()).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    NClaim.inst().getClaimCoopManager().toggleCoopPermission(CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.coopPlayer.getUniqueId(), permission);
                    MessageType.CONFIRM.playSound(player);
                    new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, CoopPermissionsMenu.this.currentCategory);
                }
            });
        }
    }

    private ItemStack getPermissionIcon(Permission permission) {
        return this.getMaterial("permissions." + permission.name().toLowerCase(Locale.ENGLISH));
    }

    private void addTransferButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CoopPermissionsMenu.this.getMaterial("transfer")).name(CoopPermissionsMenu.this.getString("transfer.display_name")).lore(CoopPermissionsMenu.this.getStringList("transfer.lore").stream().map(line -> line.replace("{player}", CoopPermissionsMenu.this.coopPlayer != null && CoopPermissionsMenu.this.coopPlayer.getName() != null ? CoopPermissionsMenu.this.coopPlayer.getName() : "Unknown")).collect(Collectors.toList())).flags(ItemFlag.HIDE_ATTRIBUTES).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (CoopPermissionsMenu.this.coopPlayer == null) {
                    player.sendMessage(NClaim.inst().getLangManager().getString("command.player.not_found"));
                    return;
                }
                new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.transfer_claim.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.transfer_claim.lore").stream().map(s -> s.replace("{player}", CoopPermissionsMenu.this.coopPlayer.getName() != null ? CoopPermissionsMenu.this.coopPlayer.getName() : "Unknown")).collect(Collectors.toList()), result -> {
                    if ("confirmed".equals(result)) {
                        player.closeInventory();
                        CoopPermissionsMenu.this.claim.setOwner(CoopPermissionsMenu.this.coopPlayer.getUniqueId());
                        player.sendMessage(NClaim.inst().getLangManager().getString("claim.transferred").replace("{target}", CoopPermissionsMenu.this.coopPlayer.getName() != null ? CoopPermissionsMenu.this.coopPlayer.getName() : "Unknown"));
                    } else if ("declined".equals(result)) {
                        new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, CoopPermissionsMenu.this.currentCategory);
                    }
                });
            }
        });
    }

    private void addKickButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CoopPermissionsMenu.this.getMaterial("kick")).name(CoopPermissionsMenu.this.getString("kick.display_name")).lore(CoopPermissionsMenu.this.getStringList("kick.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.kick_coop.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.kick_coop.lore").stream().map(s -> s.replace("{player}", CoopPermissionsMenu.this.coopPlayer != null && CoopPermissionsMenu.this.coopPlayer.getName() != null ? CoopPermissionsMenu.this.coopPlayer.getName() : "Unknown")).collect(Collectors.toList()), result -> {
                    if ("confirmed".equals(result)) {
                        player.closeInventory();
                        NClaim.inst().getClaimCoopManager().removeCoopPlayer(CoopPermissionsMenu.this.claim, player, CoopPermissionsMenu.this.coopPlayer.getUniqueId());
                    } else if ("declined".equals(result)) {
                        new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, CoopPermissionsMenu.this.currentCategory);
                    }
                });
            }
        });
    }
}

