/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.SettingData;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimSettingsMenu
extends BaseMenu {
    private final Claim claim;
    private final int page;
    private final boolean admin;
    private static final int[] settingSlots = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final List<SettingData> settings = Arrays.asList(new SettingData(Setting.CLAIM_PVP, "pvp", this.getMaterial("settings.pvp")), new SettingData(Setting.TNT_DAMAGE, "tnt_explosions", this.getMaterial("settings.tnt_explosions")), new SettingData(Setting.CREEPER_DAMAGE, "creeper_explosions", this.getMaterial("settings.creeper_explosions")), new SettingData(Setting.MOB_ATTACKING, "mob_attacks", this.getMaterial("settings.mob_attacks")), new SettingData(Setting.MONSTER_SPAWNING, "monster_spawning", this.getMaterial("settings.monster_spawning")), new SettingData(Setting.ANIMAL_SPAWNING, "animal_spawning", this.getMaterial("settings.animal_spawning")), new SettingData(Setting.VILLAGER_INTERACTION, "villager_interactions", this.getMaterial("settings.villager_interactions")));

    public ClaimSettingsMenu(Player player, Claim claim, int page, boolean admin) {
        super("claim_settings_menu");
        this.claim = claim;
        this.page = page;
        this.admin = admin;
        this.setupMenu();
        this.displayTo(player);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.addNavigationButton();
        this.addSettingButtons();
        if (this.hasNextPage()) {
            this.addNextPageButton();
        }
    }

    private void addNavigationButton() {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = ClaimSettingsMenu.this.page == 0 ? "back" : "previous_page";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimSettingsMenu.this.getMaterialFullPath(this.buttonPath)).name(NClaim.inst().getGuiLangManager().getString(this.buttonPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (ClaimSettingsMenu.this.page == 0) {
                    new ClaimManagementMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.admin);
                } else {
                    new ClaimSettingsMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.page - 1, ClaimSettingsMenu.this.admin);
                }
            }
        });
    }

    private void addNextPageButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimSettingsMenu.this.getMaterialFullPath("next_page")).name(NClaim.inst().getGuiLangManager().getString("next_page.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new ClaimSettingsMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.page + 1, ClaimSettingsMenu.this.admin);
            }
        });
    }

    private void addSettingButtons() {
        int startIndex = this.page * settingSlots.length;
        int endIndex = Math.min(startIndex + settingSlots.length, this.settings.size());
        int i = startIndex;
        int slotIndex = 0;
        while (i < endIndex) {
            SettingData settingData = this.settings.get(i);
            this.addSettingButton(settingData, slotIndex);
            ++i;
            ++slotIndex;
        }
    }

    private void addSettingButton(final SettingData settingData, final int slotIndex) {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = "settings." + settingData.getConfigKey();
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{settingSlots[slotIndex]});
            }

            @Override
            public ItemStack getItem() {
                boolean isEnabled = ClaimSettingsMenu.this.claim.getSettings().isEnabled(settingData.getSetting());
                String status = ClaimSettingsMenu.this.guiLangManager.getString((isEnabled ? "enabled" : "disabled") + ".display_name");
                List lore = ClaimSettingsMenu.this.getStringList(this.buttonPath + ".lore");
                lore.replaceAll(l -> l.replace("{status}", status));
                return ItemCreator.of(settingData.getMaterial()).name(ClaimSettingsMenu.this.getString(this.buttonPath + ".display_name")).lore(lore).flags(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.CONFIRM.playSound(player);
                NClaim.inst().getClaimSettingsManager().toggleSetting(ClaimSettingsMenu.this.claim, player, settingData.getSetting());
                new ClaimSettingsMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.page, ClaimSettingsMenu.this.admin);
            }
        });
    }

    private boolean hasNextPage() {
        return (this.page + 1) * settingSlots.length < this.settings.size();
    }
}

