/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.object.DParticle;
import nesoi.aysihuniks.libs.dapi.object.DSound;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.service.ClaimBlockManager;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageClaimBlockMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    @NotNull
    private final Player player;
    private final ClaimBlockManager blockManager;
    private int page = 0;
    private static final int[] BLOCK_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final int NEXT_PAGE_SLOT = 16;
    private static final int PREV_PAGE_SLOT = 10;

    private List<ClaimBlockManager.ClaimBlockInfo> allowedBlocks() {
        ArrayList<ClaimBlockManager.ClaimBlockInfo> result = new ArrayList<ClaimBlockManager.ClaimBlockInfo>();
        for (ClaimBlockManager.ClaimBlockInfo info : this.blockManager.getAllBlockInfos()) {
            if (!info.enabled) continue;
            result.add(info);
        }
        return result;
    }

    public ManageClaimBlockMenu(@NotNull Claim claim, @NotNull Player player, int page) {
        super("claim_block_management_menu");
        this.claim = claim;
        this.player = player;
        this.blockManager = NClaim.inst().getClaimBlockManager();
        this.page = page;
        this.setup();
        this.displayTo(player);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setup() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.addButton(new Button(){

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(ManageClaimBlockMenu.this.getMaterial("teleport")).name(ManageClaimBlockMenu.this.getString("teleport.display_name")).lore(ManageClaimBlockMenu.this.getStringList("teleport.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                if (!ManageClaimBlockMenu.this.claim.isSafeToTeleport()) {
                    ChannelType.CHAT.send((CommandSender)ManageClaimBlockMenu.this.player, NClaim.inst().getLangManager().getString("claim.teleport.failed"));
                    return;
                }
                ManageClaimBlockMenu.this.claim.teleport(ManageClaimBlockMenu.this.player);
                ChannelType.CHAT.send((CommandSender)ManageClaimBlockMenu.this.player, NClaim.inst().getLangManager().getString("claim.teleport.success"));
                ManageClaimBlockMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(ManageClaimBlockMenu.this.getMaterial("move_claim_block")).name(ManageClaimBlockMenu.this.getString("move_claim_block.display_name")).lore(ManageClaimBlockMenu.this.getStringList("move_claim_block.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                if (!NClaim.inst().getClaimCoopManager().hasPermission(ManageClaimBlockMenu.this.player, ManageClaimBlockMenu.this.claim, Permission.MOVE_CLAIM_BLOCK)) {
                    ChannelType.CHAT.send((CommandSender)ManageClaimBlockMenu.this.player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                    return;
                }
                Location playerLocation = ManageClaimBlockMenu.this.player.getLocation().getBlock().getLocation();
                if (!ManageClaimBlockMenu.this.claim.getChunk().equals((Object)playerLocation.getChunk())) {
                    ChannelType.CHAT.send((CommandSender)ManageClaimBlockMenu.this.player, NClaim.inst().getLangManager().getString("claim.move.outside_of_chunk"));
                    return;
                }
                new ConfirmMenu(ManageClaimBlockMenu.this.player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.move_claim_block.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.move_claim_block.lore"), result -> {
                    if ("confirmed".equals(result)) {
                        ManageClaimBlockMenu.this.player.closeInventory();
                        ManageClaimBlockMenu.this.claim.moveClaimBlock(playerLocation);
                        ChannelType.CHAT.send((CommandSender)ManageClaimBlockMenu.this.player, NClaim.inst().getLangManager().getString("claim.move.success"));
                    } else if ("declined".equals(result)) {
                        new ManageClaimBlockMenu(ManageClaimBlockMenu.this.claim, ManageClaimBlockMenu.this.player, ManageClaimBlockMenu.this.page);
                    }
                });
            }
        });
        if (NClaim.inst().getClaimCoopManager().hasPermission(this.player, this.claim, Permission.MANAGE_CLAIM_BLOCK_TYPES)) {
            List<ClaimBlockManager.ClaimBlockInfo> blockInfos = this.allowedBlocks();
            int start = this.page * BLOCK_SLOTS.length;
            int end = Math.min(blockInfos.size(), start + BLOCK_SLOTS.length);
            int i = start;
            int j = 0;
            while (i < end) {
                final ClaimBlockManager.ClaimBlockInfo info = blockInfos.get(i);
                final int slot = BLOCK_SLOTS[j];
                this.addButton(new Button(){

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    @Nullable
                    public ItemStack getItem() {
                        ItemCreator creator = ItemCreator.of(info.material).name("&e" + info.displayName);
                        if (info.lore != null && !info.lore.isEmpty()) {
                            double playerBalance = NClaim.inst().getBalanceSystem() == Balance.VAULT ? NClaim.inst().getEconomy().getBalance((OfflinePlayer)ManageClaimBlockMenu.this.player) : User.getUser(ManageClaimBlockMenu.this.player.getUniqueId()).getBalance();
                            DecimalFormat df = new DecimalFormat("#.##");
                            List<String> updatedLore = info.lore.stream().map(line -> {
                                if (line.contains("{cost}") || line.contains("{need_balance}")) {
                                    String balanceColor = playerBalance >= info2.price ? "&a" : "&c";
                                    String formattedPrice = df.format(info2.price);
                                    String formattedNeededBalance = df.format(Math.min(playerBalance, info2.price));
                                    return line.replace("{cost}", formattedPrice).replace("{need_balance}", balanceColor + formattedNeededBalance);
                                }
                                return line;
                            }).collect(Collectors.toList());
                            creator.lore(updatedLore);
                        }
                        if (ManageClaimBlockMenu.this.claim.getClaimBlockType() == info.material) {
                            creator.enchant(Enchantment.MENDING, 1);
                            creator.flags(ItemFlag.values());
                        }
                        return creator.get();
                    }

                    @Override
                    public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                        if (info.permission != null && !info.permission.isEmpty() && !player.hasPermission(info.permission)) {
                            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                            return;
                        }
                        if (!ManageClaimBlockMenu.this.claim.getPurchasedBlockTypes().contains(info.material)) {
                            boolean useVault = NClaim.inst().getBalanceSystem() == Balance.VAULT;
                            double balance = useVault ? NClaim.inst().getEconomy().getBalance((OfflinePlayer)player) : User.getUser(player.getUniqueId()).getBalance();
                            if (balance < info.price) {
                                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.balance.not_enough"));
                                return;
                            }
                            if (useVault) {
                                NClaim.inst().getEconomy().withdrawPlayer((OfflinePlayer)player, info.price);
                            } else {
                                User.getUser(player.getUniqueId()).setBalance(balance - info.price);
                            }
                            ManageClaimBlockMenu.this.claim.getPurchasedBlockTypes().add(info.material);
                            NClaim.inst().getClaimStorageManager().saveClaim(ManageClaimBlockMenu.this.claim);
                            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("claim.block.purchased").replace("{block}", info.displayName).replace("{price}", String.valueOf(info.price)));
                        }
                        if (ManageClaimBlockMenu.this.claim.getClaimBlockType() == info.material) {
                            return;
                        }
                        Material oldBlockType = ManageClaimBlockMenu.this.claim.getClaimBlockType();
                        ClaimBlockManager.ClaimBlockInfo oldBlockInfo = NClaim.inst().getClaimBlockManager().getBlockInfo(oldBlockType);
                        String oldBlockDisplayName = oldBlockInfo != null ? oldBlockInfo.displayName : oldBlockType.name();
                        player.playSound(player.getLocation(), DSound.BLOCK_BEACON_POWER_SELECT.parseSound(), 0.5f, 0.7f);
                        ManageClaimBlockMenu.this.claim.setClaimBlockType(info.material);
                        ManageClaimBlockMenu.this.claim.getClaimBlockLocation().getBlock().setType(info.material);
                        NClaim.inst().getClaimStorageManager().saveClaim(ManageClaimBlockMenu.this.claim);
                        ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("claim.block.changed").replace("{old_block}", oldBlockDisplayName).replace("{new_block}", info.displayName));
                        player.closeInventory();
                        World world = ManageClaimBlockMenu.this.claim.getClaimBlockLocation().getWorld();
                        NClaim.inst();
                        world.spawnParticle(NClaim.getParticle(DParticle.TOTEM_OF_UNDYING, DParticle.TOTEM), ManageClaimBlockMenu.this.claim.getClaimBlockLocation(), 1);
                    }
                });
                ++i;
                ++j;
            }
            if (blockInfos.size() > (this.page + 1) * BLOCK_SLOTS.length) {
                this.addButton(new Button(){

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{16});
                    }

                    @Override
                    @Nullable
                    public ItemStack getItem() {
                        return ItemCreator.of(ManageClaimBlockMenu.this.getMaterialFullPath("next_page")).name(NClaim.inst().getGuiLangManager().getString("next_page.display_name")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player clicker, @NotNull ClickType clickType) {
                        if (!NClaim.inst().getClaimCoopManager().hasPermission(ManageClaimBlockMenu.this.player, ManageClaimBlockMenu.this.claim, Permission.MANAGE_CLAIM_BLOCK_TYPES)) {
                            ChannelType.CHAT.send((CommandSender)ManageClaimBlockMenu.this.player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                            return;
                        }
                        MessageType.MENU_FORWARD.playSound(ManageClaimBlockMenu.this.player);
                        new ManageClaimBlockMenu(ManageClaimBlockMenu.this.claim, clicker, ManageClaimBlockMenu.this.page + 1);
                    }
                });
            }
        }
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = ManageClaimBlockMenu.this.page == 0 ? "back" : "previous_page";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(ManageClaimBlockMenu.this.getMaterialFullPath(this.buttonPath)).name(NClaim.inst().getGuiLangManager().getString(this.buttonPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player clicker, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(ManageClaimBlockMenu.this.player);
                if (ManageClaimBlockMenu.this.page == 0) {
                    new ClaimManagementMenu(ManageClaimBlockMenu.this.player, ManageClaimBlockMenu.this.claim, false);
                } else {
                    new ManageClaimBlockMenu(ManageClaimBlockMenu.this.claim, clicker, ManageClaimBlockMenu.this.page - 1);
                }
            }
        });
    }
}

