/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.object.DMaterial;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeManagementMenu
extends BaseMenu {
    private int days;
    private int hours;
    private int minutes;
    private int timeUnit;
    @NotNull
    private final Claim claim;
    private final boolean admin;

    public TimeManagementMenu(@NotNull Player player, int days, int hours, int minutes, int timeUnit, @NotNull Claim claim, boolean admin) {
        super("claim_time_management_menu");
        this.claim = claim;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.timeUnit = timeUnit;
        this.admin = admin;
        this.setupMenu();
        this.displayTo(player);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_5_ROWS, this.getString("title"));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(TimeManagementMenu.this.getStringList("claim_info.lore"));
                lore.replaceAll(s -> s.replace("{time_left}", NClaim.inst().getClaimExpirationManager().getFormattedTimeLeft(TimeManagementMenu.this.claim)).replace("{expires_at}", NClaim.serializeDate(TimeManagementMenu.this.claim.getExpiredAt())));
                return ItemCreator.of(NClaim.getMaterial(DMaterial.GLOW_ITEM_FRAME, DMaterial.ITEM_FRAME)).name(TimeManagementMenu.this.getString("claim_info.display_name")).lore(lore).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{31});
            }

            @Override
            public ItemStack getItem() {
                double totalPrice = TimeManagementMenu.this.calculateTotalPrice();
                double tax = totalPrice * NClaim.inst().getNconfig().getTimeExtensionTaxRate();
                double finalPrice = totalPrice + tax;
                ArrayList<String> lore = new ArrayList<String>(TimeManagementMenu.this.getStringList("confirm.lore"));
                String priceStr = TimeManagementMenu.this.admin ? NClaim.inst().getGuiLangManager().getString("free") : String.format("%.2f", finalPrice);
                lore.replaceAll(s -> s.replace("{price}", priceStr).replace("{d}", String.valueOf(TimeManagementMenu.this.days)).replace("{h}", String.valueOf(TimeManagementMenu.this.hours)).replace("{m}", String.valueOf(TimeManagementMenu.this.minutes)));
                return ItemCreator.of(Material.BLUE_ICE).name(TimeManagementMenu.this.getString("confirm.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (TimeManagementMenu.this.days == 0 && TimeManagementMenu.this.hours == 0 && TimeManagementMenu.this.minutes == 0) {
                    ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("claim.time.no_time_selected"));
                    MessageType.FAIL.playSound(player);
                    return;
                }
                if (!TimeManagementMenu.this.admin) {
                    double totalPrice = TimeManagementMenu.this.calculateTotalPrice();
                    double tax = totalPrice * NClaim.inst().getNconfig().getTimeExtensionTaxRate();
                    double finalPrice = totalPrice + tax;
                    if (NClaim.inst().getBalanceSystem() == Balance.PLAYERDATA) {
                        User user = User.getUser(player.getUniqueId());
                        if (user == null) {
                            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.player_data_not_found"));
                            MessageType.FAIL.playSound(player);
                            return;
                        }
                        if (user.getBalance() < finalPrice) {
                            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.balance.not_enough"));
                            MessageType.FAIL.playSound(player);
                            return;
                        }
                        user.addBalance(-finalPrice);
                    } else {
                        if (NClaim.inst().getEconomy().getBalance((OfflinePlayer)player) < finalPrice) {
                            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.balance.not_enough"));
                            MessageType.FAIL.playSound(player);
                            return;
                        }
                        NClaim.inst().getEconomy().withdrawPlayer((OfflinePlayer)player, finalPrice);
                    }
                }
                NClaim.inst().getClaimExpirationManager().extendClaimExpiration(TimeManagementMenu.this.claim, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes);
                String priceStr = TimeManagementMenu.this.admin ? NClaim.inst().getGuiLangManager().getString("free") : String.format("%.2f", TimeManagementMenu.this.calculateTotalPrice() + TimeManagementMenu.this.calculateTotalPrice() * NClaim.inst().getNconfig().getTimeExtensionTaxRate());
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.expiration_extended").replace("{d}", String.valueOf(TimeManagementMenu.this.days)).replace("{h}", String.valueOf(TimeManagementMenu.this.hours)).replace("{m}", String.valueOf(TimeManagementMenu.this.minutes)).replace("{price}", priceStr));
                MessageType.CONFIRM.playSound(player);
                player.closeInventory();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.OAK_DOOR).name(NClaim.inst().getGuiLangManager().getString("back.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                new ClaimManagementMenu(player, TimeManagementMenu.this.claim, TimeManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(TimeManagementMenu.this.getStringList("select_time_unit.lore"));
                lore.replaceAll(s -> s.replace("{days_status}", TimeManagementMenu.this.timeUnit == 0 ? "&e" + TimeManagementMenu.this.getString("days_status") : "&7" + TimeManagementMenu.this.getString("days_status")).replace("{hours_status}", TimeManagementMenu.this.timeUnit == 1 ? "&e" + TimeManagementMenu.this.getString("hours_status") : "&7" + TimeManagementMenu.this.getString("hours_status")).replace("{minutes_status}", TimeManagementMenu.this.timeUnit == 2 ? "&e" + TimeManagementMenu.this.getString("minutes_status") : "&7" + TimeManagementMenu.this.getString("minutes_status")));
                return ItemCreator.of(NClaim.getMaterial(DMaterial.IRON_CHAIN, DMaterial.CHAIN)).name(TimeManagementMenu.this.getString("select_time_unit.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.timeUnit = (TimeManagementMenu.this.timeUnit + 1) % 3;
                MessageType.MENU_REFRESH.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim, TimeManagementMenu.this.admin);
            }
        });
        this.addTimeButtons();
    }

    private double calculateTotalPrice() {
        return (double)this.days * NClaim.inst().getNconfig().getTimeExtensionPricePerDay() + (double)this.hours * NClaim.inst().getNconfig().getTimeExtensionPricePerHour() + (double)this.minutes * NClaim.inst().getNconfig().getTimeExtensionPricePerMinute();
    }

    private void addTimeButtons() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{28});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.LIME_CONCRETE).name(TimeManagementMenu.this.getString("add_one.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(1, TimeManagementMenu.this.admin);
                MessageType.VALUE_INCREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim, TimeManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{29});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GREEN_CONCRETE).name(TimeManagementMenu.this.getString("add_six.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(6, TimeManagementMenu.this.admin);
                MessageType.VALUE_INCREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim, TimeManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{33});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PINK_CONCRETE).name(TimeManagementMenu.this.getString("subtract_one.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(-1, TimeManagementMenu.this.admin);
                MessageType.VALUE_DECREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim, TimeManagementMenu.this.admin);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{34});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.RED_CONCRETE).name(TimeManagementMenu.this.getString("subtract_six.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(-6, TimeManagementMenu.this.admin);
                MessageType.VALUE_DECREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim, TimeManagementMenu.this.admin);
            }
        });
    }

    private String getTimeUnitString() {
        switch (this.timeUnit) {
            case 1: {
                return this.getString("hours_status");
            }
            case 2: {
                return this.getString("minutes_status");
            }
        }
        return this.getString("days_status");
    }

    private void adjustTime(int amount, boolean admin) {
        switch (this.timeUnit) {
            case 0: {
                this.days = admin ? this.days + amount : Math.max(0, this.days + amount);
                break;
            }
            case 1: {
                this.hours = admin ? this.hours + amount : Math.max(0, this.hours + amount);
                break;
            }
            case 2: {
                this.minutes = admin ? this.minutes + amount : Math.max(0, this.minutes + amount);
            }
        }
    }
}

