/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.shared;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class ConfirmMenu
extends BaseMenu {
    private final String itemName;
    private final List<String> lore;
    private final Consumer<String> onFinish;

    public ConfirmMenu(Player player, String itemName, List<String> lore, Consumer<String> onFinish) {
        super("confirm_menu");
        this.itemName = itemName;
        this.lore = lore;
        this.onFinish = onFinish;
        this.createInventory(MenuType.CHEST_3_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.setup();
        MessageType.MENU_FORWARD.playSound(player);
        this.displayTo(player);
    }

    private void setup() {
        this.addInfoButton();
        this.addConfirmButton();
        this.addDeclineButton();
    }

    private void addInfoButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BOOK).name(ConfirmMenu.this.itemName).lore(ConfirmMenu.this.lore).get();
            }
        });
    }

    private void addConfirmButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GREEN_DYE).name(ConfirmMenu.this.getString("confirm.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                ConfirmMenu.this.onFinish.accept("confirmed");
                MessageType.CONFIRM.playSound(player);
            }
        });
    }

    private void addDeclineButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{15});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.RED_DYE).name(ConfirmMenu.this.getString("decline.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                ConfirmMenu.this.onFinish.accept("declined");
                MessageType.WARN.playSound(player);
            }
        });
    }
}

