/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;

public class HexUtil {
    private static final Pattern PATTERN = Pattern.compile("<(#[a-f0-9]{6}|aqua|black|blue|dark_(aqua|blue|gray|green|purple|red)|gray|gold|green|light_purple|red|white|yellow)>", 2);
    public static Map<String, String> placeholders = new HashMap<String, String>();

    public static String color(@NotNull String text) {
        if (text.isEmpty()) {
            return "";
        }
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            try {
                ChatColor chatColor = ChatColor.of((String)matcher.group(1));
                if (chatColor == null) continue;
                text = text.replace(matcher.group(), chatColor.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String parse(@NotNull String text) {
        if (text.isEmpty()) {
            return "";
        }
        String out = text;
        for (String placeholder : placeholders.keySet()) {
            String value = placeholders.get(placeholder);
            out = out.replace(placeholder, value);
        }
        return HexUtil.color(out);
    }
}

