/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi;

import java.lang.reflect.Constructor;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;

public class Wrapper {
    private final int minecraftVersion = this.fetchVersion();
    @Nullable
    private Attribute attribute;
    @Nullable
    private AttributeModifier attributeModifier;

    public Wrapper() {
        this.setupArmorAttributeModifier();
    }

    private int fetchVersion() {
        String[] ver = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        if (ver.length < 2) {
            Util.log("{WARN}DAPI: Could not fetch server version!");
            return 165;
        }
        int major = 0;
        try {
            major = Integer.parseInt(ver[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int minor = 0;
        if (ver.length >= 3) {
            try {
                minor = Integer.parseInt(ver[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return major * 10 + minor;
    }

    public void setupArmorAttributeModifier() {
        if (this.minecraftVersion >= 213) {
            this.attribute = Attribute.ARMOR;
            this.attributeModifier = new AttributeModifier(new NamespacedKey("dapi", "foo"), 0.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
        } else if (this.minecraftVersion >= 210) {
            Attribute armorAttribute = null;
            try {
                Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                armorAttribute = (Attribute)Enum.valueOf(attributeClass, "GENERIC_ARMOR");
            }
            catch (ClassNotFoundException attributeClass) {
                // empty catch block
            }
            this.attribute = armorAttribute;
            this.attributeModifier = new AttributeModifier(new NamespacedKey("dapi", "foo"), 0.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
        } else {
            Attribute armorAttribute = null;
            try {
                Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                armorAttribute = (Attribute)Enum.valueOf(attributeClass, "GENERIC_ARMOR");
            }
            catch (Exception attributeClass) {
                // empty catch block
            }
            this.attribute = armorAttribute;
            AttributeModifier attributeModifier = null;
            try {
                Class<?> modifierClass = Class.forName("org.bukkit.attribute.AttributeModifier");
                Class<?> operationClass = Class.forName("org.bukkit.attribute.AttributeModifier$Operation");
                Object operation = Enum.valueOf(operationClass, "MULTIPLY_SCALAR_1");
                Constructor<?> constructor = modifierClass.getConstructor(String.class, Double.TYPE, operationClass);
                attributeModifier = (AttributeModifier)constructor.newInstance("foo", 0.0, operation);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.attributeModifier = attributeModifier;
        }
    }

    public void editPotionMeta(@NotNull PotionMeta meta, @Nullable PotionType potionType, @Nullable Color color) {
        if (this.minecraftVersion >= 205) {
            meta.setBasePotionType(potionType);
        } else if (this.minecraftVersion >= 202) {
            if (potionType != null) {
                meta.setBasePotionType(potionType);
            }
        } else if (potionType != null) {
            meta.setBasePotionData(new PotionData(potionType));
        }
        meta.setColor(color);
    }

    public Sound getSound(@NotNull String key) {
        if (this.minecraftVersion >= 164) {
            return (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)key));
        }
        try {
            return Sound.valueOf((String)key.replace(".", "_").toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Generated
    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Nullable
    @Generated
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Nullable
    @Generated
    public AttributeModifier getAttributeModifier() {
        return this.attributeModifier;
    }
}

