/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.guimanager;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.guimanager.AbstractButton;
import org.nandayo.dapi.guimanager.Menu;

public class MenuListener
implements Listener {
    @NotNull
    private static final HashMap<UUID, Long> LAST_SHIFT_CLICK = new HashMap();

    @EventHandler
    public void onGUIClick(InventoryClickEvent e) {
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY)) {
            Menu menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value();
            if (menu == null) {
                return;
            }
            Long lastClick = LAST_SHIFT_CLICK.get(p.getUniqueId());
            long now = System.currentTimeMillis();
            if (e.getClick().isShiftClick() && lastClick != null && now - lastClick < 250L) {
                e.setCancelled(true);
                return;
            }
            LAST_SHIFT_CLICK.put(p.getUniqueId(), now);
            boolean clickedOnPlayerInventory = Objects.equals(e.getClickedInventory(), p.getInventory());
            if (clickedOnPlayerInventory) {
                if (!menu.isEmptySlotsModifiable()) {
                    e.setCancelled(true);
                    menu.getOnPlayerInventoryClick().accept(p.getInventory(), e.getSlot());
                }
                return;
            }
            AbstractButton abstractButton = menu.getButton(e.getSlot());
            if (abstractButton == null) {
                e.setCancelled(!menu.isEmptySlotsModifiable());
            } else {
                e.setCancelled(!abstractButton.isModifiable());
                Bukkit.getScheduler().runTask(dapi.plugin, () -> abstractButton.onClick(p, e.getClick()));
            }
        }
    }

    @EventHandler
    public void onGUIDrag(InventoryDragEvent e) {
        Menu menu;
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY) && (menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value()) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onGUIClose(InventoryCloseEvent e) {
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = (Player)e.getPlayer();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY)) {
            Menu menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value();
            if (menu != null) {
                menu.getCloseCallback().accept(menu.getInventory());
            }
            p.removeMetadata(dapi.GUI_METADATA_KEY, dapi.plugin);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        LAST_SHIFT_CLICK.remove(e.getPlayer().getUniqueId());
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY)) {
            Menu menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value();
            if (menu != null) {
                menu.getCloseCallback().accept(menu.getInventory());
            }
            p.removeMetadata(dapi.GUI_METADATA_KEY, dapi.plugin);
        }
    }
}

