/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.model;

import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class Point {
    private final int x;
    private final int y;
    private final int z;

    public Point(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(double x, double y, double z) {
        this((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public Point(@NotNull Location location) {
        this(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Location toLocation(@NotNull World world) {
        return new Location(world, (double)this.x, (double)this.y, (double)this.z, 0.0f, 0.0f);
    }

    public static Point getMinimum(@NotNull Point point1, @NotNull Point point2) {
        int minX = Math.min(point1.getX(), point2.getX());
        int minY = Math.min(point1.getY(), point2.getY());
        int minZ = Math.min(point1.getZ(), point2.getZ());
        return new Point(minX, minY, minZ);
    }

    public static Point getMaximum(@NotNull Point point1, @NotNull Point point2) {
        int maxX = Math.max(point1.getX(), point2.getX());
        int maxY = Math.max(point1.getY(), point2.getY());
        int maxZ = Math.max(point1.getZ(), point2.getZ());
        return new Point(maxX, maxY, maxZ);
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public int getZ() {
        return this.z;
    }
}

