/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.message;

import nesoi.aysihuniks.libs.dapi.message.ChannelBossBarMessage;
import nesoi.aysihuniks.libs.dapi.message.ChannelMessage;
import nesoi.aysihuniks.libs.dapi.message.ChannelTitleMessage;
import nesoi.aysihuniks.libs.dapi.service.AdventureService;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class ChannelType {
    public static final ChannelType CHAT = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            AdventureService.sendMessage(receiver, message);
        }
    };
    public static final ChannelType ACTION_BAR = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            AdventureService.sendActionBar((Player)receiver, message);
        }
    };
    public static final ChannelType TITLE = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message);
            AdventureService.sendTitle((Player)receiver, titleMessage, this);
        }
    };
    public static final ChannelType SUBTITLE = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message);
            AdventureService.sendTitle((Player)receiver, titleMessage, this);
        }
    };
    public static final ChannelType TITLE_AND_SUBTITLE = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message);
            AdventureService.sendTitle((Player)receiver, titleMessage, this);
        }
    };
    public static final ChannelType BOSS_BAR = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelBossBarMessage bossBarMessage = message instanceof ChannelBossBarMessage ? (ChannelBossBarMessage)message : ChannelBossBarMessage.fromParent(message);
            AdventureService.showBossBar((Player)receiver, bossBarMessage);
        }
    };

    private ChannelType() {
    }

    public abstract <T extends ChannelMessage> void send(@NotNull CommandSender var1, @NotNull T var2);

    public final void send(@NotNull CommandSender receiver, @NotNull String message) {
        this.send(receiver, new ChannelMessage(message));
    }

    public final <T extends ChannelMessage> void sendWithPrefix(@NotNull CommandSender receiver, @NotNull T message) {
        this.send(receiver, message.insertPrefix());
    }

    public final void sendWithPrefix(@NotNull CommandSender receiver, @NotNull String message) {
        this.sendWithPrefix(receiver, new ChannelMessage(message));
    }

    public final <T extends ChannelMessage> void sendAll(@NotNull T message, boolean includeConsole) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.send((CommandSender)player, message);
        }
        if (includeConsole) {
            this.send((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    public final void sendAll(@NotNull String message, boolean includeConsole) {
        this.sendAll(new ChannelMessage(message), includeConsole);
    }

    public final <T extends ChannelMessage> void sendAllWithPrefix(@NotNull T message, boolean includeConsole) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendWithPrefix((CommandSender)player, message);
        }
        if (includeConsole) {
            this.sendWithPrefix((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    public final void sendAllWithPrefix(@NotNull String message, boolean includeConsole) {
        this.sendAllWithPrefix(new ChannelMessage(message), includeConsole);
    }
}

