/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class HexUtil {
    private static final String COLOR_REGEX = "(?i)(aqua|black|blue|dark_(aqua|blue|gray|green|purple|red)|gray|gold|green|light_purple|red|white|yellow|#[0-9a-f]{6})";
    private static final Pattern COLORIZE_PATTERN = Pattern.compile("<(#[0-9A-F]{6}|aqua|black|blue|bold|dark_(aqua|blue|gray|green|purple|red)|gray|gold|green|italic|light_purple|obfuscated|red|reset|strikethrough|underline|white|yellow)>|&(?<hex>#[0-9A-F]{6})", 2);
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<(#[0-9A-F]{6})>(.*?)</(#[0-9A-F]{6})>", 2);
    private static final Pattern LEGACY_COLOR_CODE_PATTERN = Pattern.compile("\u00a7([0-9A-FK-OR])", 2);
    private static final Pattern LEGACY_HEX_COLOR_PATTERN = Pattern.compile("\u00a7x(\u00a7[0-9A-F]){6}|&#[0-9A-F]{6}", 2);
    public static Map<String, String> PLACEHOLDERS = new HashMap<String, String>();

    @NotNull
    public static String colorize(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        text = HexUtil.applyGradient(text);
        Matcher matcher = COLORIZE_PATTERN.matcher(text);
        while (matcher.find()) {
            try {
                String original = matcher.group();
                String color = matcher.group(1);
                ChatColor chatColor = ChatColor.of((String)(color = color != null ? color : matcher.group("hex")));
                if (chatColor == null) continue;
                text = text.replace(original, chatColor.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private static String applyGradient(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = GRADIENT_PATTERN.matcher(text);
        while (matcher.find()) {
            String original = matcher.group();
            String start = matcher.group(1);
            String content = matcher.group(2);
            String end = matcher.group(3);
            Color startColor = Color.fromRGB((int)Integer.parseInt(start.substring(1), 16));
            Color endColor = Color.fromRGB((int)Integer.parseInt(end.substring(1), 16));
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < content.length(); ++i) {
                Color color = HexUtil.interpolate(startColor, endColor, (float)i / (float)(content.length() - 1));
                String hex = String.format("%06X", color.asRGB());
                builder.append("<#").append(hex).append(">").append(content.charAt(i));
            }
            text = text.replace(original, builder.toString());
        }
        return text;
    }

    private static Color interpolate(Color start, Color end, float ratio) {
        int red = (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()));
        int green = (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()));
        int blue = (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()));
        return Color.fromRGB((int)red, (int)green, (int)blue);
    }

    @NotNull
    public static String colorToMiniMessage(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        text = HexUtil.applyGradient(text);
        text = HexUtil.legacyHexToMiniMessage(text);
        text = HexUtil.legacyToMiniMessage(text);
        return text;
    }

    @NotNull
    public static String legacyHexToMiniMessage(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = LEGACY_HEX_COLOR_PATTERN.matcher(text);
        while (matcher.find()) {
            String original = matcher.group();
            String hex = original.replace("\u00a7", "").replace("&", "").substring(1);
            text = text.replace(original, "<#" + hex + ">");
        }
        return text;
    }

    @NotNull
    public static String legacyToMiniMessage(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = LEGACY_COLOR_CODE_PATTERN.matcher(text);
        while (matcher.find()) {
            String original = matcher.group();
            char code = matcher.group(1).charAt(0);
            ChatColor chatColor = ChatColor.getByChar((char)code);
            if (chatColor == null) continue;
            String name = chatColor.getName().equals("underline") ? "underlined" : chatColor.getName();
            String replacement = "<" + name + ">";
            if (name.matches(COLOR_REGEX)) {
                replacement = "<reset>" + replacement;
            }
            text = text.replace(original, replacement);
        }
        return text;
    }

    public static String parse(String text) {
        return HexUtil.colorize(HexUtil.replacePlaceholders(text));
    }

    public static String replacePlaceholders(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, String> entry : PLACEHOLDERS.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        return text;
    }
}

