/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.util;

import nesoi.aysihuniks.libs.dapi.util.DAPIException;
import nesoi.aysihuniks.libs.dapi.util.ThrowingSupplier;
import org.jetbrains.annotations.NotNull;

public class Validate {
    public static void validate(boolean b, @NotNull String errorMessage) {
        if (!b) {
            throw new DAPIException(errorMessage);
        }
    }

    public static void validate(@NotNull ThrowingSupplier<Boolean> supplier, @NotNull String errorMessage, boolean log) {
        try {
            if (!supplier.get().booleanValue()) {
                throw new DAPIException((String)errorMessage);
            }
        }
        catch (Exception e) {
            if (log) {
                errorMessage = (String)errorMessage + String.valueOf(e);
            }
            throw new DAPIException((String)errorMessage);
        }
    }

    public static void validate(@NotNull ThrowingSupplier<Boolean> supplier, @NotNull String errorMessage) {
        Validate.validate(supplier, errorMessage, false);
    }

    @NotNull
    public static <T> T validateReturn(@NotNull ThrowingSupplier<T> supplier, @NotNull String errorMessage, boolean log) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            if (log) {
                errorMessage = (String)errorMessage + String.valueOf(e);
            }
            throw new DAPIException((String)errorMessage);
        }
    }

    @NotNull
    public static <T> T validateReturn(@NotNull ThrowingSupplier<T> supplier, @NotNull String errorMessage) {
        return Validate.validateReturn(supplier, errorMessage, false);
    }

    @NotNull
    public static <T> T notNull(T object, @NotNull String errorMessage) {
        if (object == null) {
            throw new DAPIException(errorMessage);
        }
        return object;
    }
}

