/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ClaimVisualizerService {
    private final NClaim plugin;
    private final Map<UUID, BukkitTask> activeVisualizations = new HashMap<UUID, BukkitTask>();
    private final Set<UUID> playersInPreviewMode = new HashSet<UUID>();

    public void showClaimBorders(Player player, Chunk chunk) {
        this.cancelVisualization(player);
        this.playersInPreviewMode.add(player.getUniqueId());
        AtomicInteger counter = new AtomicInteger(0);
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!player.isOnline() || !player.getWorld().equals((Object)chunk.getWorld()) || counter.get() >= 10) {
                this.cancelVisualization(player);
                return;
            }
            this.visualizeChunkBorders(player, chunk);
            counter.incrementAndGet();
        }, 0L, 20L);
        this.activeVisualizations.put(player.getUniqueId(), task);
    }

    public void showClaimBorders(Player player) {
        this.cancelVisualization(player);
        this.playersInPreviewMode.add(player.getUniqueId());
        AtomicInteger counter = new AtomicInteger(0);
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!player.isOnline() || counter.get() >= 10) {
                this.cancelVisualization(player);
                return;
            }
            Chunk currentChunk = player.getLocation().getChunk();
            this.visualizeChunkBorders(player, currentChunk);
            counter.incrementAndGet();
        }, 0L, 20L);
        this.activeVisualizations.put(player.getUniqueId(), task);
    }

    public void cancelVisualization(Player player) {
        BukkitTask task = this.activeVisualizations.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
        this.playersInPreviewMode.remove(player.getUniqueId());
    }

    private void visualizeChunkBorders(Player player, Chunk chunk) {
        World world = chunk.getWorld();
        int chunkX = chunk.getX() * 16;
        int chunkZ = chunk.getZ() * 16;
        double playerY = player.getLocation().getY();
        int maxHeight = 32;
        int stepHeight = 4;
        ArrayList<Location> corners = new ArrayList<Location>();
        corners.add(new Location(world, (double)chunkX, playerY, (double)chunkZ));
        corners.add(new Location(world, (double)(chunkX + 15), playerY, (double)chunkZ));
        corners.add(new Location(world, (double)(chunkX + 15), playerY, (double)(chunkZ + 15)));
        corners.add(new Location(world, (double)chunkX, playerY, (double)(chunkZ + 15)));
        for (int i = 0; i < corners.size(); ++i) {
            Location start = (Location)corners.get(i);
            Location end = (Location)corners.get((i + 1) % corners.size());
            double distance = start.distance(end);
            Vector direction = end.toVector().subtract(start.toVector()).normalize();
            for (double d = 0.0; d <= distance; d += 0.5) {
                Location particleLoc = start.clone().add(direction.clone().multiply(d));
                player.spawnParticle(Particle.END_ROD, particleLoc, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        for (Location corner : corners) {
            Location pillarLoc;
            double y;
            for (y = playerY; y < playerY + (double)maxHeight; y += 0.5) {
                pillarLoc = corner.clone();
                pillarLoc.setY(y);
                player.spawnParticle(Particle.END_ROD, pillarLoc, 0, 0.0, 0.0, 0.0, 0.0);
            }
            for (y = playerY; y > playerY - (double)maxHeight; y -= 0.5) {
                pillarLoc = corner.clone();
                pillarLoc.setY(y);
                player.spawnParticle(Particle.END_ROD, pillarLoc, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        for (double y = playerY + (double)stepHeight; y < playerY + (double)maxHeight; y += (double)stepHeight) {
            for (int i = 0; i < corners.size(); ++i) {
                Location start = ((Location)corners.get(i)).clone().add(0.0, y - playerY, 0.0);
                Location end = ((Location)corners.get((i + 1) % corners.size())).clone().add(0.0, y - playerY, 0.0);
                double distance = start.distance(end);
                Vector direction = end.toVector().subtract(start.toVector()).normalize();
                for (double d = 0.0; d <= distance; d += 0.5) {
                    Location particleLoc = start.clone().add(direction.clone().multiply(d));
                    player.spawnParticle(Particle.END_ROD, particleLoc, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Generated
    public ClaimVisualizerService(NClaim plugin) {
        this.plugin = plugin;
    }
}

