/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandExpansionMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    @NotNull
    private final Collection<Chunk> allClaimChunks;
    private final boolean admin;

    public LandExpansionMenu(@NotNull Player player, @NotNull Claim claim, boolean admin) {
        super("claim_expand_menu");
        this.claim = claim;
        this.allClaimChunks = claim.getAllChunks();
        this.admin = admin;
        this.setupMenu();
        this.displayTo(player);
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_5_ROWS, this.getString("title"));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{22});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(LandExpansionMenu.this.claim.getClaimBlockType()).name(LandExpansionMenu.this.getString("center.display_name")).lore(LandExpansionMenu.this.getStringList("center.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                new ClaimManagementMenu(player, LandExpansionMenu.this.claim, LandExpansionMenu.this.admin);
            }
        });
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slot = row * 9 + col;
                if (slot == 22 || slot == 0 || slot == 9 || slot == 18 || slot == 27 || slot == 36 || slot == 8 || slot == 17 || slot == 26 || slot == 35 || slot == 44) continue;
                this.addDirtButton(slot);
            }
        }
    }

    private void addDirtButton(int slot) {
        ItemStack material;
        String configPath;
        Chunk thatChunk = this.calculateNewChunk(slot);
        Claim thatClaim = Claim.getClaim(thatChunk);
        boolean clickable = false;
        if (this.admin) {
            if (thatClaim == null) {
                configPath = "expand";
                material = this.getMaterial("expand");
            } else {
                configPath = "claimed";
                material = this.getMaterial("claimed");
            }
            clickable = true;
        } else if (!this.isAdjacentToClaim(thatChunk)) {
            configPath = "not_adjacent";
            material = this.getMaterial("not_adjacent");
        } else if (thatClaim == null) {
            configPath = "expand";
            material = this.getMaterial("expand");
            clickable = true;
        } else if (this.claim.getLands().contains(NClaim.serializeChunk(thatChunk))) {
            configPath = "claimed";
            material = this.getMaterial("claimed");
            clickable = true;
        } else {
            configPath = "claimed_another_player";
            material = this.getMaterial("claimed_another_player");
        }
        this.addButton(this.createButton(slot, configPath, material, thatChunk, clickable));
    }

    private Button createButton(final int slot, final String configPath, final ItemStack material, final Chunk thatChunk, final boolean clickable) {
        return new Button(this){
            final /* synthetic */ LandExpansionMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{slot});
            }

            @Override
            public ItemStack getItem() {
                double landPrice = this.this$0.calculateChunkPrice(thatChunk);
                String displayName = this.this$0.getString(configPath + ".display_name");
                ArrayList<String> lore = new ArrayList<String>(this.this$0.getStringList(configPath + ".lore"));
                if (configPath.equals("expand")) {
                    lore.replaceAll(s -> s.replace("{price}", String.valueOf(landPrice)));
                }
                return ItemCreator.of(material).name(displayName).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!clickable) {
                    return;
                }
                if (clickType.isLeftClick() && this.this$0.getInvItem(slot).getType() == Material.BROWN_WOOL) {
                    Consumer<String> onFinish = result -> {
                        if ("confirmed".equals(result)) {
                            NClaim.inst().getClaimService().buyLand(this.this$0.claim, player, thatChunk);
                            new LandExpansionMenu(player, this.this$0.claim, this.this$0.admin);
                        } else if ("declined".equals(result)) {
                            new LandExpansionMenu(player, this.this$0.claim, this.this$0.admin);
                        }
                    };
                    new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.claim_expand.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.claim_expand.lore").stream().map(s -> s.replace("{price}", String.valueOf(this.this$0.calculateChunkPrice(thatChunk)))).collect(Collectors.toList()), onFinish);
                } else if (clickType.isRightClick() && this.this$0.getInvItem(slot).getType() == Material.LIME_WOOL || clickType.isRightClick() && this.this$0.getInvItem(slot).getType() == Material.BROWN_WOOL) {
                    player.closeInventory();
                    NClaim.inst().getClaimVisualizerService().showClaimBorders(player, thatChunk);
                }
            }
        };
    }

    private double calculateChunkPrice(Chunk targetChunk) {
        int currentChunkCount = 1 + this.claim.getLands().size();
        int nextChunkNumber = currentChunkCount + 1;
        return NClaim.inst().getNconfig().getTieredPrice(nextChunkNumber);
    }

    private boolean isAdjacentToClaim(@NotNull Chunk thatChunk) {
        return this.allClaimChunks.stream().anyMatch(c -> c != null && NClaim.isChunkAdjacent(c, thatChunk, 2));
    }

    private Chunk calculateNewChunk(int slot) {
        int chunkX = this.claim.getChunk().getX();
        int chunkZ = this.claim.getChunk().getZ();
        int centerRow = 2;
        int centerCol = 4;
        int row = slot / 9;
        int col = slot % 9;
        int deltaX = col - centerCol;
        int deltaZ = row - centerRow;
        return this.claim.getChunk().getWorld().getChunkAt(chunkX += deltaX, chunkZ += deltaZ);
    }
}

