/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimCalculateLevelEvent;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimLevel;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.message.ChannelType;

public class ClaimLevelManager {
    private final NClaim plugin;
    private final Map<Material, ClaimLevel> blockValues = new HashMap<Material, ClaimLevel>();
    private final List<ClaimCalculationRequest> calculationQueue = new ArrayList<ClaimCalculationRequest>();
    private boolean isProcessing = false;
    private String currentlyCalculating = null;
    private File configFile;
    private FileConfiguration config;

    public void loadBlockValues() {
        this.configFile = new File(this.plugin.getDataFolder(), "block_levels.yml");
        if (!this.configFile.exists()) {
            Util.log("&eblock_levels.yml does not exist, creating default...");
            this.plugin.saveResource("block_levels.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.blockValues.clear();
        ConfigurationSection blocksSection = this.config.getConfigurationSection("blocks");
        if (blocksSection == null) {
            Util.log("&cNo 'blocks' section found in block_levels.yml!");
            return;
        }
        int loadedCount = 0;
        for (String key : blocksSection.getKeys(false)) {
            try {
                Material material = Material.valueOf((String)key.toUpperCase());
                int value = blocksSection.getInt(key, 0);
                if (value <= 0) continue;
                this.blockValues.put(material, new ClaimLevel(material, value));
                ++loadedCount;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Util.log("&aLoaded " + loadedCount + " block values.");
    }

    public void saveBlockValues() {
        if (this.config == null) {
            return;
        }
        this.config.set("blocks", null);
        ConfigurationSection blocksSection = this.config.createSection("blocks");
        int savedCount = 0;
        for (Map.Entry<Material, ClaimLevel> entry : this.blockValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            blocksSection.set(entry.getKey().name().toLowerCase(), (Object)entry.getValue().getValue());
            ++savedCount;
        }
        try {
            this.config.save(this.configFile);
            Util.log("&aSaved " + savedCount + " block values to block_levels.yml.");
        }
        catch (IOException e) {
            Util.log("&cCould not save block_levels.yml: " + e.getMessage());
        }
    }

    public void reloadBlockValues() {
        this.saveBlockValues();
        this.loadBlockValues();
    }

    public int getBlockValue(Material material) {
        if (material == null) {
            return 0;
        }
        ClaimLevel blockValue = this.blockValues.get(material);
        return blockValue != null ? blockValue.getValue() : 0;
    }

    public void setBlockValue(Material material, int value) {
        if (material == null || value <= 0) {
            return;
        }
        this.blockValues.put(material, new ClaimLevel(material, value));
        this.saveBlockValues();
    }

    public boolean isValidBlock(Material material) {
        return material != null && this.blockValues.containsKey(material);
    }

    public void removeBlockValue(Material material) {
        if (material != null && this.blockValues.containsKey(material)) {
            this.blockValues.remove(material);
            this.saveBlockValues();
        }
    }

    public long calculateClaimValue(Claim claim) {
        if (claim == null) {
            return 0L;
        }
        long oldValue = claim.getClaimValue();
        long totalValue = 0L;
        Chunk mainChunk = claim.getChunk();
        totalValue += this.calculateChunkValue(mainChunk);
        for (String landStr : claim.getLands()) {
            String[] parts = landStr.split(",");
            if (parts.length != 3) continue;
            try {
                World world = Bukkit.getWorld((String)parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                if (world == null) continue;
                Chunk landChunk = world.getChunkAt(x, z);
                totalValue += this.calculateChunkValue(landChunk);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ClaimCalculateLevelEvent event = new ClaimCalculateLevelEvent(claim, oldValue, totalValue);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event.getOldLevel();
        }
        return event.getNewLevel();
    }

    public void requestClaimCalculation(UUID playerId, String playerName, Claim claim) {
        boolean alreadyInQueue = this.calculationQueue.stream().anyMatch(req -> req.getPlayerId().equals(playerId));
        if (alreadyInQueue) {
            this.sendMessageToPlayer(playerId, NClaim.inst().getLangManager().getString("claim.level.your_already_in_queue"));
            return;
        }
        ClaimCalculationRequest request = new ClaimCalculationRequest(playerId, playerName, claim);
        this.calculationQueue.add(request);
        int position = this.calculationQueue.size();
        this.sendMessageToPlayer(playerId, NClaim.inst().getLangManager().getString("claim.level.calculating_in_queue_position").replace("{position}", String.valueOf(position)));
        if (!this.isProcessing) {
            this.processNextCalculation();
        }
    }

    private void processNextCalculation() {
        if (this.calculationQueue.isEmpty()) {
            this.isProcessing = false;
            this.currentlyCalculating = null;
            return;
        }
        this.isProcessing = true;
        ClaimCalculationRequest request = this.calculationQueue.remove(0);
        this.currentlyCalculating = request.getPlayerName();
        this.sendMessageToPlayer(request.getPlayerId(), NClaim.inst().getLangManager().getString("claim.level.calculating_started"));
        long startTime = System.currentTimeMillis();
        long claimValue = this.calculateClaimValue(request.getClaim());
        long duration = System.currentTimeMillis() - startTime;
        String message = NClaim.inst().getLangManager().getString("command.level.info").replace("{value}", String.format("%,d", claimValue)).replace("{chunks}", String.valueOf(request.getClaim().getLands().size() + 1)).replace("{time}", duration + "ms");
        this.sendMessageToPlayer(request.getPlayerId(), message);
        this.isProcessing = false;
        this.processNextCalculation();
    }

    private void sendMessageToPlayer(UUID playerId, String message) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null && player.isOnline()) {
            ChannelType.CHAT.send((CommandSender)player, message);
        }
    }

    public void checkQueueStatus(UUID playerId) {
        if (this.currentlyCalculating != null) {
            this.sendMessageToPlayer(playerId, NClaim.inst().getLangManager().getString("claim.level.calculating_in_progress"));
        }
        if (!this.calculationQueue.isEmpty()) {
            this.sendMessageToPlayer(playerId, NClaim.inst().getLangManager().getString("claim.level.calculating_in_queue").replace("{count}", String.valueOf(this.calculationQueue.size())));
            for (int i = 0; i < this.calculationQueue.size(); ++i) {
                if (!this.calculationQueue.get(i).getPlayerId().equals(playerId)) continue;
                this.sendMessageToPlayer(playerId, NClaim.inst().getLangManager().getString("claim.level.calculating_in_queue_position").replace("{position}", String.valueOf(i + 1)));
                break;
            }
        } else {
            this.sendMessageToPlayer(playerId, NClaim.inst().getLangManager().getString("claim.level.queue_is_empty"));
        }
    }

    public long calculateChunkValue(Chunk chunk) {
        if (chunk == null) {
            return 0L;
        }
        return this.performChunkCalculation(chunk);
    }

    private long performChunkCalculation(Chunk chunk) {
        if (chunk == null) {
            return 0L;
        }
        long chunkValue = 0L;
        World world = chunk.getWorld();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = chunk.getX() * 16 + x;
                int worldZ = chunk.getZ() * 16 + z;
                int highestY = world.getHighestBlockYAt(worldX, worldZ);
                int SURFACE_DEPTH = 15;
                for (int y = Math.max(world.getMinHeight(), highestY - SURFACE_DEPTH); y <= highestY; ++y) {
                    int blockValue;
                    Material blockType = chunk.getBlock(x, y, z).getType();
                    if (!this.isValidMaterial(blockType) || (blockValue = this.getBlockValue(blockType)) <= 0) continue;
                    chunkValue += (long)blockValue;
                }
                int UNDERGROUND_SKIP = 2;
                for (int y = world.getMinHeight(); y < Math.max(world.getMinHeight(), highestY - SURFACE_DEPTH); y += UNDERGROUND_SKIP) {
                    Material blockType = chunk.getBlock(x, y, z).getType();
                    int blockValue = this.getBlockValue(blockType);
                    if (blockValue <= 10) continue;
                    chunkValue += (long)blockValue;
                }
            }
        }
        return chunkValue;
    }

    private boolean isValidMaterial(Material material) {
        return material != null && material != Material.AIR && material != Material.CAVE_AIR && material != Material.VOID_AIR;
    }

    private String getChunkCacheKey(Chunk chunk) {
        return chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ();
    }

    @Generated
    public ClaimLevelManager(NClaim plugin) {
        this.plugin = plugin;
    }

    @Generated
    public Map<Material, ClaimLevel> getBlockValues() {
        return this.blockValues;
    }

    private static class ClaimCalculationRequest {
        private final UUID playerId;
        private final String playerName;
        private final Claim claim;

        public ClaimCalculationRequest(UUID playerId, String playerName, Claim claim) {
            this.playerId = playerId;
            this.playerName = playerName;
            this.claim = claim;
        }

        @Generated
        public UUID getPlayerId() {
            return this.playerId;
        }

        @Generated
        public String getPlayerName() {
            return this.playerName;
        }

        @Generated
        public Claim getClaim() {
            return this.claim;
        }
    }
}

