/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.utils;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import nesoi.aysihuniks.nclaim.NClaim;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private YamlConfiguration config;

    public ConfigManager(FileConfiguration config) {
        this.config = YamlConfiguration.loadConfiguration((Reader)new StringReader(config.saveToString()));
    }

    public void set(String key, Object value) {
        this.config.set(key, value);
    }

    public Object get(String key, Object defaultValue) {
        return this.config.get(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.config.getDouble(key, defaultValue.doubleValue());
    }

    public String getString(String key, String defaultValue) {
        Object value = this.config.get(key);
        return value != null ? value.toString() : defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        return this.config.getInt(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.config.getLong(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.config.getBoolean(key, defaultValue);
    }

    public ConfigurationSection getConfigurationSection(String key) {
        return this.config.getConfigurationSection(key);
    }

    public List<String> getStringList(String key) {
        return this.config.getStringList(key);
    }

    public void saveConfig() {
        try {
            this.config.save(new File(NClaim.inst().getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

