/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.Util;

public abstract class YAMLRegistry {
    @NotNull
    private final JavaPlugin plugin;
    private File file;
    @NotNull
    private static final List<YAMLRegistry> REGISTRIES = new ArrayList<YAMLRegistry>();

    protected YAMLRegistry(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadFile();
        REGISTRIES.add(this);
    }

    @NotNull
    protected abstract String filePath();

    protected void loadFile() {
        String path = this.filePath();
        File file = new File(this.plugin.getDataFolder(), path);
        if (!file.exists()) {
            file.mkdirs();
            this.saveDefaultResource(path);
        }
        this.file = file;
    }

    private InputStream getDefaultResource(@NotNull String path) {
        return this.plugin.getResource(path);
    }

    private void saveDefaultResource(@NotNull String path) {
        if (this.getDefaultResource(path) != null) {
            this.plugin.saveResource(path, false);
        }
    }

    @NotNull
    protected FileConfiguration getConfiguration() {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(this.file);
        }
        catch (Exception e) {
            Util.log(String.format("Couldn't load YAML configuration '%s'!", this.file.getName()));
        }
        return config;
    }

    abstract void onLoad();

    abstract void onUnload();

    public static List<YAMLRegistry> getRegistries() {
        return ImmutableList.copyOf(REGISTRIES);
    }

    public static void loadRegistries() {
        for (YAMLRegistry registry : REGISTRIES) {
            registry.onLoad();
        }
    }

    public static void unloadRegistries() {
        for (YAMLRegistry registry : REGISTRIES) {
            registry.onUnload();
        }
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

