/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.admin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminAllClaimMenu;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminTimeManagementMenu;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopListMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.LandExpansionMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class AdminClaimManagementMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;

    public AdminClaimManagementMenu(@NotNull Player player, @NotNull Claim claim) {
        super("admin_menu.claim_management_menu");
        this.claim = claim;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        String ownerName = Bukkit.getOfflinePlayer((UUID)this.claim.getOwner()).getName() != null ? Bukkit.getOfflinePlayer((UUID)this.claim.getOwner()).getName() : "Unknown";
        this.createInventory(MenuType.CHEST_3_ROWS, this.getString("title").replace("{owner}", ownerName));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.OAK_DOOR).name(NClaim.inst().getGuiLangManager().getString("back.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                new AdminAllClaimMenu(player, null, true, 0, new ArrayList<Claim>());
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BEEHIVE).name(AdminClaimManagementMenu.this.getString("manage_coop.display_name")).lore(AdminClaimManagementMenu.this.getStringList("manage_coop.lore")).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new CoopListMenu(player, AdminClaimManagementMenu.this.claim, true);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BRICKS).name(AdminClaimManagementMenu.this.getString("manage_lands.display_name")).lore(AdminClaimManagementMenu.this.getStringList("manage_lands.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new LandExpansionMenu(player, AdminClaimManagementMenu.this.claim, true);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(AdminClaimManagementMenu.this.getString("manage_expiration.display_name")).lore(AdminClaimManagementMenu.this.getStringList("manage_expiration.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new AdminTimeManagementMenu(player, 0, 0, 0, 0, AdminClaimManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{15});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.TNT).name(NClaim.inst().getGuiLangManager().getString("claim_management_menu.delete.display_name")).lore(NClaim.inst().getGuiLangManager().getStringList("claim_management_menu.delete.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                Consumer<String> onFinish = result -> {
                    if ("confirmed".equals(result)) {
                        AdminClaimManagementMenu.this.claim.remove(RemoveCause.REMOVED_BY_ADMIN);
                        new AdminAllClaimMenu(player, null, true, 0, new ArrayList<Claim>());
                    } else if ("declined".equals(result)) {
                        new AdminClaimManagementMenu(player, AdminClaimManagementMenu.this.claim);
                    }
                };
                new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.delete_claim.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.delete_claim.lore"), onFinish);
            }
        });
    }
}

