/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.Claim;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.nandayo.dapi.HexUtil;

public class ClaimExpirationManager {
    private final NClaim plugin;
    private BukkitTask expirationTask;

    public void startExpirationChecker() {
        long checkInterval = 6000L;
        this.expirationTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkExpiredClaims, checkInterval, checkInterval);
    }

    public void stopExpirationChecker() {
        if (this.expirationTask != null) {
            this.expirationTask.cancel();
            this.expirationTask = null;
        }
    }

    public void checkExpiredClaims() {
        Date currentDate = new Date();
        for (Claim claim : new ArrayList<Claim>(Claim.claims)) {
            if (!claim.getExpiredAt().before(currentDate)) continue;
            if (this.plugin.getNconfig().isDatabaseEnabled()) {
                this.plugin.getDatabaseManager().deleteClaim(claim.getClaimId());
            }
            claim.remove(RemoveCause.REMOVED);
        }
    }

    public void extendClaimExpiration(Claim claim, int days, int hours, int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(claim.getExpiredAt());
        calendar.add(5, days);
        calendar.add(11, hours);
        calendar.add(12, minutes);
        claim.setExpiredAt(calendar.getTime());
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getDatabaseManager().saveClaim(claim);
        }
    }

    public String getFormattedTimeLeft(Claim claim) {
        long diffInMillis = claim.getExpiredAt().getTime() - new Date().getTime();
        long diffDays = TimeUnit.DAYS.convert(diffInMillis, TimeUnit.MILLISECONDS);
        long diffHours = TimeUnit.HOURS.convert(diffInMillis, TimeUnit.MILLISECONDS) % 24L;
        long diffMinutes = TimeUnit.MINUTES.convert(diffInMillis, TimeUnit.MILLISECONDS) % 60L;
        long diffSeconds = TimeUnit.SECONDS.convert(diffInMillis, TimeUnit.MILLISECONDS) % 60L;
        String daySymbol = this.plugin.getLangManager().getString("hologram.time_left.d");
        String hourSymbol = this.plugin.getLangManager().getString("hologram.time_left.h");
        String minuteSymbol = this.plugin.getLangManager().getString("hologram.time_left.m");
        String secondSymbol = this.plugin.getLangManager().getString("hologram.time_left.s");
        String timeLeft = diffDays > 0L ? String.format("%d%s, %d%s", diffDays, daySymbol, diffHours, hourSymbol) : (diffHours > 0L ? String.format("%d%s, %d%s", diffHours, hourSymbol, diffMinutes, minuteSymbol) : (diffMinutes > 0L ? String.format("%d%s, %d%s", diffMinutes, minuteSymbol, diffSeconds, secondSymbol) : String.format("%d%s", diffSeconds, secondSymbol)));
        String color = diffDays >= 2L ? "{GREEN}" : (diffDays >= 1L ? "{YELLOW}" : "{RED}");
        return HexUtil.parse(color + timeLeft);
    }

    public boolean isExpired(Claim claim) {
        return claim.getExpiredAt().before(new Date());
    }

    public boolean isExpiringSoon(Claim claim, int warningHours) {
        long diffInMillis = claim.getExpiredAt().getTime() - new Date().getTime();
        long diffHours = TimeUnit.HOURS.convert(diffInMillis, TimeUnit.MILLISECONDS);
        return diffHours <= (long)warningHours;
    }

    @Generated
    public ClaimExpirationManager(NClaim plugin) {
        this.plugin = plugin;
    }
}

