/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.SettingData;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class ClaimSettingsMenu
extends BaseMenu {
    private final Claim claim;
    private final int page;
    private static final int[] settingSlots = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final List<SettingData> settings = Arrays.asList(new SettingData(Setting.CLAIM_PVP, "pvp", Material.DIAMOND_SWORD), new SettingData(Setting.TNT_DAMAGE, "tnt_explosions", Material.TNT), new SettingData(Setting.CREEPER_DAMAGE, "creeper_explosions", Material.CREEPER_SPAWN_EGG), new SettingData(Setting.MOB_ATTACKING, "mob_attacks", Material.GOLDEN_APPLE), new SettingData(Setting.MONSTER_SPAWNING, "monster_spawning", Material.ZOMBIE_SPAWN_EGG), new SettingData(Setting.ANIMAL_SPAWNING, "animal_spawning", Material.COW_SPAWN_EGG), new SettingData(Setting.VILLAGER_INTERACTION, "villager_interactions", Material.VILLAGER_SPAWN_EGG));

    public ClaimSettingsMenu(Player player, Claim claim, int page) {
        super("claim_settings_menu");
        this.claim = claim;
        this.page = page;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addNavigationButton();
        this.addSettingButtons();
        if (this.hasNextPage()) {
            this.addNextPageButton();
        }
    }

    private void addNavigationButton() {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = ClaimSettingsMenu.this.page == 0 ? "back" : "previous_page";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimSettingsMenu.this.page == 0 ? Material.OAK_DOOR : Material.FEATHER).name(NClaim.inst().getGuiLangManager().getString(this.buttonPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (ClaimSettingsMenu.this.page == 0) {
                    new ClaimManagementMenu(player, ClaimSettingsMenu.this.claim);
                } else {
                    new ClaimSettingsMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.page - 1);
                }
            }
        });
    }

    private void addNextPageButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name(NClaim.inst().getGuiLangManager().getString("next_page.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new ClaimSettingsMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.page + 1);
            }
        });
    }

    private void addSettingButtons() {
        int startIndex = this.page * settingSlots.length;
        int endIndex = Math.min(startIndex + settingSlots.length, this.settings.size());
        int i = startIndex;
        int slotIndex = 0;
        while (i < endIndex) {
            SettingData settingData = this.settings.get(i);
            this.addSettingButton(settingData, slotIndex);
            ++i;
            ++slotIndex;
        }
    }

    private void addSettingButton(final SettingData settingData, final int slotIndex) {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = "settings." + settingData.getConfigKey();
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{settingSlots[slotIndex]});
            }

            @Override
            public ItemStack getItem() {
                boolean isEnabled = ClaimSettingsMenu.this.claim.getSettings().isEnabled(settingData.getSetting());
                String status = ClaimSettingsMenu.this.guiLangManager.getString((isEnabled ? "enabled" : "disabled") + ".display_name");
                List lore = ClaimSettingsMenu.this.getStringList(this.buttonPath + ".lore");
                lore.replaceAll(l -> l.replace("{status}", status));
                return ItemCreator.of(settingData.getMaterial()).name(ClaimSettingsMenu.this.getString(this.buttonPath + ".display_name")).lore(lore).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.CONFIRM.playSound(player);
                NClaim.inst().getClaimSettingsManager().toggleSetting(ClaimSettingsMenu.this.claim, player, settingData.getSetting());
                new ClaimSettingsMenu(player, ClaimSettingsMenu.this.claim, ClaimSettingsMenu.this.page);
            }
        });
    }

    private boolean hasNextPage() {
        return (this.page + 1) * settingSlots.length < this.settings.size();
    }
}

