/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimBuyLandEvent;
import nesoi.aysihuniks.nclaim.api.events.ClaimCreateEvent;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.model.User;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.message.ChannelType;

public class ClaimService {
    private final NClaim plugin;

    public void buyNewClaim(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        User user = User.getUser(player.getUniqueId());
        if (!this.canCreateClaim(player, user, chunk)) {
            return;
        }
        if (!this.handleClaimPayment(player, user)) {
            return;
        }
        this.createNewClaim(player, chunk);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getDatabaseManager().saveClaim(Claim.getClaim(chunk));
            this.plugin.getDatabaseManager().saveUser(user);
        }
    }

    public void buyLand(@NotNull Claim claim, Player player, @NotNull Chunk chunk) {
        if (claim.getChunk().equals((Object)chunk)) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.land.already_own_chunk"));
            return;
        }
        String chunkKey = chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
        if (claim.getLands().contains(chunkKey)) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.land.already_own_land"));
            return;
        }
        if (!this.isAdjacentChunk(claim, chunk)) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.land.not_adjacent"));
            return;
        }
        if (Claim.getClaim(chunk) != null) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.already_claimed"));
            return;
        }
        if (!this.canCreateClaimOrExpandNearOtherClaims(player, chunk)) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.too_close_to_other_claim"));
            return;
        }
        User user = User.getUser(player.getUniqueId());
        double landPrice = this.plugin.getNconfig().eachLandBuyPrice;
        ClaimBuyLandEvent buyLandEvent = new ClaimBuyLandEvent(player, claim, chunk);
        Bukkit.getPluginManager().callEvent((Event)buyLandEvent);
        if (buyLandEvent.isCancelled()) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.land.buy_cancelled"));
            return;
        }
        if (!(player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.land_buy_price") || this.handlePayment(player, user, landPrice))) {
            return;
        }
        claim.getLands().add(chunkKey);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getDatabaseManager().saveClaim(claim);
            this.plugin.getDatabaseManager().saveUser(user);
        }
        ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.land.expanded"));
    }

    private boolean isAdjacentChunk(Claim claim, Chunk targetChunk) {
        int targetZ;
        int targetX;
        int claimZ;
        int claimX = claim.getChunk().getX();
        if (this.isAdjacent(claimX, claimZ = claim.getChunk().getZ(), targetX = targetChunk.getX(), targetZ = targetChunk.getZ())) {
            return true;
        }
        for (String landKey : claim.getLands()) {
            int landZ;
            int landX;
            String[] coords = landKey.split(",");
            if (coords.length < 3 || !this.isAdjacent(landX = Integer.parseInt(coords[1]), landZ = Integer.parseInt(coords[2]), targetX, targetZ)) continue;
            return true;
        }
        return false;
    }

    private boolean isAdjacent(int x1, int z1, int x2, int z2) {
        return Math.abs(x1 - x2) == 1 && z1 == z2 || x1 == x2 && Math.abs(z1 - z2) == 1;
    }

    private boolean canCreateClaim(Player player, User user, Chunk chunk) {
        if (NClaim.inst().getNconfig().getBlacklistedWorlds().contains(chunk.getWorld().getName()) && !player.hasPermission("nclaim.bypass.*") && !player.hasPermission("nclaim.bypass.blacklisted_worlds")) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.in_blacklisted_region_or_world"));
            return false;
        }
        if (this.isInBlacklistedRegion(player.getLocation()) && !player.hasPermission("nclaim.bypass.*") && !player.hasPermission("nclaim.bypass.blacklisted_regions")) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.in_blacklisted_region_or_world"));
            return false;
        }
        if (Claim.getClaim(chunk) != null) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.already_claimed"));
            return false;
        }
        if (!player.hasPermission("nclaim.buy")) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("command.permission_denied"));
            return false;
        }
        if (user.getPlayerClaims().size() >= this.plugin.getNconfig().getMaxClaimCount(player)) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.max_reached"));
            return false;
        }
        if (!this.canCreateClaimOrExpandNearOtherClaims(player, chunk)) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.too_close_to_other_claim"));
            return false;
        }
        return true;
    }

    private boolean canCreateClaimOrExpandNearOtherClaims(Player player, Chunk chunk) {
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        for (int x = chunkX - 1; x <= chunkX + 1; ++x) {
            for (int z = chunkZ - 1; z <= chunkZ + 1; ++z) {
                Chunk nearbyChunk;
                Claim nearbyClaim;
                if (x == chunkX && z == chunkZ || (nearbyClaim = Claim.getClaim(nearbyChunk = chunk.getWorld().getChunkAt(x, z))) == null || nearbyClaim.getOwner().equals(player.getUniqueId())) continue;
                ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.too_close_to_other_claim"));
                return false;
            }
        }
        return true;
    }

    private boolean handleClaimPayment(Player player, User user) {
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.claim_buy_price")) {
            return true;
        }
        double claimPrice = this.plugin.getNconfig().getClaimBuyPrice();
        return this.handlePayment(player, user, claimPrice);
    }

    private void createNewClaim(Player player, Chunk chunk) {
        String claimId = this.generateClaimId(chunk);
        Date createdAt = new Date();
        Date expiredAt = this.calculateExpirationDate();
        Location claimBlockLocation = player.getLocation().getBlock().getLocation();
        Material defaultBlockType = Material.OBSIDIAN;
        claimBlockLocation.getBlock().setType(defaultBlockType);
        long initialValue = this.plugin.getBlockValueManager().calculateChunkValue(chunk);
        HashSet<Material> purchasedBlockTypes = new HashSet<Material>();
        purchasedBlockTypes.add(defaultBlockType);
        Claim claim = new Claim(claimId, chunk, createdAt, expiredAt, player.getUniqueId(), claimBlockLocation, initialValue, defaultBlockType, new ArrayList<String>(), new ArrayList<UUID>(), new HashMap<UUID, Date>(), new HashMap<UUID, CoopPermission>(), new ClaimSetting(), purchasedBlockTypes);
        ClaimCreateEvent createEvent = new ClaimCreateEvent(player, claim);
        Bukkit.getPluginManager().callEvent((Event)createEvent);
        if (createEvent.isCancelled()) {
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.buy_cancelled"));
            return;
        }
        this.plugin.getHologramManager().createHologram(claimBlockLocation);
        User.getUser(player.getUniqueId()).getPlayerClaims().add(claim);
        ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.received"));
    }

    private String generateClaimId(Chunk chunk) {
        return chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ();
    }

    private Date calculateExpirationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, this.plugin.getNconfig().getClaimExpiryDays());
        return calendar.getTime();
    }

    private boolean handlePayment(Player player, User user, double amount) {
        Economy econ;
        if (this.plugin.getBalanceSystem() == Balance.PLAYERDATA) {
            if (user.getBalance() >= amount) {
                user.setBalance(user.getBalance() - amount);
                return true;
            }
        } else if (this.plugin.getBalanceSystem() == Balance.VAULT && (econ = this.plugin.getEconomy()) != null && econ.has((OfflinePlayer)player, amount)) {
            econ.withdrawPlayer((OfflinePlayer)player, amount);
            return true;
        }
        ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("command.balance.not_enough"));
        return false;
    }

    private boolean isInBlacklistedRegion(Location location) {
        if (!NClaim.inst().isWorldGuardEnabled()) {
            return false;
        }
        try {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            if (container == null) {
                return false;
            }
            RegionQuery query = container.createQuery();
            ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)location));
            List<String> blacklistedRegions = this.plugin.getNconfig().getBlacklistedRegions();
            if (blacklistedRegions == null || blacklistedRegions.isEmpty()) {
                return false;
            }
            for (ProtectedRegion region : set) {
                if (!blacklistedRegions.contains(region.getId().toLowerCase())) continue;
                return true;
            }
        }
        catch (Exception e) {
            Util.log("&cFailed to check if location is in blacklisted region: " + e.getMessage());
            return false;
        }
        return false;
    }

    @Generated
    public ClaimService(NClaim plugin) {
        this.plugin = plugin;
    }
}

