/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.feature.draggable;

import java.util.ArrayList;
import java.util.List;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.implement.features.draggables.Armor;
import padej.soup.implement.features.draggables.BossBars;
import padej.soup.implement.features.draggables.Consumable;
import padej.soup.implement.features.draggables.CoolDowns;
import padej.soup.implement.features.draggables.HotBar;
import padej.soup.implement.features.draggables.HotKeys;
import padej.soup.implement.features.draggables.Inventory;
import padej.soup.implement.features.draggables.ModulesList;
import padej.soup.implement.features.draggables.Notifications;
import padej.soup.implement.features.draggables.PlayerInfo;
import padej.soup.implement.features.draggables.Potions;
import padej.soup.implement.features.draggables.ScoreBoard;
import padej.soup.implement.features.draggables.TargetHud;
import padej.soup.implement.features.draggables.Watermark;

public class DraggableRepository {
    private final List<AbstractDraggable> draggable = new ArrayList<AbstractDraggable>();

    public void setup() {
        this.register(new ModulesList(), new TargetHud(), new Potions(), new HotKeys(), new BossBars(), new Armor(), new Watermark(), new Inventory(), new Consumable(), new CoolDowns(), new Notifications(), new ScoreBoard(), new HotBar(), new PlayerInfo());
    }

    public void register(AbstractDraggable ... module) {
        this.draggable.addAll(List.of(module));
    }

    public List<AbstractDraggable> draggable() {
        return this.draggable;
    }

    public <T extends AbstractDraggable> T get(String name) {
        return (T)((AbstractDraggable)this.draggable.stream().filter(module -> module.getName().equalsIgnoreCase(name)).map(module -> module).findFirst().orElse(null));
    }

    public <T extends AbstractDraggable> T get(Class<T> clazz) {
        return (T)((AbstractDraggable)this.draggable.stream().filter(module -> clazz.isAssignableFrom(module.getClass())).map(clazz::cast).findFirst().orElse(null));
    }
}

