/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.file.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.feature.draggable.DraggableRepository;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleRepository;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.implement.BindSetting;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.ColorSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.TextSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.file.ClientFile;
import padej.soup.api.file.exception.FileLoadException;
import padej.soup.api.file.exception.FileSaveException;
import padej.soup.api.file.impl.CurrentConfigFile;
import padej.soup.core.Main;

public class ModuleFile
extends ClientFile {
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final ModuleRepository moduleRepository;
    private final DraggableRepository draggableRepository;

    public ModuleFile(ModuleRepository moduleRepository, DraggableRepository draggableRepository) {
        super("moduleSettings");
        this.moduleRepository = moduleRepository;
        this.draggableRepository = draggableRepository;
    }

    private String getCurrentConfigName() {
        File configDir;
        File configFile;
        CurrentConfigFile currentConfigFile = this.getCurrentConfigFile();
        String configName = null;
        if (currentConfigFile != null && currentConfigFile.hasCurrentConfig()) {
            configName = currentConfigFile.getCurrentConfigName();
        }
        if (configName != null && (configFile = new File(configDir = new File(Main.getInstance().getClientInfoProvider().configsDir(), "config"), configName + ".soup")).exists()) {
            return configName;
        }
        String firstAvailableConfig = this.findFirstAvailableConfig();
        if (firstAvailableConfig != null) {
            if (currentConfigFile != null) {
                currentConfigFile.setCurrentConfigName(firstAvailableConfig);
                try {
                    currentConfigFile.saveToFile(Main.getInstance().getClientInfoProvider().filesDir());
                }
                catch (FileSaveException fileSaveException) {
                    // empty catch block
                }
            }
            return firstAvailableConfig;
        }
        return "default";
    }

    private String findFirstAvailableConfig() {
        try {
            File configDir = new File(Main.getInstance().getClientInfoProvider().configsDir(), "config");
            if (!configDir.exists()) {
                return null;
            }
            File[] configFiles = configDir.listFiles((dir, name) -> name.endsWith(".soup"));
            if (configFiles != null && configFiles.length > 0) {
                String fileName = configFiles[0].getName();
                return fileName.substring(0, fileName.length() - 5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private CurrentConfigFile getCurrentConfigFile() {
        try {
            return Main.getInstance().getFileRepository().getClientFiles().stream().filter(file -> file instanceof CurrentConfigFile).map(file -> (CurrentConfigFile)file).findFirst().orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void saveToFile(File path) throws FileSaveException {
        String configName = this.getCurrentConfigName();
        this.saveToFile(new File(path, "config"), configName + ".soup");
    }

    @Override
    public void loadFromFile(File path) throws FileLoadException {
        String configName = this.getCurrentConfigName();
        this.loadFromFile(new File(path, "config"), configName + ".soup");
    }

    @Override
    public void saveToFile(File path, String fileName) throws FileSaveException {
        JsonObject functionObject = this.createJsonObjectFromModules();
        File file = new File(path, fileName);
        this.writeJsonToFile(functionObject, file);
        super.saveToFile(path, fileName);
    }

    @Override
    public void loadFromFile(File path, String fileName) throws FileLoadException {
        JsonObject functionObject;
        File file = new File(path, fileName);
        if (!file.exists()) {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                JsonObject defaultConfig = this.createJsonObjectFromModules();
                this.writeJsonToFile(defaultConfig, file);
            }
            catch (FileSaveException e) {
                throw new FileLoadException("Failed to create default config file", e);
            }
        }
        if ((functionObject = this.readJsonFromFile(file)) != null) {
            this.updateModulesFromJsonObject(functionObject);
        }
        super.loadFromFile(path, fileName);
    }

    private JsonObject createJsonObjectFromModules() {
        JsonObject functionObject = new JsonObject();
        for (Module module : this.moduleRepository.modules()) {
            JsonObject moduleObject = new JsonObject();
            moduleObject.addProperty("expande", Boolean.valueOf(module.isExpanded()));
            moduleObject.addProperty("bind", (Number)module.getKey());
            moduleObject.addProperty("state", Boolean.valueOf(module.isState()));
            module.settings().forEach(setting -> this.addSettingToJsonObject(moduleObject, (Setting)setting));
            functionObject.add(module.getIdentifier().toLowerCase(), (JsonElement)moduleObject);
        }
        for (AbstractDraggable draggable : this.draggableRepository.draggable()) {
            String key = draggable.getName().toLowerCase();
            JsonObject moduleObject = functionObject.has(key) ? functionObject.getAsJsonObject(key) : new JsonObject();
            moduleObject.addProperty("posX", (Number)draggable.getX());
            moduleObject.addProperty("posY", (Number)draggable.getY());
            functionObject.add(key, (JsonElement)moduleObject);
        }
        return functionObject;
    }

    private void addSettingToJsonObject(JsonObject moduleObject, Setting setting) {
        if (setting instanceof BooleanSetting) {
            BooleanSetting booleanSetting = (BooleanSetting)setting;
            moduleObject.addProperty(setting.getNameKey(), Boolean.valueOf(booleanSetting.isValue()));
        }
        if (setting instanceof ValueSetting) {
            ValueSetting valueSetting = (ValueSetting)setting;
            moduleObject.addProperty(setting.getNameKey(), (Number)Float.valueOf(valueSetting.getValue()));
        }
        if (setting instanceof ColorSetting) {
            ColorSetting colorSetting = (ColorSetting)setting;
            moduleObject.addProperty(setting.getNameKey(), (Number)colorSetting.getColor());
        }
        if (setting instanceof BindSetting) {
            BindSetting bindSetting = (BindSetting)setting;
            moduleObject.addProperty(setting.getNameKey(), (Number)bindSetting.getKey());
        }
        if (setting instanceof TextSetting) {
            TextSetting textSetting = (TextSetting)setting;
            moduleObject.addProperty(setting.getNameKey(), textSetting.getText());
        }
        if (setting instanceof SelectSetting) {
            SelectSetting selectSetting = (SelectSetting)setting;
            moduleObject.addProperty(setting.getNameKey(), selectSetting.getSelected());
        }
        if (setting instanceof MultiSelectSetting) {
            MultiSelectSetting multiSelectSetting = (MultiSelectSetting)setting;
            List<String> selected = multiSelectSetting.getSelected();
            String selectedAsString = String.join((CharSequence)",", selected);
            moduleObject.addProperty(setting.getNameKey(), selectedAsString);
        }
        if (setting instanceof MultiColorSetting) {
            MultiColorSetting multiColorSetting = (MultiColorSetting)setting;
            JsonObject multiColorObject = new JsonObject();
            multiColorObject.addProperty("selectedColorIndex", (Number)multiColorSetting.getSelectedColorIndex());
            JsonArray colorsArray = new JsonArray();
            for (ColorSetting colorSetting : multiColorSetting.getAllColors()) {
                colorsArray.add((Number)colorSetting.getColor());
            }
            multiColorObject.add("colors", (JsonElement)colorsArray);
            moduleObject.add(setting.getNameKey(), (JsonElement)multiColorObject);
        }
        if (setting instanceof GroupSetting) {
            GroupSetting groupSetting = (GroupSetting)setting;
            JsonObject groupObject = new JsonObject();
            groupObject.addProperty("state", Boolean.valueOf(groupSetting.isValue()));
            for (Setting subSetting : groupSetting.getSubSettings()) {
                this.addSettingToJsonObject(groupObject, subSetting);
            }
            moduleObject.add(setting.getNameKey(), (JsonElement)groupObject);
        }
    }

    private void writeJsonToFile(JsonObject functionObject, File file) throws FileSaveException {
        try (FileWriter writer = new FileWriter(file);){
            this.GSON.toJson((JsonElement)functionObject, (Appendable)writer);
        }
        catch (IOException e) {
            throw new FileSaveException("Failed to save module to file", e);
        }
    }

    private JsonObject readJsonFromFile(File file) throws FileLoadException {
        JsonObject jsonObject;
        FileReader reader = new FileReader(file);
        try {
            jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FileLoadException("Failed to load module from file", e);
            }
            catch (JsonIOException | JsonSyntaxException e) {
                throw new FileLoadException("Failed to parse JSON from file", e);
            }
        }
        reader.close();
        return jsonObject;
    }

    private void updateModulesFromJsonObject(JsonObject functionObject) {
        for (Module module : this.moduleRepository.modules()) {
            JsonObject moduleObject = functionObject.getAsJsonObject(module.getIdentifier().toLowerCase());
            if (moduleObject == null) continue;
            if (moduleObject.has("expande")) {
                module.setExpanded(moduleObject.get("expande").getAsBoolean());
            }
            if (moduleObject.has("bind")) {
                module.setKey(moduleObject.get("bind").getAsInt());
            }
            if (moduleObject.has("state")) {
                module.setStateSilent(moduleObject.get("state").getAsBoolean());
            }
            module.settings().forEach(setting -> this.updateSettingFromJsonObject(moduleObject, (Setting)setting));
        }
        for (AbstractDraggable draggable : this.draggableRepository.draggable()) {
            JsonObject draggableObject = functionObject.getAsJsonObject(draggable.getName().toLowerCase());
            if (draggableObject == null || !draggableObject.has("posX") || !draggableObject.has("posY")) continue;
            draggable.setX(draggableObject.get("posX").getAsInt());
            draggable.setY(draggableObject.get("posY").getAsInt());
        }
    }

    private void updateSettingFromJsonObject(JsonObject moduleObject, Setting setting) {
        JsonElement settingElement = moduleObject.get(setting.getNameKey());
        if (settingElement == null || settingElement.isJsonNull()) {
            return;
        }
        if (setting instanceof BooleanSetting) {
            BooleanSetting booleanSetting = (BooleanSetting)setting;
            booleanSetting.setValue(settingElement.getAsBoolean());
        }
        if (setting instanceof ValueSetting) {
            ValueSetting valueSetting = (ValueSetting)setting;
            valueSetting.setValue(settingElement.getAsFloat());
        }
        if (setting instanceof ColorSetting) {
            ColorSetting colorSetting = (ColorSetting)setting;
            colorSetting.setColor(settingElement.getAsInt());
        }
        if (setting instanceof BindSetting) {
            BindSetting bindSetting = (BindSetting)setting;
            bindSetting.setKey(settingElement.getAsInt());
        }
        if (setting instanceof TextSetting) {
            TextSetting textSetting = (TextSetting)setting;
            textSetting.setText(settingElement.getAsString());
        }
        if (setting instanceof SelectSetting) {
            SelectSetting selectSetting = (SelectSetting)setting;
            selectSetting.setSelected(settingElement.getAsString());
        }
        if (setting instanceof MultiSelectSetting) {
            MultiSelectSetting multiSelectSetting = (MultiSelectSetting)setting;
            String asString = settingElement.getAsString();
            ArrayList<String> selectedList = new ArrayList<String>(Arrays.asList(asString.split(",")));
            selectedList.removeIf(s -> !multiSelectSetting.getList().contains(s));
            multiSelectSetting.setSelected(selectedList);
        }
        if (setting instanceof MultiColorSetting) {
            MultiColorSetting multiColorSetting = (MultiColorSetting)setting;
            JsonObject multiColorObject = settingElement.getAsJsonObject();
            if (multiColorObject.has("selectedColorIndex")) {
                multiColorSetting.setSelectedColorIndex(multiColorObject.get("selectedColorIndex").getAsInt());
            }
            if (multiColorObject.has("colors")) {
                JsonArray colorsArray = multiColorObject.getAsJsonArray("colors");
                List<ColorSetting> colorSettings = multiColorSetting.getAllColors();
                for (int i = 0; i < Math.min(colorsArray.size(), colorSettings.size()); ++i) {
                    ColorSetting colorSetting = colorSettings.get(i);
                    int colorValue = colorsArray.get(i).getAsInt();
                    colorSetting.setColor(colorValue);
                }
            }
        }
        if (setting instanceof GroupSetting) {
            GroupSetting groupSetting = (GroupSetting)setting;
            JsonObject groupObject = settingElement.getAsJsonObject();
            if (groupObject.has("state")) {
                groupSetting.setValue(groupObject.get("state").getAsBoolean());
            }
            for (Setting subSetting : groupSetting.getSubSettings()) {
                this.updateSettingFromJsonObject(groupObject, subSetting);
            }
        }
    }

    public void resetAllSettingsToDefaults() {
        for (Module module : this.moduleRepository.modules()) {
            module.setState(false);
            module.setExpanded(false);
            module.setKey(-1);
            for (Setting setting : module.settings()) {
                this.resetSettingToDefault(setting);
            }
        }
    }

    private void resetSettingToDefault(Setting setting) {
        setting.reset();
        if (setting instanceof GroupSetting) {
            GroupSetting groupSetting = (GroupSetting)setting;
            for (Setting subSetting : groupSetting.getSubSettings()) {
                this.resetSettingToDefault(subSetting);
            }
        }
    }
}

