/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.system.discord;

import java.io.IOException;
import java.time.LocalDate;
import java.time.Month;
import net.minecraft.class_2960;
import padej.soup.api.system.discord.utils.DiscordEventHandlers;
import padej.soup.api.system.discord.utils.DiscordRPC;
import padej.soup.api.system.discord.utils.DiscordRichPresence;
import padej.soup.api.system.discord.utils.RPCButton;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.base.util.other.BufferUtil;
import padej.soup.core.Main;
import padej.soup.implement.features.modules.mctiers.Balancer;

public class DiscordManager {
    private final DiscordDaemonThread discordDaemonThread = new DiscordDaemonThread();
    private boolean running = true;
    private DiscordInfo info = new DiscordInfo("Unknown", "", "");
    private class_2960 avatarId;
    private long startTimestamp = System.currentTimeMillis() / 1000L;

    public void init() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("win")) {
            LoggerUtil.info("Discord RPC is disabled on non-Windows systems (detected OS: " + osName + ")");
            this.running = false;
            return;
        }
        DiscordEventHandlers handlers = new DiscordEventHandlers.Builder().ready(user -> {
            Main.getInstance().getDiscordManager().setInfo(new DiscordInfo(user.username, "https://cdn.discordapp.com/avatars/" + user.userId + "/" + user.avatar + ".png", user.userId));
            this.updatePresence();
        }).build();
        DiscordRPC.INSTANCE.Discord_Initialize("1363751101794619463", handlers, true, "");
        this.discordDaemonThread.start();
    }

    public void stopRPC() {
        DiscordRPC.INSTANCE.Discord_Shutdown();
        this.running = false;
    }

    public void load() throws IOException {
        if (this.avatarId == null && !this.info.avatarUrl.isEmpty()) {
            this.avatarId = BufferUtil.registerDynamicTexture("avatar-", BufferUtil.getHeadFromURL(this.info.avatarUrl));
        }
    }

    private void updatePresence() {
        String smallIcon;
        Month month = LocalDate.now().getMonth();
        String imageUrl = month == Month.DECEMBER || month == Month.JANUARY || month == Month.FEBRUARY ? "https://i.postimg.cc/gJdDrs0D/soup-winter.gif" : "https://i.postimg.cc/4dSdyVcw/lv-0-20251005210442.gif";
        DiscordRichPresence.Builder builder = new DiscordRichPresence.Builder().setStartTimestamp(this.startTimestamp).setLargeImage(imageUrl, "Soup Visuals").setButtons(RPCButton.create("Download", "https://modrinth.com/mod/soup-api"), RPCButton.create("Discord Server", "https://discord.gg/gT35BwzMET"));
        if (Balancer.getInstance().isEnabled() && !(smallIcon = Balancer.getInstance().rpcIcon()).isEmpty()) {
            builder.setSmallImage(smallIcon, Balancer.getInstance().fixType.getSelected());
        }
        DiscordRPC.INSTANCE.Discord_UpdatePresence(builder.build());
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setInfo(DiscordInfo info) {
        this.info = info;
    }

    public void setAvatarId(class_2960 avatarId) {
        this.avatarId = avatarId;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public DiscordDaemonThread getDiscordDaemonThread() {
        return this.discordDaemonThread;
    }

    public boolean isRunning() {
        return this.running;
    }

    public DiscordInfo getInfo() {
        return this.info;
    }

    public class_2960 getAvatarId() {
        return this.avatarId;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    private class DiscordDaemonThread
    extends Thread {
        private DiscordDaemonThread() {
        }

        @Override
        public void run() {
            this.setName("Discord-RPC");
            try {
                while (Main.getInstance().getDiscordManager().isRunning()) {
                    DiscordRPC.INSTANCE.Discord_RunCallbacks();
                    DiscordManager.this.load();
                    DiscordManager.this.updatePresence();
                    Thread.sleep(15000L);
                }
            }
            catch (Exception exception) {
                LoggerUtil.error("Stop Discord RPC " + exception.getMessage());
                DiscordManager.this.stopRPC();
            }
            super.run();
        }
    }

    public record DiscordInfo(String userName, String avatarUrl, String userId) {
    }
}

