/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.math;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_9848;
import org.joml.Vector3d;
import padej.soup.base.QuickImports;

public final class MathUtil
implements QuickImports {
    public static double PI2 = Math.PI * 2;

    public static boolean isHovered(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public static class_243 closestPointToBox(class_238 box) {
        class_243 eye = MathUtil.mc.field_1724.method_5836(mc.method_61966().method_60637(true));
        return new class_243(Math.min(Math.max(eye.field_1352, box.field_1323), box.field_1320), Math.min(Math.max(eye.field_1351, box.field_1322), box.field_1325), Math.min(Math.max(eye.field_1350, box.field_1321), box.field_1324));
    }

    public static void scale(class_4587 stack, float x, float y, float scale, Runnable data) {
        if (scale != 1.0f) {
            float scale2 = 0.5f + scale / 2.0f;
            stack.method_22903();
            stack.method_46416(x, y, 0.0f);
            stack.method_22905(scale2, scale2, 1.0f);
            stack.method_46416(-x, -y, 0.0f);
            MathUtil.setAlpha(scale, data);
            stack.method_22909();
        } else {
            data.run();
        }
    }

    public static void scale(class_4587 stack, float x, float y, float scaleX, float scaleY, Runnable data) {
        float sumScale = scaleX * scaleY;
        if (sumScale != 1.0f) {
            stack.method_22903();
            stack.method_46416(x, y, 0.0f);
            stack.method_22905(scaleX, scaleY, 1.0f);
            stack.method_46416(-x, -y, 0.0f);
            MathUtil.setAlpha(sumScale, data);
            stack.method_22909();
        } else {
            data.run();
        }
    }

    public static float blinking(double speed, float f) {
        float red = (float)((double)System.currentTimeMillis() % speed / (speed / (double)f));
        if (red > f / 2.0f) {
            red = f - red;
        }
        return red;
    }

    public static float textScrolling(float textWidth) {
        int speed = (int)(textWidth * 75.0f);
        return (float)class_3532.method_15350((double)((double)(System.currentTimeMillis() % (long)speed) * Math.PI / (double)speed), (double)0.0, (double)1.0) * textWidth;
    }

    public static void setAlpha(float alpha, Runnable data) {
        MathUtil.setColor(1.0f, 1.0f, 1.0f, alpha, data);
    }

    public static void setColor(float red, float green, float blue, float alpha, Runnable data) {
        RenderSystem.setShaderColor((float)class_3532.method_15363((float)red, (float)0.0f, (float)1.0f), (float)class_3532.method_15363((float)green, (float)0.0f, (float)1.0f), (float)class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f), (float)class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f));
        data.run();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static double round(double num, double increment) {
        double rounded = (double)Math.round(num / increment) * increment;
        return (double)Math.round(rounded * 100.0) / 100.0;
    }

    public static int floorNearestMulN(int x, int n) {
        return n * (int)Math.floor((double)x / (double)n);
    }

    public static int getRed(int hex) {
        return hex >> 16 & 0xFF;
    }

    public static int getGreen(int hex) {
        return hex >> 8 & 0xFF;
    }

    public static int getBlue(int hex) {
        return hex & 0xFF;
    }

    public static int getAlpha(int hex) {
        return hex >> 24 & 0xFF;
    }

    public static int applyOpacity(int color, float opacity) {
        return class_9848.method_61324((int)((int)((float)MathUtil.getAlpha(color) * opacity / 255.0f)), (int)MathUtil.getRed(color), (int)MathUtil.getGreen(color), (int)MathUtil.getBlue(color));
    }

    public static class_243 cosSin(int i, int size, double width) {
        int index = Math.min(i, size);
        float cos = (float)(Math.cos((double)index * PI2 / (double)size) * width);
        float sin = (float)(-Math.sin((double)index * PI2 / (double)size) * width);
        return new class_243((double)cos, 0.0, (double)sin);
    }

    public static double absSinAnimation(double input) {
        return Math.abs(1.0 + Math.sin(input)) / 2.0;
    }

    public static Vector3d interpolate(Vector3d prevPos, Vector3d pos) {
        return new Vector3d(MathUtil.interpolate(prevPos.x, pos.x), MathUtil.interpolate(prevPos.y, pos.y), MathUtil.interpolate(prevPos.z, pos.z));
    }

    public static class_243 interpolate(class_243 prevPos, class_243 pos) {
        return new class_243(MathUtil.interpolate(prevPos.field_1352, pos.field_1352), MathUtil.interpolate(prevPos.field_1351, pos.field_1351), MathUtil.interpolate(prevPos.field_1350, pos.field_1350));
    }

    public static class_243 interpolate(class_1297 entity) {
        if (entity == null) {
            return class_243.field_1353;
        }
        return new class_243(MathUtil.interpolate(entity.field_6014, entity.method_23317()), MathUtil.interpolate(entity.field_6036, entity.method_23318()), MathUtil.interpolate(entity.field_5969, entity.method_23321()));
    }

    public static float interpolate(float prev, float orig) {
        return class_3532.method_16439((float)tickCounter.method_60637(false), (float)prev, (float)orig);
    }

    public static double interpolate(double prev, double orig) {
        return class_3532.method_16436((double)tickCounter.method_60637(false), (double)prev, (double)orig);
    }

    public static float interpolateSmooth(double smooth, float prev, float orig) {
        return (float)class_3532.method_16436((double)((double)tickCounter.method_60638() / smooth), (double)prev, (double)orig);
    }

    public static double interpolateSmooth(double smooth, double prev, double orig) {
        return class_3532.method_16436((double)((double)tickCounter.method_60638() / smooth), (double)prev, (double)orig);
    }

    private MathUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

