/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10055;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import padej.soup.api.repository.friend.FriendUtils;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.render.ChinaHatBatchRenderer;
import padej.soup.base.util.render.Render3DUtil;
import padej.soup.core.server.ServerConfigManager;
import padej.soup.implement.features.modules.visuals.ChinaHat;

@Environment(value=EnvType.CLIENT)
public class ChinaHatFeatureRenderer
extends class_3887<class_10055, class_591>
implements QuickImports {
    private static final Map<Integer, class_1657> PLAYER_CACHE = new HashMap<Integer, class_1657>();
    private static long lastCacheUpdate = 0L;
    private static final long CACHE_REFRESH_MS = 1000L;

    public ChinaHatFeatureRenderer(class_3883<class_10055, class_591> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_10055 state, float limbAngle, float limbDistance) {
        if (!ChinaHat.getInstance().isEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCacheUpdate > 1000L) {
            ChinaHatFeatureRenderer.updatePlayerCache();
            lastCacheUpdate = currentTime;
        }
        class_746 player = null;
        if (state.field_53528 == ChinaHatFeatureRenderer.mc.field_1724.method_5628()) {
            player = ChinaHatFeatureRenderer.mc.field_1724;
        } else {
            if (!ChinaHat.getInstance().getRenderOnFriends().isValue()) {
                return;
            }
            player = PLAYER_CACHE.get(state.field_53528);
            if (player == null) {
                return;
            }
        }
        if (player == null) {
            return;
        }
        VisibleUtils.VisibilityLevel level = VisibleUtils.getVisibilityLevel((class_1309)player);
        if (!ServerConfigManager.showChinaHat(level.name())) {
            return;
        }
        matrices.method_22903();
        class_591 playerModel = (class_591)this.method_17165();
        class_630 head = playerModel.method_2838();
        head.method_22703(matrices);
        class_1799 headItem = player.method_6118(class_1304.field_6169);
        float offset = headItem.method_7960() ? -0.72f : -0.78f;
        matrices.method_46416(0.0f, offset, 0.0f);
        float rotationSpeed = ChinaHat.getInstance().getRotationSpeed().getValue();
        if (rotationSpeed != 0.0f) {
            float rotationAngle = (float)(System.currentTimeMillis() % 360000L) / 1000.0f * rotationSpeed * 360.0f;
            matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationAngle));
        }
        this.renderHatGeometry(matrices, vertexConsumers);
        matrices.method_22909();
    }

    private void renderHatGeometry(class_4587 matrices, class_4597 vertexConsumers) {
        int alphaCenterColor;
        int alphaColor2;
        int alphaColor1;
        int centerColor;
        int color2;
        int color1;
        float z2;
        float x2;
        float z1;
        float x1;
        float angle2;
        float angle1;
        int i;
        Matrix4f matrix = matrices.method_23760().method_23761();
        ChinaHat module = ChinaHat.getInstance();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(ChinaHatBatchRenderer.HAT_LAYER);
        int step = 9;
        float centerY = 0.0f;
        float brimY = 0.3f;
        float radius = 0.65f;
        for (i = 0; i < 360; i += step) {
            angle1 = (float)i * ((float)Math.PI / 180);
            angle2 = (float)(i + step) * ((float)Math.PI / 180);
            x1 = class_3532.method_15374((float)angle1) * radius;
            z1 = -class_3532.method_15362((float)angle1) * radius;
            x2 = class_3532.method_15374((float)angle2) * radius;
            z2 = -class_3532.method_15362((float)angle2) * radius;
            color1 = this.getHatGradientColor(i, module);
            color2 = this.getHatGradientColor(i + step, module);
            centerColor = this.getHatGradientColor(i, module);
            alphaColor1 = color1 & 0xFFFFFF | (int)(module.getEdgeAlpha().getValue() * 255.0f) << 24;
            alphaColor2 = color2 & 0xFFFFFF | (int)(module.getEdgeAlpha().getValue() * 255.0f) << 24;
            alphaCenterColor = centerColor & 0xFFFFFF | (int)(module.getCenterAlpha().getValue() * 255.0f) << 24;
            vertexConsumer.method_22918(matrix, 0.0f, centerY, 0.0f).method_39415(alphaCenterColor);
            vertexConsumer.method_22918(matrix, x1, brimY, z1).method_39415(alphaColor1);
            vertexConsumer.method_22918(matrix, x2, brimY, z2).method_39415(alphaColor2);
        }
        for (i = 0; i < 360; i += step) {
            angle1 = (float)i * ((float)Math.PI / 180);
            angle2 = (float)(i + step) * ((float)Math.PI / 180);
            x1 = class_3532.method_15374((float)angle1) * radius;
            z1 = -class_3532.method_15362((float)angle1) * radius;
            x2 = class_3532.method_15374((float)angle2) * radius;
            z2 = -class_3532.method_15362((float)angle2) * radius;
            color1 = ColorUtil.darker(this.getHatGradientColor(i, module), 4);
            color2 = ColorUtil.darker(this.getHatGradientColor(i + step, module), 4);
            centerColor = ColorUtil.darker(this.getHatGradientColor(i, module));
            alphaColor1 = color1 & 0xFFFFFF | (int)(module.getEdgeAlpha().getValue() * 255.0f) << 24;
            alphaColor2 = color2 & 0xFFFFFF | (int)(module.getEdgeAlpha().getValue() * 255.0f) << 24;
            alphaCenterColor = centerColor & 0xFFFFFF | (int)(module.getCenterAlpha().getValue() * 255.0f) << 24;
            vertexConsumer.method_22918(matrix, x2, brimY, z2).method_39415(alphaColor2);
            vertexConsumer.method_22918(matrix, x1, brimY, z1).method_39415(alphaColor1);
            vertexConsumer.method_22918(matrix, 0.0f, centerY, 0.0f).method_39415(alphaCenterColor);
        }
        this.renderHatOutline(matrices, module, step, radius, brimY);
    }

    private void renderHatOutline(class_4587 matrices, ChinaHat module, int step, float radius, float brimY) {
        if (ChinaHatFeatureRenderer.mc.field_1755 instanceof class_481 || ChinaHatFeatureRenderer.mc.field_1755 instanceof class_490) {
            return;
        }
        GL11.glHint((int)3154, (int)4354);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((class_10156)class_10142.field_53864);
        RenderSystem.lineWidth((float)4.0f);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        class_4587.class_4665 entry = matrices.method_23760();
        for (int i = 0; i < 360; i += step) {
            float x1 = class_3532.method_15374((float)((float)i * ((float)Math.PI / 180))) * radius;
            float z1 = -class_3532.method_15362((float)((float)i * ((float)Math.PI / 180))) * radius;
            float x2 = class_3532.method_15374((float)((float)(i + step) * ((float)Math.PI / 180))) * radius;
            float z2 = -class_3532.method_15362((float)((float)(i + step) * ((float)Math.PI / 180))) * radius;
            Vector3f start = new Vector3f(x1, brimY, z1);
            Vector3f end = new Vector3f(x2, brimY, z2);
            int color1 = this.getHatGradientColor(i, module);
            int color2 = this.getHatGradientColor(i + step, module);
            int darkerColor1 = ColorUtil.darker(color1) | 0xFF000000;
            int darkerColor2 = ColorUtil.darker(color2) | 0xFF000000;
            Render3DUtil.vertexLine(entry, (class_4588)buffer, start, end, darkerColor1, darkerColor2);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private int getHatGradientColor(float angle, ChinaHat module) {
        int[] customColors = module.getCustomColors();
        if (customColors != null && customColors.length > 0) {
            float normalizedAngle = angle % 360.0f;
            if (normalizedAngle < 0.0f) {
                normalizedAngle += 360.0f;
            }
            float degreesPerColor = 360.0f / (float)customColors.length;
            int colorIndex1 = (int)(normalizedAngle / degreesPerColor) % customColors.length;
            int colorIndex2 = (colorIndex1 + 1) % customColors.length;
            float factor = normalizedAngle % degreesPerColor / degreesPerColor;
            int color1 = customColors[colorIndex1];
            int color2 = customColors[colorIndex2];
            return this.interpolateColor(color1, color2, factor);
        }
        return ColorUtil.getClientColor();
    }

    private int interpolateColor(int color1, int color2, float factor) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * factor);
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static void updatePlayerCache() {
        PLAYER_CACHE.clear();
        if (ChinaHatFeatureRenderer.mc.field_1687 != null) {
            for (class_1657 player : ChinaHatFeatureRenderer.mc.field_1687.method_18456()) {
                if (!FriendUtils.isFriend((class_1297)player)) continue;
                PLAYER_CACHE.put(player.method_5628(), player);
            }
        }
    }
}

