/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Vector4i;
import padej.soup.base.QuickImports;
import padej.soup.base.util.animation.ThreeStageAnimation;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.other.StopWatch;
import padej.soup.base.util.render.Render3DUtil;
import padej.soup.implement.features.modules.particles.HitBubbles;

public final class HitBubblesRenderer
implements QuickImports {
    public static void renderBubble(class_243 pos, float yaw, float pitch, StopWatch timer, float rotationAngle, HitBubbles module, ThreeStageAnimation animation) {
        if (animation == null) {
            return;
        }
        double elapsedSeconds = (double)timer.elapsedTime() / 1000.0;
        if (animation.isFinished(elapsedSeconds)) {
            return;
        }
        double animationValue = animation.getValue(elapsedSeconds);
        float alpha = HitBubblesRenderer.calculateAlpha(animationValue, module);
        float scale = HitBubblesRenderer.calculateScale(animationValue, module);
        Vector4i colors = HitBubblesRenderer.getBubbleColors(alpha, module);
        class_4587 matrix = new class_4587();
        matrix.method_22903();
        class_4184 cam = HitBubblesRenderer.mc.method_1561().field_4686;
        class_243 targetPos = pos.method_1020(cam.method_19326());
        matrix.method_22907(class_7833.field_40714.rotationDegrees(cam.method_19329()));
        matrix.method_22907(class_7833.field_40716.rotationDegrees(cam.method_19330() + 180.0f));
        matrix.method_22904(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
        matrix.method_22907(class_7833.field_40716.rotationDegrees(yaw));
        matrix.method_22907(class_7833.field_40714.rotationDegrees(pitch));
        matrix.method_22907(class_7833.field_40718.rotationDegrees(rotationAngle));
        class_4587.class_4665 entry = matrix.method_23760().method_56822();
        float size = 2.0f * scale;
        Render3DUtil.drawTexture(entry, module.getBubbleTexture(), -size / 2.0f, -size / 2.0f, size, size, colors, true);
        matrix.method_22909();
    }

    private static Vector4i getBubbleColors(float alpha, HitBubbles module) {
        int[] colors;
        if (module.getColorMode().isSelected("Custom") && (colors = module.getCustomColors()) != null && colors.length > 0) {
            String animType = module.colorAnimation.getSelected();
            if ("Wave".equals(animType)) {
                int color = HitBubblesRenderer.getWaveColor(colors, alpha);
                return new Vector4i(color, color, color, color);
            }
            if ("Vertexes".equals(animType)) {
                return HitBubblesRenderer.getVertexColors(colors, alpha);
            }
        }
        int playerColor = ColorUtil.multAlpha(ColorUtil.getClientColor(), alpha);
        return new Vector4i(playerColor, playerColor, playerColor, playerColor);
    }

    private static int getWaveColor(int[] colors, float alpha) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], alpha);
        }
        if (colors.length == 2) {
            int angle = (int)(System.currentTimeMillis() / 8L % 360L);
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.multAlpha(ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f), alpha);
        }
        float timeProgress = (float)(System.currentTimeMillis() / 10L % ((long)colors.length * 360L)) / 360.0f;
        int index1 = (int)Math.floor(timeProgress) % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = timeProgress - (float)((int)Math.floor(timeProgress));
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), alpha);
    }

    private static Vector4i getVertexColors(int[] colors, float alpha) {
        if (colors.length == 1) {
            int color = ColorUtil.multAlpha(colors[0], alpha);
            return new Vector4i(color, color, color, color);
        }
        int color1 = HitBubblesRenderer.getVertexGradientColor(0, colors, alpha);
        int color2 = HitBubblesRenderer.getVertexGradientColor(90, colors, alpha);
        int color3 = HitBubblesRenderer.getVertexGradientColor(180, colors, alpha);
        int color4 = HitBubblesRenderer.getVertexGradientColor(270, colors, alpha);
        return new Vector4i(color1, color2, color3, color4);
    }

    private static int getVertexGradientColor(int angleOffset, int[] colors, float alpha) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], alpha);
        }
        int angle = (int)((System.currentTimeMillis() / 8L + (long)angleOffset) % 360L);
        if (colors.length == 2) {
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.multAlpha(ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f), alpha);
        }
        float progress = (float)angle / 360.0f;
        float colorIndex = progress * (float)colors.length;
        int index1 = (int)colorIndex % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = colorIndex - (float)((int)colorIndex);
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), alpha);
    }

    private static float calculateAlpha(double animationValue, HitBubbles module) {
        String animType = module.animationType.getSelected();
        if ("Scale".equals(animType)) {
            return 1.0f;
        }
        return (float)Math.max(0.0, Math.min(1.0, animationValue));
    }

    private static float calculateScale(double animationValue, HitBubbles module) {
        String animType = module.animationType.getSelected();
        if ("Fade".equals(animType)) {
            return module.scale.getValue();
        }
        float scaleFactor = (float)Math.max(0.0, Math.min(1.0, animationValue));
        return module.scale.getValue() * scaleFactor;
    }

    private HitBubblesRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

