/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.features.modules.hud.HotBar;

public final class HotBarStatusRenderer
implements QuickImports {
    public static void renderHealthBar(class_332 context, int x, int y, int width, int height, int radius, float health, float maxHealth, float absorption) {
        float maxAbsorption;
        float absorptionProgress;
        int absorptionWidth;
        float healthProgress = Math.min(health / maxHealth, 1.0f);
        int healthFilledWidth = (int)((float)width * healthProgress);
        class_4587 matrices = context.method_51448();
        blur.render(ShapeProperties.create(matrices, x, y, width, height).round((float)radius).thickness(2.0f).softness(1.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        if (healthFilledWidth > 0) {
            int colorStart = ColorUtil.multDark(-52429, 0.6f);
            int colorEnd = -43691;
            if (HotBar.getInstance().getBarsGlow().isValue()) {
                rectangle.render(ShapeProperties.create(matrices, x, y, healthFilledWidth, height).round((float)radius).softness(10.0f).color(ColorUtil.multAlpha(colorEnd, 0.2f)).build());
            }
            rectangle.render(ShapeProperties.create(matrices, x + 1, y + 1, healthFilledWidth - 2, height - 2).round((float)radius - 0.5f).color(colorStart, colorEnd, colorEnd, colorStart).build());
        }
        if (absorption > 0.0f && (absorptionWidth = (int)((float)width * (absorptionProgress = (maxAbsorption = HotBarStatusRenderer.mc.field_1724 != null ? HotBarStatusRenderer.mc.field_1724.method_52541() : 20.0f) > 0.0f ? Math.min(absorption / maxAbsorption, 1.0f) : 0.0f))) > 0) {
            int absColorStart = ColorUtil.multDark(-22016, 0.6f);
            int absColorEnd = -8909;
            if (HotBar.getInstance().getBarsGlow().isValue()) {
                rectangle.render(ShapeProperties.create(matrices, x, y, absorptionWidth, height).round((float)radius).softness(10.0f).color(ColorUtil.multAlpha(absColorEnd, 0.2f)).build());
            }
            rectangle.render(ShapeProperties.create(matrices, x + 1, y + 1, absorptionWidth - 2, height - 2).round((float)radius - 0.5f).color(absColorStart, absColorEnd, absColorEnd, absColorStart).build());
        }
        if (HotBar.getInstance().getBarsText().isValue()) {
            float totalHealth = health + absorption;
            String text = String.format("%.1f", Float.valueOf(totalHealth));
            float textHeight = 12.0f;
            float textY = (float)y + ((float)height - textHeight) / 2.0f;
            Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawCenteredString(matrices, text, (float)x + (float)width / 2.0f, textY + 5.0f, ColorUtil.getText());
        }
        image.setTexture("textures/hotbar/hp.png").render(ShapeProperties.create(matrices, x + 2, (float)y + 1.5f, 6.0, 6.0).color(ColorUtil.getText()).build());
    }

    public static void renderArmorBar(class_332 context, int x, int y, int width, int height, int radius, float armor) {
        float progress = Math.min(armor / 20.0f, 1.0f);
        int filledWidth = (int)((float)width * progress);
        class_4587 matrices = context.method_51448();
        blur.render(ShapeProperties.create(matrices, x, y, width, height).round((float)radius).thickness(2.0f).softness(1.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        if (filledWidth > 0) {
            int colorStart = ColorUtil.multDark(-12285697, 0.6f);
            int colorEnd = -10048769;
            if (HotBar.getInstance().getBarsGlow().isValue()) {
                rectangle.render(ShapeProperties.create(matrices, x, y, filledWidth, height).round((float)radius).softness(10.0f).color(ColorUtil.multAlpha(colorEnd, 0.2f)).build());
            }
            rectangle.render(ShapeProperties.create(matrices, x + 1, y + 1, filledWidth - 2, height - 2).round((float)radius - 0.5f).color(colorStart, colorEnd, colorEnd, colorStart).build());
        }
        if (HotBar.getInstance().getBarsText().isValue()) {
            String text = String.format("%.0f", Float.valueOf(armor));
            float textHeight = 12.0f;
            float textY = (float)y + ((float)height - textHeight) / 2.0f;
            Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawCenteredString(matrices, text, (float)x + (float)width / 2.0f, textY + 4.5f, ColorUtil.getText());
        }
        image.setTexture("textures/hotbar/armor.png").render(ShapeProperties.create(matrices, x + 2, (float)y + 1.5f, 6.0, 6.0).color(ColorUtil.getText()).build());
    }

    public static void renderHungerBar(class_332 context, int x, int y, int width, int height, int radius, float food, float saturation) {
        float totalFood = food + saturation;
        float progress = Math.min(totalFood / 40.0f, 1.0f);
        int filledWidth = (int)((float)width * progress);
        class_4587 matrices = context.method_51448();
        blur.render(ShapeProperties.create(matrices, x, y, width, height).round((float)radius).thickness(2.0f).softness(1.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        if (filledWidth > 0) {
            int colorStart = ColorUtil.multDark(-30720, 0.6f);
            int colorEnd = -21965;
            float barX = x + width - filledWidth;
            if (HotBar.getInstance().getBarsGlow().isValue()) {
                rectangle.render(ShapeProperties.create(matrices, barX, y, filledWidth, height).round((float)radius).softness(10.0f).color(ColorUtil.multAlpha(colorEnd, 0.2f)).build());
            }
            rectangle.render(ShapeProperties.create(matrices, barX + 1.0f, y + 1, filledWidth - 2, height - 2).round((float)radius - 0.5f).color(colorEnd, colorStart, colorStart, colorEnd).build());
        }
        if (HotBar.getInstance().getBarsText().isValue()) {
            String text = String.format("%.0f", Float.valueOf(totalFood));
            float textHeight = 12.0f;
            float textY = (float)y + ((float)height - textHeight) / 2.0f;
            Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawCenteredString(matrices, text, (float)x + (float)width / 2.0f, textY + 5.0f, ColorUtil.getText());
        }
        image.setTexture("textures/hotbar/food.png").render(ShapeProperties.create(matrices, x + width - 8, (float)y + 1.5f, 6.0, 6.0).color(ColorUtil.getText()).build());
    }

    public static void renderAirBar(class_332 context, int x, int y, int width, int height, int radius, float air, float maxAir) {
        float progress = Math.min(air / maxAir, 1.0f);
        int filledWidth = (int)((float)width * progress);
        class_4587 matrices = context.method_51448();
        blur.render(ShapeProperties.create(matrices, x, y, width, height).round((float)radius).thickness(2.0f).softness(1.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        if (filledWidth > 0) {
            int colorStart = ColorUtil.multDark(-16733441, 0.6f);
            int colorEnd = -13382401;
            float barX = x + width - filledWidth;
            if (HotBar.getInstance().getBarsGlow().isValue()) {
                rectangle.render(ShapeProperties.create(matrices, barX, y, filledWidth, height).round((float)radius).softness(10.0f).color(ColorUtil.multAlpha(colorEnd, 0.2f)).build());
            }
            rectangle.render(ShapeProperties.create(matrices, barX + 1.0f, y + 1, filledWidth - 2, height - 2).round((float)radius - 0.5f).color(colorEnd, colorStart, colorStart, colorEnd).build());
        }
        if (HotBar.getInstance().getBarsText().isValue()) {
            String text = String.format("%.0f", Float.valueOf(air));
            float textHeight = 12.0f;
            float textY = (float)y + ((float)height - textHeight) / 2.0f;
            Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawCenteredString(matrices, text, (float)x + (float)width / 2.0f, textY + 4.5f, ColorUtil.getText());
        }
        image.setTexture("textures/hotbar/air.png").render(ShapeProperties.create(matrices, x + width - 8, (float)y + 1.5f, 6.0, 6.0).color(ColorUtil.getText()).build());
    }

    public static void renderExperienceBar(class_332 context, int x, int y, int width, int height, int radius, float experience, int experienceLevel) {
        float progress = Math.min(experience, 1.0f);
        int filledWidth = (int)((float)width * progress);
        class_4587 matrices = context.method_51448();
        if (filledWidth > 0) {
            int colorStart = ColorUtil.multDark(-16711936, 0.6f);
            int colorEnd = -11141291;
            if (HotBar.getInstance().getBarsGlow().isValue()) {
                rectangle.render(ShapeProperties.create(matrices, x, y, filledWidth, height).round((float)radius).softness(3.0f).color(ColorUtil.multAlpha(colorEnd, 0.2f)).build());
            }
            rectangle.render(ShapeProperties.create(matrices, x + 1, y + 1, filledWidth - 2, height - 2).round((float)radius - 0.5f).color(colorStart, colorEnd, colorEnd, colorStart).build());
        }
    }

    private HotBarStatusRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

