/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.features.draggables.particles.TargetHudParticle;
import padej.soup.implement.features.modules.other.Trinket;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;

public class PhysicsIconRenderer
implements QuickImports {
    private static final float TARGET_FRAME_TIME = 16.67f;
    private float posX;
    private float posY;
    private float velocityX;
    private float velocityY;
    private boolean isDragging = false;
    private float dragOffsetX;
    private float dragOffsetY;
    private final Deque<PositionRecord> positionHistory = new ArrayDeque<PositionRecord>();
    private final Deque<TrailFrame> trailFrames = new ArrayDeque<TrailFrame>();
    private float screenWidth;
    private float screenHeight;
    private long lastUpdateTime;
    private long lastBounceSoundTime = 0L;
    private static final long BOUNCE_SOUND_COOLDOWN = 100L;
    private long lastTrailSaveTime = 0L;
    private static final long TRAIL_SAVE_INTERVAL = 16L;
    private List<Rectangle> uiRectangles = new ArrayList<Rectangle>();
    private final List<TargetHudParticle> particles = new ArrayList<TargetHudParticle>();
    private final CachedSettings cachedSettings = new CachedSettings();
    private long lastSettingsUpdate = 0L;
    private static final long SETTINGS_CACHE_TIME = 50L;
    private float cachedSpeed = 0.0f;

    public PhysicsIconRenderer(int screenWidth, int screenHeight) {
        long currentTime;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        float iconSize = this.getIconSize();
        this.posX = (float)screenWidth / 2.0f - iconSize / 2.0f;
        this.posY = 10.0f;
        this.velocityX = 0.0f;
        this.velocityY = 0.0f;
        this.lastUpdateTime = currentTime = System.currentTimeMillis();
        this.lastTrailSaveTime = currentTime;
    }

    public void updateScreenSize(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    private void updateSettingsCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSettingsUpdate < 50L) {
            return;
        }
        this.lastSettingsUpdate = currentTime;
        Trinket module = Trinket.getInstance();
        if (module != null && module.isEnabled()) {
            this.cachedSettings.iconSize = module.getIconSize().getValue();
            this.cachedSettings.gravity = module.getGravity().getValue();
            this.cachedSettings.weight = module.getWeight().getValue();
            this.cachedSettings.friction = module.getFriction().getValue();
            this.cachedSettings.bounce = module.getBounce().getValue();
            this.cachedSettings.groundFriction = module.getGroundFriction().getValue();
            this.cachedSettings.minSpeed = module.getMinSpeed().getValue();
            this.cachedSettings.trailLength = (int)module.getTrailLength().getValue();
            this.cachedSettings.trailEnabled = module.getEnableTrail().isValue();
            this.cachedSettings.trailSizeModifier = module.getTrailSizeModifier().getValue();
            this.cachedSettings.trailColor = module.getTrailColorMode().isSelected("Custom") ? module.getTrailColor().getColor() : ColorUtil.getClientColor();
            String iconType = module.getIconType().getSelected().toLowerCase();
            this.cachedSettings.iconTexture = class_2960.method_60654((String)("textures/trinket/" + iconType + ".png"));
            this.cachedSettings.iconColor = module.getIconColorMode().isSelected("Custom") ? module.getIconColor().getColor() : ColorUtil.getClientColor();
            this.cachedSettings.moduleEnabled = true;
        } else {
            this.cachedSettings.iconSize = 16.0f;
            this.cachedSettings.gravity = 0.5f;
            this.cachedSettings.weight = 1.0f;
            this.cachedSettings.friction = 0.98f;
            this.cachedSettings.bounce = 0.7f;
            this.cachedSettings.groundFriction = 0.9f;
            this.cachedSettings.minSpeed = 0.5f;
            this.cachedSettings.trailLength = 15;
            this.cachedSettings.trailEnabled = false;
            this.cachedSettings.trailSizeModifier = 1.0f;
            this.cachedSettings.trailColor = ColorUtil.getClientColor();
            this.cachedSettings.iconTexture = class_2960.method_60654((String)"textures/trinket/atom.png");
            this.cachedSettings.iconColor = -1;
            this.cachedSettings.moduleEnabled = false;
        }
    }

    private float getIconSize() {
        return this.cachedSettings.iconSize;
    }

    private float getGravity() {
        return this.cachedSettings.gravity;
    }

    private float getWeight() {
        return this.cachedSettings.weight;
    }

    private float getFriction() {
        return this.cachedSettings.friction;
    }

    private float getBounce() {
        return this.cachedSettings.bounce;
    }

    private float getGroundFriction() {
        return this.cachedSettings.groundFriction;
    }

    private float getMinSpeed() {
        return this.cachedSettings.minSpeed;
    }

    private int getTrailLength() {
        return this.cachedSettings.trailLength;
    }

    private boolean isTrailEnabled() {
        return this.cachedSettings.trailEnabled;
    }

    private int getTrailColor() {
        return this.cachedSettings.trailColor;
    }

    private float getTrailSizeModifier() {
        return this.cachedSettings.trailSizeModifier;
    }

    private class_2960 getIconTexture() {
        return this.cachedSettings.iconTexture;
    }

    private int getIconColor() {
        return this.cachedSettings.iconColor;
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateSettingsCache();
        this.screenWidth = mc.method_22683().method_4486();
        this.screenHeight = mc.method_22683().method_4502();
        long currentTime = System.currentTimeMillis();
        float deltaTime = currentTime - this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
        float timeMultiplier = deltaTime / 16.67f;
        this.saveCurrentFrame();
        this.updatePhysics(timeMultiplier);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        this.renderTrails(matrices);
        this.updateAndRenderParticles(matrices, timeMultiplier);
        float iconSize = this.getIconSize();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawTexture(matrices, this.posX, this.posX + iconSize, this.posY, this.posY + iconSize, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize, this.getIconTexture(), this.getIconColor());
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    private void drawTexture(class_4587 matrix, float x1, float x2, float y1, float y2, int regionWidth, int regionHeight, int textureWidth, int textureHeight, class_2960 texture, int color) {
        float u1 = 0.0f / (float)textureWidth;
        float u2 = (0.0f + (float)regionWidth) / (float)textureWidth;
        float v1 = 0.0f / (float)textureHeight;
        float v2 = (0.0f + (float)regionHeight) / (float)textureHeight;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f matrix4f = matrix.method_23760().method_23761();
        buffer.method_22918(matrix4f, x1, y1, 0.0f).method_22913(u1, v1).method_1336(r, g, b, a);
        buffer.method_22918(matrix4f, x1, y2, 0.0f).method_22913(u1, v2).method_1336(r, g, b, a);
        buffer.method_22918(matrix4f, x2, y2, 0.0f).method_22913(u2, v2).method_1336(r, g, b, a);
        buffer.method_22918(matrix4f, x2, y1, 0.0f).method_22913(u2, v1).method_1336(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void renderTrails(class_4587 matrices) {
        if (!this.isTrailEnabled() || this.trailFrames.isEmpty()) {
            return;
        }
        float minSpeed = this.getMinSpeed();
        if (this.cachedSpeed < minSpeed) {
            return;
        }
        float speedFactor = Math.min(this.cachedSpeed / 10.0f, 1.0f);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"textures/particles/bloom/bloom.png"));
        int trailColor = this.getTrailColor();
        int r = trailColor >> 16 & 0xFF;
        int g = trailColor >> 8 & 0xFF;
        int b = trailColor & 0xFF;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float iconSize = this.getIconSize();
        float sizeModifier = this.getTrailSizeModifier();
        int interpolationSteps = 4;
        long currentTime = System.currentTimeMillis();
        int totalTrailPoints = this.trailFrames.size() * (interpolationSteps + 1) + interpolationSteps;
        int pointIndex = 0;
        this.renderTrailPointBatched(buffer, matrix4f, this.posX, this.posY, pointIndex++, totalTrailPoints, speedFactor, iconSize, sizeModifier, r, g, b);
        if (!this.trailFrames.isEmpty()) {
            TrailFrame firstFrame = this.trailFrames.getFirst();
            for (int j = 1; j <= interpolationSteps; ++j) {
                float t = (float)j / (float)(interpolationSteps + 1);
                float interpX = this.posX + (firstFrame.x - this.posX) * t;
                float interpY = this.posY + (firstFrame.y - this.posY) * t;
                this.renderTrailPointBatched(buffer, matrix4f, interpX, interpY, pointIndex++, totalTrailPoints, speedFactor, iconSize, sizeModifier, r, g, b);
            }
        }
        Object[] frames = this.trailFrames.toArray();
        for (int i = 0; i < frames.length; ++i) {
            TrailFrame currentFrame = (TrailFrame)frames[i];
            this.renderTrailPointBatched(buffer, matrix4f, currentFrame.x, currentFrame.y, pointIndex++, totalTrailPoints, speedFactor, iconSize, sizeModifier, r, g, b);
            if (i >= frames.length - 1) continue;
            TrailFrame nextFrame = (TrailFrame)frames[i + 1];
            for (int j = 1; j <= interpolationSteps; ++j) {
                float t = (float)j / (float)(interpolationSteps + 1);
                float interpX = currentFrame.x + (nextFrame.x - currentFrame.x) * t;
                float interpY = currentFrame.y + (nextFrame.y - currentFrame.y) * t;
                this.renderTrailPointBatched(buffer, matrix4f, interpX, interpY, pointIndex++, totalTrailPoints, speedFactor, iconSize, sizeModifier, r, g, b);
            }
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void renderTrailPointBatched(class_287 buffer, Matrix4f matrix4f, float posX, float posY, int index, int totalPoints, float speedFactor, float iconSize, float sizeModifier, int r, int g, int b) {
        float progress = (float)index / (float)totalPoints;
        float size = iconSize * (1.0f - progress * 0.66f) * speedFactor * sizeModifier + 10.0f;
        float trailGradient = 1.0f - progress;
        float opacity = trailGradient * speedFactor * 0.8f;
        int a = (int)(opacity * 255.0f);
        if (a > 0) {
            float x = posX + iconSize / 2.0f - size / 2.0f;
            float y = posY + iconSize / 2.0f - size / 2.0f;
            buffer.method_22918(matrix4f, x, y, 0.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix4f, x, y + size, 0.0f).method_22913(0.0f, 1.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix4f, x + size, y + size, 0.0f).method_22913(1.0f, 1.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix4f, x + size, y, 0.0f).method_22913(1.0f, 0.0f).method_1336(r, g, b, a);
        }
    }

    private void updatePhysics(float timeMultiplier) {
        boolean onGround;
        if (this.isDragging) {
            this.cachedSpeed = 0.0f;
            return;
        }
        float iconSize = this.getIconSize();
        float gravity = this.getGravity();
        float weight = this.getWeight();
        float friction = this.getFriction();
        float groundFriction = this.getGroundFriction();
        timeMultiplier = Math.min(timeMultiplier, 3.0f);
        float restThreshold = 0.5f;
        boolean bl = onGround = this.posY >= this.screenHeight - iconSize - 0.1f;
        if (!onGround || Math.abs(this.velocityY) > restThreshold) {
            this.velocityY += gravity * weight * timeMultiplier;
        } else {
            this.velocityY = 0.0f;
            this.posY = this.screenHeight - iconSize;
        }
        this.posX += this.velocityX * timeMultiplier;
        this.posY += this.velocityY * timeMultiplier;
        float frictionFactor = (float)Math.pow(friction, timeMultiplier);
        this.velocityX *= frictionFactor;
        this.velocityY *= frictionFactor;
        this.checkBoundaryCollisions();
        if (!this.uiRectangles.isEmpty()) {
            for (Rectangle rect : this.uiRectangles) {
                this.bounceFromRect(rect.min.field_1343, rect.min.field_1342, rect.max.field_1343 - rect.min.field_1343, rect.max.field_1342 - rect.min.field_1342);
            }
        }
        if (onGround && Math.abs(this.velocityY) < restThreshold) {
            float groundFrictionFactor = (float)Math.pow(groundFriction, timeMultiplier);
            this.velocityX *= groundFrictionFactor;
        }
        this.cachedSpeed = (float)Math.sqrt(this.velocityX * this.velocityX + this.velocityY * this.velocityY);
    }

    private void bounceFromRect(float rectX, float rectY, float rectWidth, float rectHeight) {
        float iconSize = this.getIconSize();
        float bounce = this.getBounce();
        float minBounceSpeed = 2.0f;
        if (this.posX + iconSize > rectX && this.posX < rectX + rectWidth && this.posY + iconSize > rectY && this.posY < rectY + rectHeight) {
            float dxLeft = Math.abs(this.posX + iconSize - rectX);
            float dxRight = Math.abs(this.posX - (rectX + rectWidth));
            float dyTop = Math.abs(this.posY + iconSize - rectY);
            float dyBottom = Math.abs(this.posY - (rectY + rectHeight));
            float minDist = Math.min(Math.min(dxLeft, dxRight), Math.min(dyTop, dyBottom));
            if (minDist == dxLeft) {
                this.posX = rectX - iconSize;
                if (Math.abs(this.velocityX) > minBounceSpeed) {
                    this.playBounceSound();
                    this.spawnBounceParticles(this.posX, this.posY);
                }
                this.velocityX *= -bounce;
            } else if (minDist == dxRight) {
                this.posX = rectX + rectWidth;
                if (Math.abs(this.velocityX) > minBounceSpeed) {
                    this.playBounceSound();
                    this.spawnBounceParticles(this.posX, this.posY);
                }
                this.velocityX *= -bounce;
            } else if (minDist == dyTop) {
                this.posY = rectY - iconSize;
                if (Math.abs(this.velocityY) > minBounceSpeed) {
                    this.playBounceSound();
                    this.spawnBounceParticles(this.posX, this.posY);
                }
                this.velocityY *= -bounce;
            } else if (minDist == dyBottom) {
                this.posY = rectY + rectHeight;
                if (Math.abs(this.velocityY) > minBounceSpeed) {
                    this.playBounceSound();
                    this.spawnBounceParticles(this.posX, this.posY);
                }
                this.velocityY *= -bounce;
            }
        }
    }

    private void checkBoundaryCollisions() {
        float iconSize = this.getIconSize();
        float bounce = this.getBounce();
        float restThreshold = 0.5f;
        float minBounceSpeed = 2.0f;
        if (this.posX <= 0.0f) {
            this.posX = 0.0f;
            if (Math.abs(this.velocityX) > minBounceSpeed) {
                this.playBounceSound();
                this.spawnBounceParticles(this.posX, this.posY);
            }
            this.velocityX = Math.abs(this.velocityX) * bounce;
        } else if (this.posX >= this.screenWidth - iconSize) {
            this.posX = this.screenWidth - iconSize;
            if (Math.abs(this.velocityX) > minBounceSpeed) {
                this.playBounceSound();
                this.spawnBounceParticles(this.posX, this.posY);
            }
            this.velocityX = -Math.abs(this.velocityX) * bounce;
        }
        if (this.posY <= 0.0f) {
            this.posY = 0.0f;
            if (Math.abs(this.velocityY) > minBounceSpeed) {
                this.playBounceSound();
                this.spawnBounceParticles(this.posX, this.posY);
            }
            this.velocityY = Math.abs(this.velocityY) * bounce;
        } else if (this.posY >= this.screenHeight - iconSize) {
            this.posY = this.screenHeight - iconSize;
            if (Math.abs(this.velocityY) < restThreshold) {
                this.velocityY = 0.0f;
            } else {
                if (Math.abs(this.velocityY) > minBounceSpeed) {
                    this.playBounceSound();
                    this.spawnBounceParticles(this.posX, this.posY);
                }
                this.velocityY = -Math.abs(this.velocityY) * bounce;
            }
        }
    }

    private void playBounceSound() {
        float volumeMultiplier;
        if (!this.cachedSettings.moduleEnabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastBounceSoundTime < 100L) {
            return;
        }
        Trinket module = Trinket.getInstance();
        if (module == null) {
            return;
        }
        float baseVolume = Math.min(this.cachedSpeed / 10.0f, 1.0f);
        float finalVolume = baseVolume * (volumeMultiplier = module.getSoundVolume().getValue());
        if (finalVolume > 0.05f) {
            float pitch = 0.8f + (float)Math.random() * 0.4f;
            class_3414 sound = this.getSelectedSound(module);
            SoundManager.playSound(sound, finalVolume, pitch);
            this.lastBounceSoundTime = currentTime;
        }
    }

    private class_3414 getSelectedSound(Trinket module) {
        String soundType;
        return switch (soundType = module.getSoundType().getSelected()) {
            case "8Bit" -> SoundManager.TRINKET_8BIT;
            case "Glass" -> SoundManager.TRINKET_GLASS;
            case "DrumBass" -> SoundManager.TRINKET_DRUM_BASS;
            case "AimBooster" -> SoundManager.TRINKET_AIMBOOSTER;
            case "Plastic" -> SoundManager.TRINKET_PLASTIC;
            case "Blip" -> SoundManager.TRINKET_BLIP;
            case "Pop" -> SoundManager.TRINKET_POP;
            default -> SoundManager.TRINKET_HIT;
        };
    }

    private void saveCurrentFrame() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTrailSaveTime >= 16L) {
            this.trailFrames.addFirst(new TrailFrame(this.posX, this.posY, currentTime));
            this.lastTrailSaveTime = currentTime;
        }
        long maxAge = (long)this.getTrailLength() * 16L;
        while (!this.trailFrames.isEmpty() && currentTime - this.trailFrames.getLast().timestamp > maxAge) {
            this.trailFrames.removeLast();
        }
    }

    public void handleMouseClick(int mouseX, int mouseY, int button) {
        if (button == 0) {
            float iconSize = this.getIconSize();
            if ((float)mouseX >= this.posX && (float)mouseX <= this.posX + iconSize && (float)mouseY >= this.posY && (float)mouseY <= this.posY + iconSize) {
                this.startDrag(mouseX, mouseY);
            }
        }
    }

    public void handleMouseRelease(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.endDrag();
        }
    }

    public void handleMouseDrag(int mouseX, int mouseY) {
        if (this.isDragging) {
            this.updateDrag(mouseX, mouseY);
        }
    }

    private void startDrag(int mouseX, int mouseY) {
        this.isDragging = true;
        this.velocityX = 0.0f;
        this.velocityY = 0.0f;
        this.dragOffsetX = (float)mouseX - this.posX;
        this.dragOffsetY = (float)mouseY - this.posY;
        this.positionHistory.clear();
    }

    private void updateDrag(int mouseX, int mouseY) {
        float iconSize = this.getIconSize();
        float newX = (float)mouseX - this.dragOffsetX;
        float newY = (float)mouseY - this.dragOffsetY;
        this.posX = Math.max(0.0f, Math.min(this.screenWidth - iconSize, newX));
        this.posY = Math.max(0.0f, Math.min(this.screenHeight - iconSize, newY));
        this.positionHistory.add(new PositionRecord(this.posX, this.posY, System.currentTimeMillis()));
        if (this.positionHistory.size() > 5) {
            this.positionHistory.removeFirst();
        }
    }

    private void endDrag() {
        if (!this.isDragging) {
            return;
        }
        this.isDragging = false;
        this.calculateThrowVelocity();
    }

    private void calculateThrowVelocity() {
        if (this.positionHistory.size() < 2) {
            return;
        }
        PositionRecord recent = this.positionHistory.getLast();
        PositionRecord older = this.positionHistory.getFirst();
        float timeDiff = (float)(recent.time - older.time) / 16.67f;
        if (timeDiff > 0.0f) {
            this.velocityX = (recent.x - older.x) / timeDiff * 1.2f;
            this.velocityY = (recent.y - older.y) / timeDiff * 1.2f;
            float maxSpeed = 25.0f;
            float speed = (float)Math.sqrt(this.velocityX * this.velocityX + this.velocityY * this.velocityY);
            if (speed > maxSpeed) {
                this.velocityX = this.velocityX / speed * maxSpeed;
                this.velocityY = this.velocityY / speed * maxSpeed;
            }
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        float iconSize = this.getIconSize();
        return (float)mouseX >= this.posX && (float)mouseX <= this.posX + iconSize && (float)mouseY >= this.posY && (float)mouseY <= this.posY + iconSize;
    }

    public void setUIRectangles(List<Rectangle> rectangles) {
        this.uiRectangles = rectangles;
    }

    private void spawnBounceParticles(float bounceX, float bounceY) {
        Trinket module = Trinket.getInstance();
        if (module == null || !module.isEnabled() || !module.getEnableParticles().isValue()) {
            return;
        }
        int count = (int)module.getParticleCount().getValue();
        float size = module.getParticleSize().getValue();
        float lifetime = module.getParticleLifetime().getValue();
        float speedMultiplier = module.getParticleSpeed().getValue();
        float maxRadius = module.getParticleMaxRadius().getValue();
        int[] customColors = module.getCustomColors();
        List<String> selectedTypes = module.getParticleMode().getSelected();
        if (selectedTypes.isEmpty()) {
            return;
        }
        float iconSize = this.getIconSize();
        for (int i = 0; i < count; ++i) {
            Color particleColor;
            String randomType = selectedTypes.get((int)(Math.random() * (double)selectedTypes.size()));
            TargetHudParticle.ParticleType type = TargetHudParticle.parseType(randomType);
            double angle = Math.random() * Math.PI * 2.0;
            double speed = (Math.random() * 2.0 + 1.0) * (double)speedMultiplier;
            float motionX = (float)(Math.cos(angle) * speed);
            float motionY = (float)(Math.sin(angle) * speed);
            float spawnX = bounceX + iconSize / 2.0f;
            float spawnY = bounceY + iconSize / 2.0f;
            if (module.getParticleColorMode().isSelected("Custom") && customColors != null && customColors.length > 0) {
                if (module.getParticleColorAnimation().isSelected("Vertex")) {
                    int colorIndex = i % customColors.length;
                    particleColor = new Color(customColors[colorIndex], true);
                } else {
                    long time = System.currentTimeMillis();
                    float phase = ((float)time / 1000.0f + (float)i * 0.1f) % 1.0f;
                    int colorIndex = (int)(phase * (float)customColors.length);
                    particleColor = new Color(customColors[colorIndex], true);
                }
            } else {
                int colorInt = ColorUtil.getClientColor();
                particleColor = new Color(colorInt, true);
            }
            TargetHudParticle particle = new TargetHudParticle(spawnX, spawnY, motionX, motionY, size, particleColor, type, lifetime * 4.0f, speedMultiplier, maxRadius, "Fly");
            this.particles.add(particle);
        }
    }

    private void updateAndRenderParticles(class_4587 matrices, float delta) {
        this.particles.removeIf(TargetHudParticle::update);
        for (TargetHudParticle particle : this.particles) {
            particle.render(matrices, 0.0f, 0.0f, 1.0f);
        }
        ParticleBatchRenderer.renderBatches();
    }

    private static class CachedSettings {
        float iconSize = 16.0f;
        float gravity = 0.5f;
        float weight = 1.0f;
        float friction = 0.98f;
        float bounce = 0.7f;
        float groundFriction = 0.9f;
        float minSpeed = 0.5f;
        int trailLength = 15;
        boolean trailEnabled = false;
        float trailSizeModifier = 1.0f;
        int trailColor = -1;
        class_2960 iconTexture = class_2960.method_60654((String)"textures/trinket/atom.png");
        int iconColor = -1;
        boolean moduleEnabled = false;

        private CachedSettings() {
        }
    }

    private static class TrailFrame {
        float x;
        float y;
        long timestamp;

        TrailFrame(float x, float y, long timestamp) {
            this.x = x;
            this.y = y;
            this.timestamp = timestamp;
        }
    }

    public record Rectangle(class_241 min, class_241 max) {
    }

    private static class PositionRecord {
        float x;
        float y;
        long time;

        PositionRecord(float x, float y, long time) {
            this.x = x;
            this.y = y;
            this.time = time;
        }
    }
}

