/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL40C;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;

public final class Render2DUtil
implements QuickImports {
    private static final List<Quad> QUAD = new ArrayList<Quad>();

    public static void onRender(class_332 context) {
        class_4587 matrix = context.method_51448();
        Matrix4f matrix4f = matrix.method_23760().method_23761();
        if (!QUAD.isEmpty()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            QUAD.forEach(quad -> drawEngine.quad(matrix4f, buffer, quad.x, quad.y, quad.width, quad.height, quad.color));
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.disableBlend();
            QUAD.clear();
        }
    }

    public static void defaultDrawStack(@NonNull class_332 context, @NonNull class_1799 stack, float x, float y, boolean rect, boolean drawItemInSlot, float scale) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        class_4587 matrix = context.method_51448();
        if (rect) {
            blur.render(ShapeProperties.create(matrix, x, y, 16.0f * scale + 2.0f, 16.0f * scale + 2.0f).round(2.0f).color(ColorUtil.HALF_BLACK).build());
        }
        matrix.method_22903();
        matrix.method_46416(x + 1.0f, y + 1.0f, 0.0f);
        matrix.method_22905(scale, scale, 1.0f);
        context.method_51427(stack, 0, 0);
        if (drawItemInSlot) {
            context.method_51431(Render2DUtil.mc.field_1772, stack, 0, 0);
        }
        matrix.method_22909();
    }

    public static void drawTexture(@NonNull class_332 context, class_2960 id, float x, float y, float size, float round, int uvSize, int regionSize, int textureSize, int backgroundColor) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Render2DUtil.drawTexture(context, id, x, y, size, round, uvSize, regionSize, textureSize, backgroundColor, -1);
    }

    public static void drawTexture(@NonNull class_332 context, class_2960 id, float x, float y, float size, float round, int uvSize, int regionSize, int textureSize, int backgroundColor, int color) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        class_4587 matrix = context.method_51448();
        rectangle.render(ShapeProperties.create(matrix, x, y, size, size).round(round).color(backgroundColor).build());
        if (id != null) {
            matrix.method_22903();
            matrix.method_46416(x, y, 0.0f);
            matrix.method_22905(size, size, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)772, (int)773);
            Render2DUtil.drawTexture(matrix, id, 0, 0, 1.0f, 1.0f, uvSize, uvSize, regionSize, regionSize, textureSize, textureSize, color);
            RenderSystem.disableBlend();
            matrix.method_46416(-x, -y, 0.0f);
            matrix.method_22909();
        }
    }

    public static void drawHead(@NonNull class_332 context, class_2960 id, float x, float y, float size, float round, int backgroundColor, int color) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        class_4587 matrix = context.method_51448();
        rectangle.render(ShapeProperties.create(matrix, x, y, size, size).round(round).color(backgroundColor).build());
        if (id != null) {
            matrix.method_22903();
            matrix.method_46416(x, y, 0.0f);
            matrix.method_22905(size, size, 1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)id);
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)772, (int)773);
            GL40C.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL40C.glTexParameteri((int)3553, (int)10240, (int)9728);
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            Matrix4f matrix4f = matrix.method_23760().method_23761();
            float u1_base = 0.125f;
            float u2_base = 0.25f;
            float v1_base = 0.125f;
            float v2_base = 0.25f;
            float u1_overlay = 0.625f;
            float u2_overlay = 0.75f;
            float v1_overlay = 0.125f;
            float v2_overlay = 0.25f;
            buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_22913(u1_base, v1_base).method_39415(color);
            buffer.method_22918(matrix4f, 0.0f, 1.0f, 0.0f).method_22913(u1_base, v2_base).method_39415(color);
            buffer.method_22918(matrix4f, 1.0f, 1.0f, 0.0f).method_22913(u2_base, v2_base).method_39415(color);
            buffer.method_22918(matrix4f, 1.0f, 0.0f, 0.0f).method_22913(u2_base, v1_base).method_39415(color);
            buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_22913(u1_overlay, v1_overlay).method_39415(color);
            buffer.method_22918(matrix4f, 0.0f, 1.0f, 0.0f).method_22913(u1_overlay, v2_overlay).method_39415(color);
            buffer.method_22918(matrix4f, 1.0f, 1.0f, 0.0f).method_22913(u2_overlay, v2_overlay).method_39415(color);
            buffer.method_22918(matrix4f, 1.0f, 0.0f, 0.0f).method_22913(u2_overlay, v1_overlay).method_39415(color);
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.disableBlend();
            matrix.method_46416(-x, -y, 0.0f);
            matrix.method_22909();
        }
    }

    public static void drawSprite(@NonNull class_4587 matrix, @NonNull class_1058 sprite, float x, float y, float width, int height) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (sprite == null) {
            throw new NullPointerException("sprite is marked non-null but is null");
        }
        Render2DUtil.drawSprite(matrix, sprite, x, y, width, height, -1);
    }

    public static void drawSprite(@NonNull class_4587 matrix, @NonNull class_1058 sprite, float x, float y, float width, int height, int color) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (sprite == null) {
            throw new NullPointerException("sprite is marked non-null but is null");
        }
        if (width != 0.0f && height != 0) {
            Render2DUtil.drawTexturedQuad(matrix, sprite.method_45852(), x, x + width, y, y + (float)height, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), color);
        }
    }

    public static void drawTexture(@NonNull class_4587 matrix, @NonNull class_2960 texture, int x, int y, float width, float height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int color) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        Render2DUtil.drawTexture(matrix, texture, x, (float)x + width, y, (float)y + height, 0.0f, regionWidth, regionHeight, u, v, textureWidth, textureHeight, color);
    }

    public static void drawTexture(@NonNull class_4587 matrix, @NonNull class_2960 texture, float x1, float x2, float y1, float y2, float z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight, int color) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        Render2DUtil.drawTexturedQuad(matrix, texture, x1, x2, y1, y2, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight, color);
    }

    public static void drawTexturedQuad(@NonNull class_4587 matrix, @NonNull class_2960 texture, float x1, float x2, float y1, float y2, float u1, float u2, float v1, float v2, int color) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f matrix4f = matrix.method_23760().method_23761();
        buffer.method_22918(matrix4f, x1, y1, 0.0f).method_22913(u1, v1).method_39415(color);
        buffer.method_22918(matrix4f, x1, y2, 0.0f).method_22913(u1, v2).method_39415(color);
        buffer.method_22918(matrix4f, x2, y2, 0.0f).method_22913(u2, v2).method_39415(color);
        buffer.method_22918(matrix4f, x2, y1, 0.0f).method_22913(u2, v1).method_39415(color);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawQuad(float x, float y, float width, float height, int color) {
        QUAD.add(new Quad(x, y, width, height, ColorUtil.multAlpha(color, RenderSystem.getShaderColor()[3])));
    }

    private Render2DUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record Quad(float x, float y, float width, float height, int color) {
    }
}

