/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_897;
import net.minecraft.class_922;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.core.server.ServerLimitCfg;
import padej.soup.implement.features.modules.hud.TargetHud;

public final class TargetHudRenderer
implements QuickImports {
    public static void renderStyleZenith(class_332 context, class_1309 target, float x, float y, float width, float height, float health) {
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(18);
        float hp = PlayerIntersectionUtil.getHealth(target);
        float widthHp = 61.0f;
        String stringHp = ServerLimitCfg.showHp(target) ? PlayerIntersectionUtil.getHealthString(hp) : "??";
        blur.render(ShapeProperties.create(matrix, x, y, width, height).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(TargetHud.getInstance().backAlpha.getValue())).build());
        String displayName = VisibleUtils.getDisplayName(target);
        if (font.getStringWidth(displayName) > 60.0f) {
            ScissorManager scissorManager = Main.getInstance().getScissorManager();
            scissorManager.push(matrix.method_23760().method_23761(), x, y, width - 1.0f, height);
            font.drawString(matrix, displayName, x + 34.0f, y + 8.0f, ColorUtil.getText());
            scissorManager.pop();
        } else {
            font.drawString(matrix, displayName, x + 34.0f, y + 8.0f, ColorUtil.getText());
        }
        rectangle.render(ShapeProperties.create(matrix, x + 34.0f, y + 27.0f, widthHp, 2.0).round(0.75f).color(-16382190).build());
        rectangle.render(ShapeProperties.create(matrix, x + 34.0f, y + 27.0f, health, 2.0).softness(4.0f).round(1.0f).color(ColorUtil.roundClientColor(0.2f)).build());
        rectangle.render(ShapeProperties.create(matrix, x + 34.0f, y + 27.0f, health, 2.0).round(0.75f).color(ColorUtil.roundClientColor(1.0f)).build());
        float textWidth = Fonts.getSize(14).getStringWidth(stringHp);
        Fonts.getSize(14).drawString(matrix, stringHp, x + class_3532.method_15363((float)(34.0f + health - textWidth / 2.0f), (float)34.0f, (float)(95.0f - textWidth)), y + 21.0f, ColorUtil.getText());
        if (VisibleUtils.shouldShowSkin(target)) {
            TargetHudRenderer.renderFace(context, target, x + 5.0f, y + 5.5f, 3.0f, 25.0f);
        } else if (VisibleUtils.isPartiallyVisible(target)) {
            TargetHudRenderer.renderBlurFace(context, target, x + 5.0f, y + 5.5f, 3.0f, 25.0f);
        }
        if (ServerLimitCfg.showItems()) {
            TargetHudRenderer.renderArmorStyleZenith(context, target, x, y, width);
        }
    }

    public static void renderArmorStyleZenith(class_332 context, class_1309 target, float x, float y, float hudWidth) {
        List<class_1799> items = StreamSupport.stream(target.method_56675().spliterator(), false).filter(s -> !s.method_7960()).toList();
        if (!items.isEmpty()) {
            class_4587 matrix = context.method_51448();
            float armorX = x + hudWidth / 2.0f - (float)items.size() * 5.5f;
            float armorY = y - 13.0f;
            float itemX = -10.5f;
            matrix.method_22903();
            matrix.method_46416(armorX, armorY, -200.0f);
            blur.render(ShapeProperties.create(matrix, 0.0, 0.0, items.size() * 11, 11.0).round(2.5f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(TargetHud.getInstance().backAlpha.getValue())).build());
            for (class_1799 stack : items) {
                Render2DUtil.defaultDrawStack(context, stack, itemX += 11.0f, 0.5f, false, ServerLimitCfg.showItemsOverlay(), 0.5f);
            }
            matrix.method_22909();
        }
    }

    public static void renderStyleAres(class_332 context, class_1309 target, float x, float y, float width, float height, float health) {
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(18, Fonts.Type.INTER_BOLD);
        float hp = PlayerIntersectionUtil.getHealth(target);
        float widthHp = 68.0f;
        String stringHp = "HP: " + (ServerLimitCfg.showHp(target) ? PlayerIntersectionUtil.getHealthString(hp) : "??");
        float healthBarWidth = health * widthHp / 61.0f;
        blur.render(ShapeProperties.create(matrix, x, y, width, height).round(7.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(TargetHud.getInstance().backAlpha.getValue())).build());
        String displayName = VisibleUtils.getDisplayName(target);
        if (font.getStringWidth(displayName) > 60.0f) {
            ScissorManager scissorManager = Main.getInstance().getScissorManager();
            scissorManager.push(matrix.method_23760().method_23761(), x, y, width - 1.0f, height);
            font.drawString(matrix, displayName, x + 48.0f, y + 8.0f, ColorUtil.getText());
            scissorManager.pop();
        } else {
            font.drawString(matrix, displayName, x + 48.0f, y + 7.0f, ColorUtil.getText());
        }
        float barX = x + 48.0f;
        float barY = y + 32.0f;
        float barHeight = 9.0f;
        rectangle.render(ShapeProperties.create(matrix, barX, barY, widthHp, barHeight).round(1.5f).color(ColorUtil.getMainGuiColor()).build());
        rectangle.render(ShapeProperties.create(matrix, barX - 1.0f, barY - 1.0f, healthBarWidth + 2.0f, barHeight + 2.0f).softness(10.0f).round(2.0f).color(ColorUtil.roundClientColor(0.2f)).build());
        rectangle.render(ShapeProperties.create(matrix, barX, barY, healthBarWidth, barHeight).round(2.0f).color(ColorUtil.roundClientColor(1.0f)).build());
        Fonts.getSize(16, Fonts.Type.INTER_BOLD).drawString(matrix, stringHp, x + 48.0f, y + 20.5f, ColorUtil.getText());
        if (VisibleUtils.shouldShowSkin(target)) {
            TargetHudRenderer.renderFace(context, target, x + 3.0f, y + 3.0f, 6.0f, 40.0f);
        } else if (VisibleUtils.isPartiallyVisible(target)) {
            TargetHudRenderer.renderBlurFace(context, target, x + 3.0f, y + 3.0f, 6.0f, 40.0f);
        }
    }

    private static void renderFace(class_332 context, class_1309 target, float x, float y, float round, float size) {
        class_897 baseRenderer = mc.method_1561().method_3953((class_1297)target);
        if (!(baseRenderer instanceof class_922)) {
            return;
        }
        class_922 renderer = (class_922)baseRenderer;
        class_10042 state = (class_10042)renderer.method_62425((class_1297)target, tickCounter.method_60637(false));
        class_2960 textureLocation = renderer.method_3885(state);
        float hurtScale = 1.0f;
        if (target.field_6235 > 0) {
            float hurtProgress = (float)target.field_6235 / 10.0f;
            hurtScale = (float)(1.0 - (double)0.075f * Math.sin((double)hurtProgress * Math.PI));
        }
        class_4587 matrix = context.method_51448();
        matrix.method_22903();
        float centerX = x + size / 2.0f;
        float centerY = y + size / 2.0f;
        matrix.method_46416(centerX, centerY, 0.0f);
        matrix.method_22905(hurtScale, hurtScale, 1.0f);
        matrix.method_46416(-centerX, -centerY, 0.0f);
        Render2DUtil.drawHead(context, textureLocation, x, y, size, round, ColorUtil.getRect(1.0f), ColorUtil.multRed(-1, 1.0f + (float)target.field_6235 / 4.0f));
        matrix.method_22909();
    }

    private static void renderBlurFace(class_332 context, class_1309 target, float x, float y, float round, float size) {
        class_4587 matrix = context.method_51448();
        float hurtScale = 1.0f;
        if (target.field_6235 > 0) {
            float hurtProgress = (float)target.field_6235 / 10.0f;
            hurtScale = (float)(1.0 - (double)0.075f * Math.sin((double)hurtProgress * Math.PI));
        }
        matrix.method_22903();
        float centerX = x + size / 2.0f;
        float centerY = y + size / 2.0f;
        matrix.method_46416(centerX, centerY, 0.0f);
        matrix.method_22905(hurtScale, hurtScale, 1.0f);
        matrix.method_46416(-centerX, -centerY, 0.0f);
        int blurColor = ColorUtil.multRed(ColorUtil.getRect(0.2f), 1.0f + (float)target.field_6235 / 4.0f);
        blur.render(ShapeProperties.create(matrix, x, y, size, size).round(round).softness(1.0f).thickness(2.0f).color(blurColor).outlineColor(ColorUtil.getOutline()).build());
        matrix.method_22909();
    }

    private TargetHudRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

