/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.render.Render3DUtil;
import padej.soup.base.util.render.TargetRenderer;
import padej.soup.implement.features.modules.visuals.Trails;

public final class TrailRenderer
implements QuickImports {
    private static final ConcurrentLinkedQueue<TrailData> TRAIL_QUEUE = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<DebugLineData> DEBUG_LINE_QUEUE = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<TailData> TAIL_QUEUE = new ConcurrentLinkedQueue();

    public static void queueTrails(class_4587 stack, List<Trails.Trail> trails, Trails module) {
        if (trails.isEmpty() || trails.size() < 2) {
            return;
        }
        TRAIL_QUEUE.add(new TrailData(new Matrix4f((Matrix4fc)stack.method_23760().method_23761()), trails, module));
    }

    public static void queueDebugLines(class_4587 stack, List<Trails.Trail> trails, Trails module) {
        if (trails.isEmpty() || trails.size() < 2) {
            return;
        }
        DEBUG_LINE_QUEUE.add(new DebugLineData(new Matrix4f((Matrix4fc)stack.method_23760().method_23761()), trails, module));
    }

    public static void queueTails(class_4587 stack, List<Trails.Trail> trails, Trails module) {
        if (trails.isEmpty()) {
            return;
        }
        TAIL_QUEUE.add(new TailData(new Matrix4f((Matrix4fc)stack.method_23760().method_23761()), trails, module));
    }

    public static void renderBatches() {
        if (!TRAIL_QUEUE.isEmpty()) {
            TrailRenderer.renderTrailBatch();
        }
        if (!DEBUG_LINE_QUEUE.isEmpty()) {
            TrailRenderer.renderDebugLineBatch();
        }
        if (!TAIL_QUEUE.isEmpty()) {
            TrailRenderer.renderTailBatch();
        }
    }

    private static void renderTrailBatch() {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        while (!TRAIL_QUEUE.isEmpty()) {
            TrailData data = TRAIL_QUEUE.poll();
            List<Trails.Trail> trails = data.trails;
            Trails module = data.module;
            Matrix4f matrix = data.matrix;
            float heightPercent = module.getHeight().getValue() / 100.0f;
            int baseAlpha = (int)(255.0f * (module.getTrailAlpha().getValue() / 100.0f));
            for (int i = 0; i < trails.size() - 1; ++i) {
                int nextTopAlpha;
                int nextMidAlpha;
                int nextBottomAlpha;
                int currentTopAlpha;
                int currentMidAlpha;
                int currentBottomAlpha;
                Trails.Trail current = trails.get(i);
                Trails.Trail next = trails.get(i + 1);
                class_243 currentPos = current.interpolate(tickCounter.method_60637(true));
                class_243 nextPos = next.interpolate(tickCounter.method_60637(true));
                float currentAlpha = current.getAlpha();
                float nextAlpha = next.getAlpha();
                float currentAlphaFactor = currentAlpha * (float)baseAlpha;
                float nextAlphaFactor = nextAlpha * (float)baseAlpha;
                float currentProgress = current.getProgress();
                float nextProgress = next.getProgress();
                Color currentColor = TrailRenderer.getAnimatedColor(current, module, currentProgress, 1.0f - currentProgress);
                Color nextColor = TrailRenderer.getAnimatedColor(next, module, nextProgress, 1.0f - nextProgress);
                float currentTrailHeight = current.entityHeight * heightPercent;
                float nextTrailHeight = next.entityHeight * heightPercent;
                float currentCenterOffset = current.entityHeight / 2.0f;
                float nextCenterOffset = next.entityHeight / 2.0f;
                float x1 = (float)currentPos.field_1352;
                float y1 = (float)currentPos.field_1351 + currentCenterOffset - currentTrailHeight / 2.0f + module.getDown().getValue();
                float z1 = (float)currentPos.field_1350;
                float x2 = (float)nextPos.field_1352;
                float y2 = (float)nextPos.field_1351 + nextCenterOffset - nextTrailHeight / 2.0f + module.getDown().getValue();
                float z2 = (float)nextPos.field_1350;
                if (module.getStyle().isSelected("Faded")) {
                    currentBottomAlpha = (int)((float)TrailRenderer.computeFadedAlpha(0.0f, currentTrailHeight) * (currentAlphaFactor / 255.0f));
                    currentMidAlpha = (int)((float)TrailRenderer.computeFadedAlpha(currentTrailHeight / 2.0f, currentTrailHeight) * (currentAlphaFactor / 255.0f));
                    currentTopAlpha = module.getRenderHalf().isValue() ? 0 : (int)((float)TrailRenderer.computeFadedAlpha(currentTrailHeight, currentTrailHeight) * (currentAlphaFactor / 255.0f));
                    nextBottomAlpha = (int)((float)TrailRenderer.computeFadedAlpha(0.0f, nextTrailHeight) * (nextAlphaFactor / 255.0f));
                    nextMidAlpha = (int)((float)TrailRenderer.computeFadedAlpha(nextTrailHeight / 2.0f, nextTrailHeight) * (nextAlphaFactor / 255.0f));
                    nextTopAlpha = module.getRenderHalf().isValue() ? 0 : (int)((float)TrailRenderer.computeFadedAlpha(nextTrailHeight, nextTrailHeight) * (nextAlphaFactor / 255.0f));
                } else if (module.getStyle().isSelected("Invert")) {
                    float alphaFactorValue = module.getAlphaFactor().getValue();
                    currentBottomAlpha = (int)((float)TrailRenderer.computeFadedAlphaInvert(0.0f, currentTrailHeight, alphaFactorValue) * (currentAlphaFactor / 255.0f));
                    currentMidAlpha = (int)((float)TrailRenderer.computeFadedAlphaInvert(currentTrailHeight / 2.0f, currentTrailHeight, alphaFactorValue) * (currentAlphaFactor / 255.0f));
                    currentTopAlpha = module.getRenderHalf().isValue() ? 0 : (int)((float)TrailRenderer.computeFadedAlphaInvert(currentTrailHeight, currentTrailHeight, alphaFactorValue) * (currentAlphaFactor / 255.0f));
                    nextBottomAlpha = (int)((float)TrailRenderer.computeFadedAlphaInvert(0.0f, nextTrailHeight, alphaFactorValue) * (nextAlphaFactor / 255.0f));
                    nextMidAlpha = (int)((float)TrailRenderer.computeFadedAlphaInvert(nextTrailHeight / 2.0f, nextTrailHeight, alphaFactorValue) * (nextAlphaFactor / 255.0f));
                    nextTopAlpha = module.getRenderHalf().isValue() ? 0 : (int)((float)TrailRenderer.computeFadedAlphaInvert(nextTrailHeight, nextTrailHeight, alphaFactorValue) * (nextAlphaFactor / 255.0f));
                } else {
                    currentBottomAlpha = (int)currentAlphaFactor;
                    currentMidAlpha = (int)currentAlphaFactor;
                    currentTopAlpha = module.getRenderHalf().isValue() ? 0 : (int)currentAlphaFactor;
                    nextBottomAlpha = (int)nextAlphaFactor;
                    nextMidAlpha = (int)nextAlphaFactor;
                    nextTopAlpha = module.getRenderHalf().isValue() ? 0 : (int)nextAlphaFactor;
                }
                bufferBuilder.method_22918(matrix, x1, y1, z1).method_1336(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentBottomAlpha);
                bufferBuilder.method_22918(matrix, x2, y2, z2).method_1336(nextColor.getRed(), nextColor.getGreen(), nextColor.getBlue(), nextBottomAlpha);
                bufferBuilder.method_22918(matrix, x2, y2 + nextTrailHeight / 2.0f, z2).method_1336(nextColor.getRed(), nextColor.getGreen(), nextColor.getBlue(), nextMidAlpha);
                bufferBuilder.method_22918(matrix, x1, y1 + currentTrailHeight / 2.0f, z1).method_1336(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentMidAlpha);
                if (module.getRenderHalf().isValue()) continue;
                bufferBuilder.method_22918(matrix, x1, y1 + currentTrailHeight / 2.0f, z1).method_1336(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentMidAlpha);
                bufferBuilder.method_22918(matrix, x2, y2 + nextTrailHeight / 2.0f, z2).method_1336(nextColor.getRed(), nextColor.getGreen(), nextColor.getBlue(), nextMidAlpha);
                bufferBuilder.method_22918(matrix, x2, y2 + nextTrailHeight, z2).method_1336(nextColor.getRed(), nextColor.getGreen(), nextColor.getBlue(), nextTopAlpha);
                bufferBuilder.method_22918(matrix, x1, y1 + currentTrailHeight, z1).method_1336(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentTopAlpha);
            }
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    private static void renderDebugLineBatch() {
        GL11.glHint((int)3154, (int)4354);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((class_10156)class_10142.field_53864);
        while (!DEBUG_LINE_QUEUE.isEmpty()) {
            DebugLineData data = DEBUG_LINE_QUEUE.poll();
            List<Trails.Trail> trails = data.trails;
            Trails module = data.module;
            RenderSystem.lineWidth((float)module.getLineWidth().getValue());
            float heightPercent = module.getHeight().getValue() / 100.0f;
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
            class_4587 tempStack = new class_4587();
            tempStack.method_23760().method_23761().set((Matrix4fc)data.matrix);
            class_4587.class_4665 entry = tempStack.method_23760();
            for (int i = 0; i < trails.size() - 1; ++i) {
                Trails.Trail current = trails.get(i);
                Trails.Trail next = trails.get(i + 1);
                class_243 currentPos = current.interpolate(tickCounter.method_60637(true));
                class_243 nextPos = next.interpolate(tickCounter.method_60637(true));
                float currentAlpha = current.getAlpha();
                float nextAlpha = next.getAlpha();
                float currentTrailHeight = current.entityHeight * heightPercent;
                float nextTrailHeight = next.entityHeight * heightPercent;
                float currentCenterOffset = current.entityHeight / 2.0f;
                float nextCenterOffset = next.entityHeight / 2.0f;
                float currentBottomY = currentCenterOffset - currentTrailHeight / 2.0f + module.getDown().getValue();
                float currentTopY = currentCenterOffset + currentTrailHeight / 2.0f + module.getDown().getValue();
                float nextBottomY = nextCenterOffset - nextTrailHeight / 2.0f + module.getDown().getValue();
                float nextTopY = nextCenterOffset + nextTrailHeight / 2.0f + module.getDown().getValue();
                float currentProgress = current.getProgress();
                float nextProgress = next.getProgress();
                Color currentColor = TrailRenderer.getAnimatedColor(current, module, currentProgress, 1.0f - currentProgress);
                Color nextColor = TrailRenderer.getAnimatedColor(next, module, nextProgress, 1.0f - nextProgress);
                float avgAlpha = (currentAlpha + nextAlpha) / 2.0f;
                int avgR = (currentColor.getRed() + nextColor.getRed()) / 2;
                int avgG = (currentColor.getGreen() + nextColor.getGreen()) / 2;
                int avgB = (currentColor.getBlue() + nextColor.getBlue()) / 2;
                int avgA = (int)(avgAlpha * 255.0f);
                int avgColor = avgA << 24 | avgR << 16 | avgG << 8 | avgB;
                class_243 bottomStart = new class_243(currentPos.field_1352, currentPos.field_1351 + (double)currentBottomY, currentPos.field_1350);
                class_243 bottomEnd = new class_243(nextPos.field_1352, nextPos.field_1351 + (double)nextBottomY, nextPos.field_1350);
                Render3DUtil.vertexLine(entry, (class_4588)buffer, bottomStart.method_46409(), bottomEnd.method_46409(), avgColor, avgColor);
                if (module.getRenderHalf().isValue()) continue;
                class_243 topStart = new class_243(currentPos.field_1352, currentPos.field_1351 + (double)currentTopY, currentPos.field_1350);
                class_243 topEnd = new class_243(nextPos.field_1352, nextPos.field_1351 + (double)nextTopY, nextPos.field_1350);
                Render3DUtil.vertexLine(entry, (class_4588)buffer, topStart.method_46409(), topEnd.method_46409(), avgColor, avgColor);
            }
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static void renderTailBatch() {
        class_4184 camera = TrailRenderer.mc.field_1773.method_19418();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"textures/particles/firefly.png"));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float alpha = 1.0f;
        while (!TAIL_QUEUE.isEmpty()) {
            TailData data = TAIL_QUEUE.poll();
            List<Trails.Trail> trails = data.trails;
            Trails module = data.module;
            for (Trails.Trail ctx : trails) {
                int finalColor;
                int animatedAlpha;
                class_4587 matrices = new class_4587();
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
                class_243 pos = ctx.interpolate(tickCounter.method_60637(true));
                class_243 cameraPos = camera.method_19326();
                matrices.method_22904(pos.field_1352 - cameraPos.field_1352, pos.field_1351 - cameraPos.field_1351 + (double)0.9f, pos.field_1350 - cameraPos.field_1350);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                Matrix4f matrix = matrices.method_23760().method_23761();
                float sc = 0.6f;
                float animAlpha = alpha * ctx.getAlpha();
                if (module.getColorMode().isSelected("Custom")) {
                    int[] colors = module.getCustomColors();
                    if (colors != null && colors.length > 0) {
                        if (module.getColorAnimation().isSelected("Wave")) {
                            int color = TrailRenderer.getWaveColor(colors, module, animAlpha);
                            bufferBuilder.method_22918(matrix, -sc, sc, 0.0f).method_22913(0.0f, 1.0f).method_39415(color);
                            bufferBuilder.method_22918(matrix, sc, sc, 0.0f).method_22913(1.0f, 1.0f).method_39415(color);
                            bufferBuilder.method_22918(matrix, sc, -sc, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
                            bufferBuilder.method_22918(matrix, -sc, -sc, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
                            continue;
                        }
                        int color1 = TrailRenderer.getVertexGradientColor(0, colors, module, animAlpha);
                        int color2 = TrailRenderer.getVertexGradientColor(90, colors, module, animAlpha);
                        int color3 = TrailRenderer.getVertexGradientColor(180, colors, module, animAlpha);
                        int color4 = TrailRenderer.getVertexGradientColor(270, colors, module, animAlpha);
                        bufferBuilder.method_22918(matrix, -sc, sc, 0.0f).method_22913(0.0f, 1.0f).method_39415(color1);
                        bufferBuilder.method_22918(matrix, sc, sc, 0.0f).method_22913(1.0f, 1.0f).method_39415(color2);
                        bufferBuilder.method_22918(matrix, sc, -sc, 0.0f).method_22913(1.0f, 0.0f).method_39415(color3);
                        bufferBuilder.method_22918(matrix, -sc, -sc, 0.0f).method_22913(0.0f, 0.0f).method_39415(color4);
                        continue;
                    }
                    int col = ctx.color().getRGB();
                    animatedAlpha = (int)(animAlpha * 255.0f);
                    finalColor = ColorUtil.replAlpha(col, animatedAlpha);
                    bufferBuilder.method_22918(matrix, -sc, sc, 0.0f).method_22913(0.0f, 1.0f).method_39415(finalColor);
                    bufferBuilder.method_22918(matrix, sc, sc, 0.0f).method_22913(1.0f, 1.0f).method_39415(finalColor);
                    bufferBuilder.method_22918(matrix, sc, -sc, 0.0f).method_22913(1.0f, 0.0f).method_39415(finalColor);
                    bufferBuilder.method_22918(matrix, -sc, -sc, 0.0f).method_22913(0.0f, 0.0f).method_39415(finalColor);
                    continue;
                }
                Color col = ctx.color();
                float colorFactor = ctx.getProgress();
                col = TrailRenderer.interpolateColor(col, Color.WHITE, (float)Math.pow(1.0f - colorFactor, 2.0));
                animatedAlpha = (int)(animAlpha * 255.0f);
                finalColor = ColorUtil.replAlpha(col.getRGB(), animatedAlpha);
                bufferBuilder.method_22918(matrix, -sc, sc, 0.0f).method_22913(0.0f, 1.0f).method_39415(finalColor);
                bufferBuilder.method_22918(matrix, sc, sc, 0.0f).method_22913(1.0f, 1.0f).method_39415(finalColor);
                bufferBuilder.method_22918(matrix, sc, -sc, 0.0f).method_22913(1.0f, 0.0f).method_39415(finalColor);
                bufferBuilder.method_22918(matrix, -sc, -sc, 0.0f).method_22913(0.0f, 0.0f).method_39415(finalColor);
            }
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    private static int getWaveColor(int[] colors, Trails module, float alpha) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], alpha);
        }
        if (colors.length == 2) {
            int angle = (int)(System.currentTimeMillis() / 8L % 360L);
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.multAlpha(ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f), alpha);
        }
        float timeProgress = (float)(System.currentTimeMillis() / 10L % ((long)colors.length * 360L)) / 360.0f;
        int index1 = (int)Math.floor(timeProgress) % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = timeProgress - (float)((int)Math.floor(timeProgress));
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), alpha);
    }

    private static int getVertexGradientColor(int angleOffset, int[] colors, Trails module, float alpha) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], alpha);
        }
        int angle = (int)((System.currentTimeMillis() / 8L + (long)angleOffset) % 360L);
        if (colors.length == 2) {
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.multAlpha(ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f), alpha);
        }
        float progress = (float)angle / 360.0f;
        float colorIndex = progress * (float)colors.length;
        int index1 = (int)colorIndex % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = colorIndex - (float)((int)colorIndex);
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), alpha);
    }

    private static Color interpolateColor(Color c1, Color c2, float percent) {
        int r = (int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * percent);
        int g = (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * percent);
        int b = (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * percent);
        return new Color(r, g, b);
    }

    private static int computeFadedAlpha(float yOffset, float height) {
        float yRelative = yOffset / height;
        if (yRelative <= 0.5f) {
            return (int)((1.0f - yRelative / 0.5f) * 255.0f);
        }
        return (int)((yRelative - 0.5f) / 0.5f * 255.0f);
    }

    private static int computeFadedAlphaInvert(float yOffset, float height, float alphaFactorPercent) {
        float yRelative = yOffset / height;
        int alphaFactor = (int)(255.0f * (alphaFactorPercent / 100.0f));
        if (yRelative <= 0.5f) {
            return (int)((float)alphaFactor + yRelative / 0.5f * (float)(255 - alphaFactor));
        }
        return (int)(255.0f - (yRelative - 0.5f) / 0.5f * (float)(255 - alphaFactor));
    }

    private static Color getAnimatedColor(Trails.Trail trail, Trails module, float x, float y) {
        if (module.getColorMode().isSelected("Custom")) {
            int[] colors = module.getCustomColors();
            if (colors != null && colors.length > 0) {
                if (module.getColorAnimation().isSelected("Wave")) {
                    int color = TrailRenderer.getWaveColor(colors, module, 1.0f);
                    return new Color(color, true);
                }
                float progress = x;
                float colorIndex = progress * (float)colors.length;
                int index1 = Math.min((int)colorIndex, colors.length - 1);
                int index2 = Math.min(index1 + 1, colors.length - 1);
                float lerp = colorIndex - (float)((int)colorIndex);
                int color = ColorUtil.overCol(colors[index1], colors[index2], lerp);
                return new Color(color, true);
            }
            return trail.color();
        }
        Color c1 = TargetRenderer.topLeft;
        Color c2 = TargetRenderer.topRight;
        Color c3 = TargetRenderer.bottomRight;
        Color c4 = TargetRenderer.bottomLeft;
        if (c1 == null) {
            c1 = new Color(ColorUtil.getClientColor());
        }
        if (c2 == null) {
            c2 = c1;
        }
        if (c3 == null) {
            c3 = c1;
        }
        if (c4 == null) {
            c4 = c1;
        }
        Color top = TrailRenderer.lerpColor(c1, c2, x);
        Color bottom = TrailRenderer.lerpColor(c4, c3, x);
        return TrailRenderer.lerpColor(top, bottom, y);
    }

    private static Color lerpColor(Color a, Color b, float t) {
        int r = (int)((float)a.getRed() + (float)(b.getRed() - a.getRed()) * t);
        int g = (int)((float)a.getGreen() + (float)(b.getGreen() - a.getGreen()) * t);
        int b_ = (int)((float)a.getBlue() + (float)(b.getBlue() - a.getBlue()) * t);
        return new Color(r, g, b_);
    }

    private TrailRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record TrailData(Matrix4f matrix, List<Trails.Trail> trails, Trails module) {
    }

    private record DebugLineData(Matrix4f matrix, List<Trails.Trail> trails, Trails module) {
    }

    private record TailData(Matrix4f matrix, List<Trails.Trail> trails, Trails module) {
    }
}

