/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.spatial;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import padej.soup.base.util.spatial.SpatialGrid3D;

public class BlockCollisionGrid {
    private final SpatialGrid3D<class_2338> grid;
    private final Set<class_2338> trackedBlocks;
    private final float cellSize = 1.0f;
    private final float collisionRadius;
    private final float repulsionStrength;
    private double lastUpdateX = Double.NaN;
    private double lastUpdateY = Double.NaN;
    private double lastUpdateZ = Double.NaN;
    private int ticksSinceUpdate = 0;
    private static final int UPDATE_INTERVAL = 5;
    private static final double MOVEMENT_THRESHOLD = 3.0;

    public BlockCollisionGrid(float collisionRadius, float repulsionStrength) {
        this.grid = new SpatialGrid3D(1.0f);
        this.trackedBlocks = new HashSet<class_2338>();
        this.collisionRadius = collisionRadius;
        this.repulsionStrength = repulsionStrength;
    }

    public void updateBlocks(class_1937 world, double centerX, double centerY, double centerZ, int radius) {
        if (world == null) {
            return;
        }
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate < 5) {
            if (!Double.isNaN(this.lastUpdateX)) {
                double dx = centerX - this.lastUpdateX;
                double dy = centerY - this.lastUpdateY;
                double dz = centerZ - this.lastUpdateZ;
                double distSq = dx * dx + dy * dy + dz * dz;
                if (distSq < 9.0) {
                    return;
                }
            } else {
                return;
            }
        }
        this.ticksSinceUpdate = 0;
        this.lastUpdateX = centerX;
        this.lastUpdateY = centerY;
        this.lastUpdateZ = centerZ;
        int optimizedRadius = Math.min(radius, 10);
        HashSet<class_2338> newBlocks = new HashSet<class_2338>();
        int minX = (int)Math.floor(centerX - (double)optimizedRadius);
        int maxX = (int)Math.floor(centerX + (double)optimizedRadius);
        int minY = (int)Math.floor(centerY - (double)optimizedRadius);
        int maxY = (int)Math.floor(centerY + (double)optimizedRadius);
        int minZ = (int)Math.floor(centerZ - (double)optimizedRadius);
        int maxZ = (int)Math.floor(centerZ + (double)optimizedRadius);
        minY = Math.max(-64, minY);
        maxY = Math.min(319, maxY);
        double radiusSq = optimizedRadius * optimizedRadius;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos;
                    class_2680 state;
                    double dx = (double)x + 0.5 - centerX;
                    double dy = (double)y + 0.5 - centerY;
                    double dz = (double)z + 0.5 - centerZ;
                    if (dx * dx + dy * dy + dz * dz > radiusSq || (state = world.method_8320(pos = new class_2338(x, y, z))).method_26215() || !state.method_26212((class_1922)world, pos)) continue;
                    newBlocks.add(pos);
                }
            }
        }
        for (class_2338 pos : this.trackedBlocks) {
            if (newBlocks.contains(pos)) continue;
            this.grid.remove(pos, (float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
        }
        for (class_2338 pos : newBlocks) {
            if (this.trackedBlocks.contains(pos)) continue;
            this.grid.insert(pos, (float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
        }
        this.trackedBlocks.clear();
        this.trackedBlocks.addAll(newBlocks);
    }

    public float[] calculateRepulsion(float particleX, float particleY, float particleZ) {
        float[] force = new float[]{0.0f, 0.0f, 0.0f};
        List<SpatialGrid3D.GridEntry<class_2338>> nearbyBlocks = this.grid.queryRadiusWithPositions(particleX, particleY, particleZ, this.collisionRadius);
        if (nearbyBlocks.isEmpty()) {
            return force;
        }
        for (SpatialGrid3D.GridEntry<class_2338> entry : nearbyBlocks) {
            float dist;
            float strength;
            float blockZ;
            float dz;
            float blockY;
            float dy;
            float blockX = entry.getX();
            float dx = particleX - blockX;
            float distSq = dx * dx + (dy = particleY - (blockY = entry.getY())) * dy + (dz = particleZ - (blockZ = entry.getZ())) * dz;
            if (distSq < 0.01f) {
                distSq = 0.01f;
            }
            if (!((strength = this.repulsionStrength * (1.0f - (dist = (float)Math.sqrt(distSq)) / this.collisionRadius)) > 0.0f)) continue;
            float invDist = 1.0f / dist;
            force[0] = force[0] + dx * invDist * strength;
            force[1] = force[1] + dy * invDist * strength;
            force[2] = force[2] + dz * invDist * strength;
        }
        return force;
    }

    public boolean hasCollision(float x, float y, float z) {
        List<class_2338> nearby = this.grid.queryRadius(x, y, z, this.collisionRadius);
        return !nearby.isEmpty();
    }

    public void clear() {
        this.grid.clear();
        this.trackedBlocks.clear();
    }

    public int getBlockCount() {
        return this.trackedBlocks.size();
    }
}

